/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Joiner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.TableScan;

public class BeamIOSourceRel
extends TableScan
implements BeamRelNode {
    public BeamIOSourceRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        super(cluster, traitSet, table);
    }

    @Override
    public PCollection<BeamRecord> buildBeamPipeline(PCollectionTuple inputPCollections, BeamSqlEnv sqlEnv) throws Exception {
        String sourceName = Joiner.on('.').join(this.getTable().getQualifiedName());
        TupleTag sourceTupleTag = new TupleTag(sourceName);
        if (inputPCollections.has(sourceTupleTag)) {
            PCollection sourceStream = inputPCollections.get(new TupleTag(sourceName));
            return sourceStream;
        }
        BeamSqlTable sourceTable = sqlEnv.findTable(sourceName);
        return sourceTable.buildIOReader(inputPCollections.getPipeline()).setCoder((Coder)CalciteUtils.toBeamRowType(this.getRowType()).getRecordCoder());
    }
}

