/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.sql.BeamSqlRecordHelper;
import org.apache.beam.sdk.values.BeamRecordType;

public class BeamRecordSqlType
extends BeamRecordType {
    private static final Map<Integer, Class> SQL_TYPE_TO_JAVA_CLASS = new HashMap<Integer, Class>();
    public List<Integer> fieldTypes;

    protected BeamRecordSqlType(List<String> fieldsName, List<Coder> fieldsCoder) {
        super(fieldsName, fieldsCoder);
    }

    private BeamRecordSqlType(List<String> fieldsName, List<Integer> fieldTypes, List<Coder> fieldsCoder) {
        super(fieldsName, fieldsCoder);
        this.fieldTypes = fieldTypes;
    }

    public static BeamRecordSqlType create(List<String> fieldNames, List<Integer> fieldTypes) {
        if (fieldNames.size() != fieldTypes.size()) {
            throw new IllegalStateException("the sizes of 'dataType' and 'fieldTypes' must match.");
        }
        ArrayList<Coder> fieldCoders = new ArrayList<Coder>(fieldTypes.size());
        block13: for (int idx = 0; idx < fieldTypes.size(); ++idx) {
            switch (fieldTypes.get(idx)) {
                case 4: {
                    fieldCoders.add((Coder)BigEndianIntegerCoder.of());
                    continue block13;
                }
                case 5: {
                    fieldCoders.add((Coder)BeamSqlRecordHelper.ShortCoder.of());
                    continue block13;
                }
                case -6: {
                    fieldCoders.add((Coder)ByteCoder.of());
                    continue block13;
                }
                case 8: {
                    fieldCoders.add((Coder)BeamSqlRecordHelper.DoubleCoder.of());
                    continue block13;
                }
                case 6: {
                    fieldCoders.add((Coder)BeamSqlRecordHelper.FloatCoder.of());
                    continue block13;
                }
                case 3: {
                    fieldCoders.add((Coder)BigDecimalCoder.of());
                    continue block13;
                }
                case -5: {
                    fieldCoders.add((Coder)BigEndianLongCoder.of());
                    continue block13;
                }
                case 1: 
                case 12: {
                    fieldCoders.add((Coder)StringUtf8Coder.of());
                    continue block13;
                }
                case 92: {
                    fieldCoders.add((Coder)BeamSqlRecordHelper.TimeCoder.of());
                    continue block13;
                }
                case 91: 
                case 93: {
                    fieldCoders.add((Coder)BeamSqlRecordHelper.DateCoder.of());
                    continue block13;
                }
                case 16: {
                    fieldCoders.add((Coder)BeamSqlRecordHelper.BooleanCoder.of());
                    continue block13;
                }
                default: {
                    throw new UnsupportedOperationException("Data type: " + fieldTypes.get(idx) + " not supported yet!");
                }
            }
        }
        return new BeamRecordSqlType(fieldNames, fieldTypes, fieldCoders);
    }

    public void validateValueType(int index, Object fieldValue) throws IllegalArgumentException {
        if (null == fieldValue) {
            return;
        }
        int fieldType = this.fieldTypes.get(index);
        Class javaClazz = SQL_TYPE_TO_JAVA_CLASS.get(fieldType);
        if (javaClazz == null) {
            throw new IllegalArgumentException("Data type: " + fieldType + " not supported yet!");
        }
        if (!fieldValue.getClass().equals(javaClazz)) {
            throw new IllegalArgumentException(String.format("[%s](%s) doesn't match type [%s]", fieldValue, fieldValue.getClass(), fieldType));
        }
    }

    public List<Integer> getFieldTypes() {
        return Collections.unmodifiableList(this.fieldTypes);
    }

    public Integer getFieldTypeByIndex(int index) {
        return this.fieldTypes.get(index);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BeamRecordSqlType) {
            BeamRecordSqlType ins = (BeamRecordSqlType)((Object)obj);
            return this.fieldTypes.equals(ins.getFieldTypes()) && this.getFieldNames().equals(ins.getFieldNames());
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.getFieldNames().hashCode() + this.getFieldTypes().hashCode();
    }

    public String toString() {
        return "BeamRecordSqlType [fieldNames=" + this.getFieldNames() + ", fieldTypes=" + this.fieldTypes + "]";
    }

    static {
        SQL_TYPE_TO_JAVA_CLASS.put(-6, Byte.class);
        SQL_TYPE_TO_JAVA_CLASS.put(5, Short.class);
        SQL_TYPE_TO_JAVA_CLASS.put(4, Integer.class);
        SQL_TYPE_TO_JAVA_CLASS.put(-5, Long.class);
        SQL_TYPE_TO_JAVA_CLASS.put(6, Float.class);
        SQL_TYPE_TO_JAVA_CLASS.put(8, Double.class);
        SQL_TYPE_TO_JAVA_CLASS.put(3, BigDecimal.class);
        SQL_TYPE_TO_JAVA_CLASS.put(16, Boolean.class);
        SQL_TYPE_TO_JAVA_CLASS.put(1, String.class);
        SQL_TYPE_TO_JAVA_CLASS.put(12, String.class);
        SQL_TYPE_TO_JAVA_CLASS.put(92, GregorianCalendar.class);
        SQL_TYPE_TO_JAVA_CLASS.put(91, Date.class);
        SQL_TYPE_TO_JAVA_CLASS.put(93, Date.class);
    }
}

