/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;

final class AutoValue_SqlTransform
extends SqlTransform {
    private final String queryString;
    private final List<SqlTransform.UdfDefinition> udfDefinitions;
    private final List<SqlTransform.UdafDefinition> udafDefinitions;
    private final boolean autoUdfUdafLoad;
    private final Map<String, TableProvider> tableProviderMap;
    private final String defaultTableProvider;

    private AutoValue_SqlTransform(String queryString, List<SqlTransform.UdfDefinition> udfDefinitions, List<SqlTransform.UdafDefinition> udafDefinitions, boolean autoUdfUdafLoad, Map<String, TableProvider> tableProviderMap, @Nullable String defaultTableProvider) {
        this.queryString = queryString;
        this.udfDefinitions = udfDefinitions;
        this.udafDefinitions = udafDefinitions;
        this.autoUdfUdafLoad = autoUdfUdafLoad;
        this.tableProviderMap = tableProviderMap;
        this.defaultTableProvider = defaultTableProvider;
    }

    @Override
    String queryString() {
        return this.queryString;
    }

    @Override
    List<SqlTransform.UdfDefinition> udfDefinitions() {
        return this.udfDefinitions;
    }

    @Override
    List<SqlTransform.UdafDefinition> udafDefinitions() {
        return this.udafDefinitions;
    }

    @Override
    boolean autoUdfUdafLoad() {
        return this.autoUdfUdafLoad;
    }

    @Override
    Map<String, TableProvider> tableProviderMap() {
        return this.tableProviderMap;
    }

    @Override
    @Nullable
    String defaultTableProvider() {
        return this.defaultTableProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SqlTransform) {
            SqlTransform that = (SqlTransform)((Object)o);
            return this.queryString.equals(that.queryString()) && this.udfDefinitions.equals(that.udfDefinitions()) && this.udafDefinitions.equals(that.udafDefinitions()) && this.autoUdfUdafLoad == that.autoUdfUdafLoad() && this.tableProviderMap.equals(that.tableProviderMap()) && (this.defaultTableProvider == null ? that.defaultTableProvider() == null : this.defaultTableProvider.equals(that.defaultTableProvider()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.queryString.hashCode();
        h$ *= 1000003;
        h$ ^= this.udfDefinitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.udafDefinitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoUdfUdafLoad ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.tableProviderMap.hashCode();
        h$ *= 1000003;
        return h$ ^= this.defaultTableProvider == null ? 0 : this.defaultTableProvider.hashCode();
    }

    @Override
    SqlTransform.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SqlTransform.Builder {
        private String queryString;
        private List<SqlTransform.UdfDefinition> udfDefinitions;
        private List<SqlTransform.UdafDefinition> udafDefinitions;
        private Boolean autoUdfUdafLoad;
        private Map<String, TableProvider> tableProviderMap;
        private String defaultTableProvider;

        Builder() {
        }

        private Builder(SqlTransform source) {
            this.queryString = source.queryString();
            this.udfDefinitions = source.udfDefinitions();
            this.udafDefinitions = source.udafDefinitions();
            this.autoUdfUdafLoad = source.autoUdfUdafLoad();
            this.tableProviderMap = source.tableProviderMap();
            this.defaultTableProvider = source.defaultTableProvider();
        }

        @Override
        SqlTransform.Builder setQueryString(String queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        SqlTransform.Builder setUdfDefinitions(List<SqlTransform.UdfDefinition> udfDefinitions) {
            if (udfDefinitions == null) {
                throw new NullPointerException("Null udfDefinitions");
            }
            this.udfDefinitions = udfDefinitions;
            return this;
        }

        @Override
        SqlTransform.Builder setUdafDefinitions(List<SqlTransform.UdafDefinition> udafDefinitions) {
            if (udafDefinitions == null) {
                throw new NullPointerException("Null udafDefinitions");
            }
            this.udafDefinitions = udafDefinitions;
            return this;
        }

        @Override
        SqlTransform.Builder setAutoUdfUdafLoad(boolean autoUdfUdafLoad) {
            this.autoUdfUdafLoad = autoUdfUdafLoad;
            return this;
        }

        @Override
        SqlTransform.Builder setTableProviderMap(Map<String, TableProvider> tableProviderMap) {
            if (tableProviderMap == null) {
                throw new NullPointerException("Null tableProviderMap");
            }
            this.tableProviderMap = tableProviderMap;
            return this;
        }

        @Override
        SqlTransform.Builder setDefaultTableProvider(@Nullable String defaultTableProvider) {
            this.defaultTableProvider = defaultTableProvider;
            return this;
        }

        @Override
        SqlTransform build() {
            String missing = "";
            if (this.queryString == null) {
                missing = missing + " queryString";
            }
            if (this.udfDefinitions == null) {
                missing = missing + " udfDefinitions";
            }
            if (this.udafDefinitions == null) {
                missing = missing + " udafDefinitions";
            }
            if (this.autoUdfUdafLoad == null) {
                missing = missing + " autoUdfUdafLoad";
            }
            if (this.tableProviderMap == null) {
                missing = missing + " tableProviderMap";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SqlTransform(this.queryString, this.udfDefinitions, this.udafDefinitions, this.autoUdfUdafLoad, this.tableProviderMap, this.defaultTableProvider);
        }
    }
}

