/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
class BigQueryTable
extends SchemaBaseBeamTable
implements Serializable {
    @VisibleForTesting
    static final String METHOD_PROPERTY = "method";
    @VisibleForTesting
    final String bqLocation;
    private final BigQueryUtils.ConversionOptions conversionOptions;
    private BeamTableStatistics rowCountStatistics = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(BigQueryTable.class);
    @VisibleForTesting
    final BigQueryIO.TypedRead.Method method;

    /*
     * Enabled aggressive block sorting
     */
    BigQueryTable(Table table, BigQueryUtils.ConversionOptions options) {
        super(table.getSchema());
        this.conversionOptions = options;
        this.bqLocation = table.getLocation();
        if (table.getProperties().containsKey((Object)METHOD_PROPERTY)) {
            String selectedMethod;
            List validMethods = Arrays.stream(BigQueryIO.TypedRead.Method.values()).map(Enum::toString).collect(Collectors.toList());
            if (!validMethods.contains(selectedMethod = table.getProperties().getString(METHOD_PROPERTY).toUpperCase())) {
                InvalidPropertyException e = new InvalidPropertyException("Invalid method '" + selectedMethod + "'. Supported methods are: " + validMethods.toString() + ".");
                throw e;
            }
            this.method = BigQueryIO.TypedRead.Method.valueOf((String)selectedMethod);
        } else {
            this.method = BigQueryIO.TypedRead.Method.DEFAULT;
        }
        LOGGER.info("BigQuery method is set to: " + this.method.toString());
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        if (this.rowCountStatistics == null) {
            this.rowCountStatistics = BigQueryTable.getRowCountFromBQ(options, this.bqLocation);
        }
        return this.rowCountStatistics;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        return (PCollection)begin.apply("Read Input BQ Rows", this.getBigQueryReadBuilder(this.getSchema()));
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin, BeamSqlTableFilter filters, List<String> fieldNames) {
        if (!this.method.equals((Object)BigQueryIO.TypedRead.Method.DIRECT_READ)) {
            LOGGER.info("Predicate/project push-down only available for `DIRECT_READ` method, skipping.");
            return this.buildIOReader(begin);
        }
        FieldAccessDescriptor resolved = FieldAccessDescriptor.withFieldNames(fieldNames).resolve(this.getSchema());
        Schema newSchema = SelectHelpers.getOutputSchema((Schema)this.getSchema(), (FieldAccessDescriptor)resolved);
        BigQueryIO.TypedRead<Row> builder = this.getBigQueryReadBuilder(newSchema);
        if (!(filters instanceof DefaultTableFilter)) {
            throw new RuntimeException("Unimplemented at the moment.");
        }
        if (!fieldNames.isEmpty()) {
            builder.withSelectedFields(fieldNames);
        }
        return (PCollection)begin.apply("Read Input BQ Rows with push-down", builder);
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        return input.apply((PTransform)BigQueryIO.write().withSchema(BigQueryUtils.toTableSchema((Schema)this.getSchema())).withFormatFunction(BigQueryUtils.toTableRow()).to(this.bqLocation));
    }

    @Override
    public boolean supportsProjects() {
        return true;
    }

    private BigQueryIO.TypedRead<Row> getBigQueryReadBuilder(Schema schema) {
        return BigQueryIO.read((SerializableFunction & Serializable)record -> BigQueryUtils.toBeamRow((GenericRecord)record.getRecord(), (Schema)schema, (BigQueryUtils.ConversionOptions)this.conversionOptions)).withMethod(this.method).from(this.bqLocation).withCoder((Coder)SchemaCoder.of((Schema)schema));
    }

    private static BeamTableStatistics getRowCountFromBQ(PipelineOptions o, String bqLocation) {
        try {
            BigInteger rowCount = BigQueryHelpers.getNumRows((BigQueryOptions)((BigQueryOptions)o.as(BigQueryOptions.class)), (TableReference)BigQueryHelpers.parseTableSpec((String)bqLocation));
            if (rowCount == null) {
                return BeamTableStatistics.BOUNDED_UNKNOWN;
            }
            return BeamTableStatistics.createBoundedTableStatistics(rowCount.doubleValue());
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Could not get the row count for the table " + bqLocation, (Throwable)e);
            return BeamTableStatistics.BOUNDED_UNKNOWN;
        }
    }

    public static class InvalidPropertyException
    extends UnsupportedOperationException {
        private InvalidPropertyException(String s) {
            super(s);
        }
    }
}

