/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
class BigQueryTable
extends BaseBeamTable
implements Serializable {
    @VisibleForTesting
    final String bqLocation;
    private final BigQueryUtils.ConversionOptions conversionOptions;
    private BeamTableStatistics rowCountStatistics = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(BigQueryTable.class);

    BigQueryTable(Table table, BigQueryUtils.ConversionOptions options) {
        super(table.getSchema());
        this.conversionOptions = options;
        this.bqLocation = table.getLocation();
    }

    @Override
    public BeamTableStatistics getRowCount(PipelineOptions options) {
        if (this.rowCountStatistics == null) {
            this.rowCountStatistics = BigQueryTable.getRowCountFromBQ(options, this.bqLocation);
        }
        return this.rowCountStatistics;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        return ((PCollection)begin.apply("Read Input BQ Rows", (PTransform)BigQueryIO.read((SerializableFunction & Serializable)record -> BigQueryUtils.toBeamRow((GenericRecord)record.getRecord(), (Schema)this.getSchema(), (BigQueryUtils.ConversionOptions)this.conversionOptions)).from(this.bqLocation).withCoder((Coder)SchemaCoder.of((Schema)this.getSchema())))).setRowSchema(this.getSchema());
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        return input.apply((PTransform)BigQueryIO.write().withSchema(BigQueryUtils.toTableSchema((Schema)this.getSchema())).withFormatFunction(BigQueryUtils.toTableRow()).to(this.bqLocation));
    }

    private static BeamTableStatistics getRowCountFromBQ(PipelineOptions o, String bqLocation) {
        try {
            BigInteger rowCount = BigQueryHelpers.getNumRows((BigQueryOptions)((BigQueryOptions)o.as(BigQueryOptions.class)), (TableReference)BigQueryHelpers.parseTableSpec((String)bqLocation));
            if (rowCount == null) {
                return BeamTableStatistics.UNKNOWN;
            }
            return BeamTableStatistics.createBoundedTableStatistics(rowCount.doubleValue());
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Could not get the row count for the table " + bqLocation, (Throwable)e);
            return BeamTableStatistics.UNKNOWN;
        }
    }
}

