/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamSetOperatorsTransforms;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class BeamSetOperatorRelBase
extends PTransform<PCollectionList<Row>, PCollection<Row>> {
    private BeamRelNode beamRelNode;
    private boolean all;
    private OpType opType;

    public BeamSetOperatorRelBase(BeamRelNode beamRelNode, OpType opType, boolean all) {
        this.beamRelNode = beamRelNode;
        this.opType = opType;
        this.all = all;
    }

    public PCollection<Row> expand(PCollectionList<Row> inputs) {
        Preconditions.checkArgument((inputs.size() == 2 ? 1 : 0) != 0, (String)"Wrong number of arguments to %s: %s", (Object)this.beamRelNode.getClass().getSimpleName(), inputs);
        PCollection leftRows = inputs.get(0);
        PCollection rightRows = inputs.get(1);
        WindowFn leftWindow = leftRows.getWindowingStrategy().getWindowFn();
        WindowFn rightWindow = rightRows.getWindowingStrategy().getWindowFn();
        if (!leftWindow.isCompatible(rightWindow)) {
            throw new IllegalArgumentException("inputs of " + this.opType + " have different window strategy: " + leftWindow + " VS " + rightWindow);
        }
        TupleTag leftTag = new TupleTag();
        TupleTag rightTag = new TupleTag();
        PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)leftTag, (PCollection)((PCollection)leftRows.apply("CreateLeftIndex", (PTransform)MapElements.via((SimpleFunction)new BeamSetOperatorsTransforms.BeamSqlRow2KvFn())))).and(rightTag, (PCollection)rightRows.apply("CreateRightIndex", (PTransform)MapElements.via((SimpleFunction)new BeamSetOperatorsTransforms.BeamSqlRow2KvFn()))).apply((PTransform)CoGroupByKey.create());
        return (PCollection)coGbkResultCollection.apply((PTransform)ParDo.of((DoFn)new BeamSetOperatorsTransforms.SetOperatorFilteringDoFn((TupleTag<Row>)leftTag, (TupleTag<Row>)rightTag, this.opType, this.all)));
    }

    public static enum OpType implements Serializable
    {
        UNION,
        INTERSECT,
        MINUS;

    }
}

