/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.CalciteConnectionWrapper;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class JdbcConnection
extends CalciteConnectionWrapper {
    private static final String PIPELINE_OPTION_PREFIX = "beam.";
    private Map<String, String> pipelineOptionsMap = Collections.emptyMap();
    private PipelineOptions pipelineOptions;

    private JdbcConnection(CalciteConnection connection) throws SQLException {
        super(connection);
    }

    @Nullable
    static JdbcConnection initialize(CalciteConnection connection) {
        try {
            if (connection == null) {
                return null;
            }
            JdbcConnection jdbcConnection = new JdbcConnection(connection);
            jdbcConnection.setPipelineOptionsMap(JdbcConnection.extractPipelineOptions(connection));
            jdbcConnection.setSchema(connection.getSchema(), BeamCalciteSchemaFactory.fromInitialEmptySchema(jdbcConnection));
            return jdbcConnection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> extractPipelineOptions(CalciteConnection calciteConnection) {
        return calciteConnection.getProperties().entrySet().stream().map(entry -> KV.of((Object)entry.getKey().toString(), (Object)entry.getValue().toString())).filter(kv -> ((String)kv.getKey()).startsWith(PIPELINE_OPTION_PREFIX)).map(kv -> KV.of((Object)((String)kv.getKey()).substring(PIPELINE_OPTION_PREFIX.length()), (Object)((String)kv.getValue()))).collect(Collectors.toMap(KV::getKey, KV::getValue));
    }

    Map<String, String> getPipelineOptionsMap() {
        return this.pipelineOptionsMap;
    }

    public void setPipelineOptionsMap(Map<String, String> pipelineOptionsMap) {
        this.pipelineOptionsMap = ImmutableMap.copyOf(pipelineOptionsMap);
    }

    public void setPipelineOptions(PipelineOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
    }

    public PipelineOptions getPipelineOptions() {
        return this.pipelineOptions;
    }

    <T> T getCurrentBeamSchema() {
        try {
            return (T)CalciteSchema.from((SchemaPlus)this.getRootSchema().getSubSchema((String)this.getSchema())).schema;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public SchemaPlus getCurrentSchemaPlus() {
        try {
            return this.getRootSchema().getSubSchema(this.getSchema());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void setSchema(String name, TableProvider tableProvider) {
        BeamCalciteSchema beamCalciteSchema = new BeamCalciteSchema(this, tableProvider);
        this.getRootSchema().add(name, beamCalciteSchema);
    }
}

