/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlWindow;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.EmptyScope;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.ListScope;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.ScopeChild;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Litmus;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Pair;

public class SelectScope
extends ListScope {
    private final SqlSelect select;
    protected final List<String> windowNames = new ArrayList<String>();
    private List<SqlNode> expandedSelectList = null;
    private SqlNodeList orderList;
    private final SqlValidatorScope windowParent;

    SelectScope(SqlValidatorScope parent, SqlValidatorScope winParent, SqlSelect select) {
        super(parent);
        this.select = select;
        this.windowParent = winParent;
    }

    public SqlValidatorTable getTable() {
        return null;
    }

    @Override
    public SqlSelect getNode() {
        return this.select;
    }

    @Override
    public SqlWindow lookupWindow(String name) {
        SqlNodeList windowList = this.select.getWindowList();
        for (int i = 0; i < windowList.size(); ++i) {
            SqlWindow window = (SqlWindow)windowList.get(i);
            SqlIdentifier declId = window.getDeclName();
            assert (declId.isSimple());
            if (!((String)declId.names.get(0)).equals(name)) continue;
            return window;
        }
        if (this.windowParent != null) {
            return this.windowParent.lookupWindow(name);
        }
        return null;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        SqlMonotonicity monotonicity = expr.getMonotonicity(this);
        if (monotonicity != SqlMonotonicity.NOT_MONOTONIC) {
            return monotonicity;
        }
        SqlNodeList orderList = this.getOrderList();
        if (orderList.size() > 0) {
            SqlNode order0 = orderList.get(0);
            monotonicity = SqlMonotonicity.INCREASING;
            if (order0 instanceof SqlCall && ((SqlCall)order0).getOperator() == SqlStdOperatorTable.DESC) {
                monotonicity = monotonicity.reverse();
                order0 = ((SqlCall)order0).operand(0);
            }
            if (expr.equalsDeep(order0, Litmus.IGNORE)) {
                return monotonicity;
            }
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlNodeList getOrderList() {
        if (this.orderList == null) {
            SqlValidatorNamespace child;
            List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs;
            this.orderList = new SqlNodeList(SqlParserPos.ZERO);
            if (this.children.size() == 1 && (monotonicExprs = (child = ((ScopeChild)this.children.get((int)0)).namespace).getMonotonicExprs()).size() > 0) {
                this.orderList.add((SqlNode)monotonicExprs.get((int)0).left);
            }
        }
        return this.orderList;
    }

    public void addWindowName(String winName) {
        this.windowNames.add(winName);
    }

    public boolean existingWindowName(String winName) {
        for (String windowName : this.windowNames) {
            if (!windowName.equalsIgnoreCase(winName)) continue;
            return true;
        }
        SqlValidatorScope walker = this.parent;
        while (!(walker instanceof EmptyScope)) {
            if (walker instanceof SelectScope) {
                SelectScope parentScope = (SelectScope)walker;
                return parentScope.existingWindowName(winName);
            }
            walker = ((DelegatingScope)walker).parent;
        }
        return false;
    }

    public List<SqlNode> getExpandedSelectList() {
        return this.expandedSelectList;
    }

    public void setExpandedSelectList(List<SqlNode> selectList) {
        this.expandedSelectList = selectList;
    }
}

