/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.SocketFactory;

public class SocketFactoryImpl
extends SocketFactory {
    public static final boolean SO_KEEPALIVE = false;
    public static final boolean OOBINLINE = false;
    public static final boolean SO_REUSEADDR = false;
    public static final boolean TCP_NODELAY = true;
    public static final int SO_RCVBUF = 8192;
    public static final int SO_SNDBUF = 1024;
    public static final int SO_TIMEOUT = 12000;
    public static final int SO_CONNECT_TIMEOUT = 5000;
    public static final boolean SO_LINGER = true;
    public static final int LINGER = 0;

    @Override
    public Socket createSocket() throws IOException {
        Socket s = new Socket();
        return this.applySettings(s);
    }

    protected Socket applySettings(Socket s) {
        try {
            s.setKeepAlive(false);
            s.setOOBInline(false);
            s.setReuseAddress(false);
            s.setTcpNoDelay(true);
            s.setOOBInline(false);
            s.setReceiveBufferSize(8192);
            s.setSendBufferSize(1024);
            s.setSoTimeout(12000);
            s.setSoLinger(true, 0);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket s = this.createSocket();
        s.connect(new InetSocketAddress(host, port), 5000);
        return s;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket s = this.createSocket();
        s.connect(new InetSocketAddress(host, port), 5000);
        return s;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress local, int localPort) throws IOException {
        Socket s = this.createSocket();
        s.bind(new InetSocketAddress(local, localPort));
        s.connect(new InetSocketAddress(host, port), 5000);
        return s;
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress local, int localPort) throws IOException {
        Socket s = this.createSocket();
        s.bind(new InetSocketAddress(local, localPort));
        s.connect(new InetSocketAddress(host, port), 5000);
        return s;
    }

    public static SocketFactory getDefault() {
        return new SocketFactoryImpl();
    }
}

