/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.adapter.jdbc;

import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.sql.com.google.common.collect.Lists;
import org.apache.beam.repackaged.sql.org.apache.calcite.DataContext;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.jdbc.JdbcTableScan;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.jdbc.JdbcUtils;
import org.apache.beam.repackaged.sql.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.Enumerator;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.Queryable;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.Convention;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.sql.org.apache.calcite.prepare.Prepare;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.runtime.ResultSetEnumerable;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.ModifiableTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.ScannableTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.Schema;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.TranslatableTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.util.SqlString;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Pair;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Util;

public class JdbcTable
extends AbstractQueryableTable
implements TranslatableTable,
ScannableTable,
ModifiableTable {
    private RelProtoDataType protoRowType;
    private final JdbcSchema jdbcSchema;
    private final String jdbcCatalogName;
    private final String jdbcSchemaName;
    private final String jdbcTableName;
    private final Schema.TableType jdbcTableType;

    JdbcTable(JdbcSchema jdbcSchema, String jdbcCatalogName, String jdbcSchemaName, String tableName, Schema.TableType jdbcTableType) {
        super((Type)((Object)Object[].class));
        this.jdbcSchema = jdbcSchema;
        this.jdbcCatalogName = jdbcCatalogName;
        this.jdbcSchemaName = jdbcSchemaName;
        this.jdbcTableName = tableName;
        this.jdbcTableType = Objects.requireNonNull(jdbcTableType);
    }

    public String toString() {
        return "JdbcTable {" + this.jdbcTableName + "}";
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return this.jdbcTableType;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType == null) {
            try {
                this.protoRowType = this.jdbcSchema.getRelDataType(this.jdbcCatalogName, this.jdbcSchemaName, this.jdbcTableName);
            }
            catch (SQLException e) {
                throw new RuntimeException("Exception while reading definition of table '" + this.jdbcTableName + "'", e);
            }
        }
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    private List<Pair<ColumnMetaData.Rep, Integer>> fieldClasses(JavaTypeFactory typeFactory) {
        RelDataType rowType = (RelDataType)this.protoRowType.apply(typeFactory);
        return Lists.transform(rowType.getFieldList(), f -> {
            RelDataType type = f.getType();
            Class clazz = (Class)typeFactory.getJavaClass(type);
            ColumnMetaData.Rep rep = Util.first(ColumnMetaData.Rep.of(clazz), ColumnMetaData.Rep.OBJECT);
            return Pair.of(rep, type.getSqlTypeName().getJdbcOrdinal());
        });
    }

    SqlString generateSql() {
        SqlNodeList selectList = new SqlNodeList(Collections.singletonList(SqlIdentifier.star(SqlParserPos.ZERO)), SqlParserPos.ZERO);
        SqlSelect node = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, selectList, this.tableName(), null, null, null, null, null, null, null);
        SqlPrettyWriter writer = new SqlPrettyWriter(this.jdbcSchema.dialect);
        node.unparse(writer, 0, 0);
        return writer.toSqlString();
    }

    SqlIdentifier tableName() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.jdbcSchema.catalog != null) {
            strings.add(this.jdbcSchema.catalog);
        }
        if (this.jdbcSchema.schema != null) {
            strings.add(this.jdbcSchema.schema);
        }
        strings.add(this.jdbcTableName);
        return new SqlIdentifier(strings, SqlParserPos.ZERO);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new JdbcTableScan(context.getCluster(), relOptTable, this, this.jdbcSchema.convention);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new JdbcTableQueryable(queryProvider, schema, tableName);
    }

    @Override
    public Enumerable<Object[]> scan(DataContext root) {
        JavaTypeFactory typeFactory = root.getTypeFactory();
        SqlString sql = this.generateSql();
        return ResultSetEnumerable.of(this.jdbcSchema.getDataSource(), sql.getSql(), JdbcUtils.ObjectArrayRowBuilder.factory(this.fieldClasses(typeFactory)));
    }

    @Override
    public Collection getModifiableCollection() {
        return null;
    }

    @Override
    public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        this.jdbcSchema.convention.register(cluster.getPlanner());
        return new LogicalTableModify(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), table, catalogReader, input, operation, updateColumnList, sourceExpressionList, flattened);
    }

    private class JdbcTableQueryable<T>
    extends AbstractTableQueryable<T> {
        JdbcTableQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            super(queryProvider, schema, JdbcTable.this, tableName);
        }

        public String toString() {
            return "JdbcTableQueryable {table: " + this.tableName + "}";
        }

        @Override
        public Enumerator<T> enumerator() {
            JavaTypeFactory typeFactory = ((CalciteConnection)this.queryProvider).getTypeFactory();
            SqlString sql = JdbcTable.this.generateSql();
            ResultSetEnumerable enumerable = ResultSetEnumerable.of(JdbcTable.this.jdbcSchema.getDataSource(), sql.getSql(), JdbcUtils.ObjectArrayRowBuilder.factory(JdbcTable.this.fieldClasses(typeFactory)));
            return enumerable.enumerator();
        }
    }
}

