/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;

@Internal
public class TextTable
extends BaseBeamTable {
    private final PTransform<PCollection<String>, PCollection<Row>> readConverter;
    private final PTransform<PCollection<Row>, PCollection<String>> writeConverter;
    private final String filePattern;

    public TextTable(Schema schema, String filePattern, PTransform<PCollection<String>, PCollection<Row>> readConverter, PTransform<PCollection<Row>, PCollection<String>> writeConverter) {
        super(schema);
        this.filePattern = filePattern;
        this.readConverter = readConverter;
        this.writeConverter = writeConverter;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        return (PCollection)((PCollection)begin.apply("ReadTextFiles", (PTransform)TextIO.read().from(this.filePattern))).apply("StringToRow", this.readConverter);
    }

    public PDone buildIOWriter(PCollection<Row> input) {
        return (PDone)((PCollection)input.apply("RowToString", this.writeConverter)).apply("WriteTextFiles", (PTransform)TextIO.write().withDelimiter(new char[0]).to(this.filePattern));
    }
}

