/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog.DatabaseProvider;
import org.apache.beam.sdk.io.hcatalog.HCatalogBeamSchema;

public class HCatalogTableProvider
implements TableProvider,
Serializable {
    private HashMap<String, String> configuration;
    private transient DatabaseProvider defaultDBProvider;
    private transient HCatalogBeamSchema metastoreSchema;

    private HCatalogTableProvider(HashMap<String, String> configuration, HCatalogBeamSchema metastoreSchema, DatabaseProvider defaultDBProvider) {
        this.configuration = configuration;
        this.defaultDBProvider = defaultDBProvider;
        this.metastoreSchema = metastoreSchema;
    }

    public static HCatalogTableProvider create(Map<String, String> configuration) {
        HCatalogBeamSchema metastoreSchema = HCatalogBeamSchema.create(configuration);
        return new HCatalogTableProvider(new HashMap<String, String>(configuration), metastoreSchema, new DatabaseProvider("default", metastoreSchema, configuration));
    }

    @Override
    public String getTableType() {
        return "hcatalog";
    }

    @Override
    public void createTable(Table table) {
        throw new UnsupportedOperationException("Creating tables in HCatalog is not supported");
    }

    @Override
    public void dropTable(String tableName) {
        throw new UnsupportedOperationException("Deleting tables in HCatalog is not supported");
    }

    @Override
    public Map<String, Table> getTables() {
        throw new UnsupportedOperationException("Extracting all tables from HCatalog is not supported");
    }

    @Override
    @Nullable
    public Table getTable(String name) {
        return this.defaultDBProvider.getTable(name);
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        return this.defaultDBProvider.buildBeamSqlTable(table);
    }

    @Override
    public Set<String> getSubProviders() {
        throw new UnsupportedOperationException("Listing DBs is not supported in metastore");
    }

    @Override
    public TableProvider getSubProvider(String name) {
        return this.metastoreSchema.hasDatabase(name) ? new DatabaseProvider(name, this.metastoreSchema, this.configuration) : null;
    }
}

