/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.Contexts;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelRoot;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.Frameworks;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.Planner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.ValidationException;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeamQueryPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(BeamQueryPlanner.class);
    private JdbcConnection connection;

    BeamQueryPlanner(JdbcConnection connection) {
        this.connection = connection;
    }

    public FrameworkConfig config() {
        CalciteConnectionConfig config = this.connection.config();
        SqlParser.ConfigBuilder parserConfig = SqlParser.configBuilder().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()).setConformance(config.conformance()).setCaseSensitive(config.caseSensitive());
        SqlParserImplFactory parserFactory = config.parserFactory(SqlParserImplFactory.class, null);
        if (parserFactory != null) {
            parserConfig.setParserFactory(parserFactory);
        }
        SchemaPlus schema = this.connection.getRootSchema();
        SchemaPlus defaultSchema = this.connection.getCurrentSchemaPlus();
        ImmutableList traitDefs = ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from(schema), (List<String>)ImmutableList.of((Object)defaultSchema.getName()), this.connection.getTypeFactory(), this.connection.config());
        SqlOperatorTable opTab0 = this.connection.config().fun(SqlOperatorTable.class, SqlStdOperatorTable.instance());
        return Frameworks.newConfigBuilder().parserConfig(parserConfig.build()).defaultSchema(defaultSchema).traitDefs((List<RelTraitDef>)traitDefs).context(Contexts.of((Object)this.connection.config())).ruleSets(BeamRuleSets.getRuleSets()).costFactory(null).typeSystem(this.connection.getTypeFactory().getTypeSystem()).operatorTable(ChainedSqlOperatorTable.of(opTab0, catalogReader)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlNode parse(String sqlStatement) throws SqlParseException {
        SqlNode parsed;
        try (Planner planner = this.getPlanner();){
            parsed = planner.parse(sqlStatement);
        }
        return parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeamRelNode convertToBeamRel(String sqlStatement) throws ValidationException, RelConversionException, SqlParseException, RelOptPlanner.CannotPlanException {
        BeamRelNode beamRelNode;
        try (Planner planner = this.getPlanner();){
            SqlNode parsed = planner.parse(sqlStatement);
            SqlNode validated = planner.validate(parsed);
            LOG.info("SQL:\n" + validated);
            RelRoot root = planner.rel(validated);
            LOG.info("SQLPlan>\n" + RelOptUtil.toString(root.rel));
            RelTraitSet desiredTraits = root.rel.getTraitSet().replace(BeamLogicalConvention.INSTANCE).replace(root.collation).simplify();
            beamRelNode = (BeamRelNode)planner.transform(0, desiredTraits, root.rel);
            LOG.info("BEAMPlan>\n" + RelOptUtil.toString(beamRelNode));
        }
        return beamRelNode;
    }

    private Planner getPlanner() {
        return Frameworks.getPlanner(this.config());
    }
}

