/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCallBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;

public class SqlJsonValueFunction
extends SqlFunction {
    private final boolean returnAny;

    public SqlJsonValueFunction(String name, boolean returnAny) {
        super(name, SqlKind.OTHER_FUNCTION, null, (SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.ANY);
            }
        }, null, SqlFunctionCategory.SYSTEM);
        this.returnAny = returnAny;
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        ArrayList<SqlNode> operandList = new ArrayList<SqlNode>();
        operandList.add(operands[0]);
        if (operands[1] == null) {
            operandList.add(SqlLiteral.createSymbol(SqlJsonValueEmptyOrErrorBehavior.NULL, pos));
            operandList.add(SqlLiteral.createNull(pos));
        } else {
            operandList.add(operands[1]);
            operandList.add(operands[2]);
        }
        if (operands[3] == null) {
            operandList.add(SqlLiteral.createSymbol(SqlJsonValueEmptyOrErrorBehavior.NULL, pos));
            operandList.add(SqlLiteral.createNull(pos));
        } else {
            operandList.add(operands[3]);
            operandList.add(operands[4]);
        }
        if (operands.length == 6 && operands[5] != null) {
            if (this.returnAny) {
                throw new IllegalArgumentException("illegal returning clause in json_value_any function");
            }
            operandList.add(operands[5]);
        } else if (!this.returnAny) {
            SqlDataTypeSpec defaultTypeSpec = new SqlDataTypeSpec(new SqlIdentifier("VARCHAR", pos), 2000, -1, null, null, pos);
            operandList.add(defaultTypeSpec);
        }
        return super.createCall(functionQualifier, pos, operandList.toArray(SqlNode.EMPTY_ARRAY));
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(5, 6);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlValidator validator = callBinding.getValidator();
        RelDataType defaultValueOnEmptyType = validator.getValidatedNodeType(callBinding.operand(2));
        RelDataType defaultValueOnErrorType = validator.getValidatedNodeType(callBinding.operand(4));
        RelDataType returnType = validator.deriveType(callBinding.getScope(), callBinding.operand(5));
        if (!this.canCastFrom(callBinding, throwOnFailure, defaultValueOnEmptyType, returnType)) {
            return false;
        }
        return this.canCastFrom(callBinding, throwOnFailure, defaultValueOnErrorType, returnType);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        assert (opBinding.getOperandCount() == 5 || opBinding.getOperandCount() == 6);
        RelDataType ret = opBinding.getOperandCount() == 6 ? opBinding.getOperandType(5) : opBinding.getTypeFactory().createSqlType(SqlTypeName.ANY);
        return opBinding.getTypeFactory().createTypeWithNullability(ret, true);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 5 || operandsCount == 6);
        if (operandsCount == 6) {
            return "{0}({1} RETURNING {6} {2} {3} ON EMPTY {4} {5} ON ERROR)";
        }
        return "{0}({1} {2} {3} ON EMPTY {4} {5} ON ERROR)";
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 5 || call.operandCount() == 6);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        if (!this.returnAny) {
            writer.keyword("RETURNING");
            ((SqlNode)call.operand(5)).unparse(writer, 0, 0);
        }
        this.unparseEnum(writer, (SqlLiteral)call.operand(1));
        if (this.isDefaultLiteral((SqlLiteral)call.operand(1))) {
            ((SqlNode)call.operand(2)).unparse(writer, 0, 0);
        }
        writer.keyword("ON");
        writer.keyword("EMPTY");
        this.unparseEnum(writer, (SqlLiteral)call.operand(3));
        if (this.isDefaultLiteral((SqlLiteral)call.operand(3))) {
            ((SqlNode)call.operand(4)).unparse(writer, 0, 0);
        }
        writer.keyword("ON");
        writer.keyword("ERROR");
        writer.endFunCall(frame);
    }

    private void unparseEnum(SqlWriter writer, SqlLiteral literal) {
        writer.keyword(((Enum)literal.getValue()).name());
    }

    private boolean isDefaultLiteral(SqlLiteral literal) {
        return literal.getValueAs(SqlJsonValueEmptyOrErrorBehavior.class) == SqlJsonValueEmptyOrErrorBehavior.DEFAULT;
    }

    private boolean canCastFrom(SqlCallBinding callBinding, boolean throwOnFailure, RelDataType inType, RelDataType outType) {
        if (SqlTypeUtil.canCastFrom(outType, inType, true)) {
            return true;
        }
        if (throwOnFailure) {
            throw callBinding.newError(Static.RESOURCE.cannotCastValue(inType.toString(), outType.toString()));
        }
        return false;
    }
}

