/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Pair;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;

class RelDataTypeHolder {
    private final List<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
    private final RelDataTypeFactory typeFactory;

    RelDataTypeHolder(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public List<RelDataTypeField> getFieldList() {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    Pair<RelDataTypeField, Boolean> getFieldOrInsert(String fieldName, boolean caseSensitive) {
        for (RelDataTypeField f : this.fields) {
            if (Util.matches(caseSensitive, f.getName(), fieldName)) {
                return Pair.of(f, false);
            }
            if (f.getType().getSqlTypeName() != SqlTypeName.DYNAMIC_STAR) continue;
            return Pair.of(f, false);
        }
        SqlTypeName typeName = DynamicRecordType.isDynamicStarColName(fieldName) ? SqlTypeName.DYNAMIC_STAR : SqlTypeName.ANY;
        RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, this.fields.size(), this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(typeName), true));
        this.fields.add(newField);
        return Pair.of(newField, true);
    }

    public List<String> getFieldNames() {
        return Pair.left(this.fields);
    }
}

