/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core;

import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSet;

public class CorrelationId
implements Cloneable,
Comparable<CorrelationId> {
    public static final String CORREL_PREFIX = "$cor";
    private final int id;
    private final String name;

    private CorrelationId(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public CorrelationId(int id) {
        this(id, CORREL_PREFIX + id);
    }

    public CorrelationId(String name) {
        this(Integer.parseInt(name.substring(CORREL_PREFIX.length())), name);
        assert (name.startsWith(CORREL_PREFIX)) : "Correlation name should start with $cor actual name is " + name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CorrelationId other) {
        return this.id - other.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CorrelationId && this.id == ((CorrelationId)obj).id;
    }

    public static ImmutableSet<CorrelationId> setOf(Set<String> set) {
        if (set.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String s : set) {
            builder.add(new CorrelationId(s));
        }
        return builder.build();
    }

    public static Set<String> names(Set<CorrelationId> set) {
        if (set.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CorrelationId s : set) {
            builder.add(s.name);
        }
        return builder.build();
    }
}

