/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize;

import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize.LatticeTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize.SqlStatisticProvider;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.graph.AttributedDirectedGraph;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.mapping.IntPair;

class Step
extends DefaultEdge {
    final List<IntPair> keys;

    Step(LatticeTable source, LatticeTable target, List<IntPair> keys) {
        super(source, target);
        this.keys = ImmutableList.copyOf(keys);
        assert (IntPair.ORDERING.isStrictlyOrdered(keys));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target, this.keys);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Step && ((Step)obj).source.equals(this.source) && ((Step)obj).target.equals(this.target) && ((Step)obj).keys.equals(this.keys);
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append("Step(").append(this.source).append(", ").append(this.target).append(",");
        for (IntPair key : this.keys) {
            b.append(' ').append(this.source().field(key.source).getName()).append(':').append(this.target().field(key.target).getName());
        }
        return b.append(")").toString();
    }

    LatticeTable source() {
        return (LatticeTable)this.source;
    }

    LatticeTable target() {
        return (LatticeTable)this.target;
    }

    boolean isBackwards(SqlStatisticProvider statisticProvider) {
        return this.source == this.target ? this.keys.get((int)0).source < this.keys.get((int)0).target : this.cardinality(statisticProvider, this.source()) < this.cardinality(statisticProvider, this.target());
    }

    private double cardinality(SqlStatisticProvider statisticProvider, LatticeTable table) {
        return statisticProvider.tableCardinality(table.t.getQualifiedName());
    }

    static class Factory
    implements AttributedDirectedGraph.AttributedEdgeFactory<LatticeTable, Step> {
        Factory() {
        }

        @Override
        public Step createEdge(LatticeTable source, LatticeTable target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Step createEdge(LatticeTable source, LatticeTable target, Object ... attributes) {
            List keys = (List)attributes[0];
            return new Step(source, target, keys);
        }
    }
}

