/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Primitive
extends Enum<Primitive> {
    public static final /* enum */ Primitive BOOLEAN;
    public static final /* enum */ Primitive BYTE;
    public static final /* enum */ Primitive CHAR;
    public static final /* enum */ Primitive SHORT;
    public static final /* enum */ Primitive INT;
    public static final /* enum */ Primitive LONG;
    public static final /* enum */ Primitive FLOAT;
    public static final /* enum */ Primitive DOUBLE;
    public static final /* enum */ Primitive VOID;
    public static final /* enum */ Primitive OTHER;
    public final Class primitiveClass;
    public final Class boxClass;
    public final String primitiveName;
    public final String boxName;
    private final int family;
    public final Object defaultValue;
    public final Object min;
    public final Object maxNegative;
    public final Object minPositive;
    public final Object max;
    public final int size;
    private static final Map<Class, Primitive> PRIMITIVE_MAP;
    private static final Map<Class, Primitive> BOX_MAP;
    private static final /* synthetic */ Primitive[] $VALUES;

    public static Primitive[] values() {
        return (Primitive[])$VALUES.clone();
    }

    public static Primitive valueOf(String name) {
        return Enum.valueOf(Primitive.class, name);
    }

    private Primitive(Class primitiveClass, Class boxClass, int family, Object defaultValue, Object min, Object maxNegative, Object minPositive, Object max, int size) {
        this.primitiveClass = primitiveClass;
        this.family = family;
        this.primitiveName = primitiveClass != null ? primitiveClass.getSimpleName() : null;
        this.boxClass = boxClass;
        this.boxName = boxClass != null ? boxClass.getSimpleName() : null;
        this.defaultValue = defaultValue;
        this.min = min;
        this.maxNegative = maxNegative;
        this.minPositive = minPositive;
        this.max = max;
        this.size = size;
    }

    public static Primitive of(Type type) {
        return PRIMITIVE_MAP.get(type);
    }

    public static Primitive ofBox(Type type) {
        return BOX_MAP.get(type);
    }

    public static Primitive ofBoxOr(Type type) {
        Primitive primitive = Primitive.of(type);
        if (primitive == null) {
            primitive = Primitive.ofBox(type);
        }
        return primitive;
    }

    public static boolean is(Type type) {
        return PRIMITIVE_MAP.containsKey(type);
    }

    public static boolean isBox(Type type) {
        return BOX_MAP.containsKey(type);
    }

    public static Flavor flavor(Type type) {
        if (Primitive.is(type)) {
            return Flavor.PRIMITIVE;
        }
        if (Primitive.isBox(type)) {
            return Flavor.BOX;
        }
        return Flavor.OBJECT;
    }

    public boolean isNumeric() {
        switch (this) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isFixedNumeric() {
        switch (this) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    public static Type box(Type type) {
        Primitive primitive = Primitive.of(type);
        return primitive == null ? type : primitive.boxClass;
    }

    public static Class box(Class type) {
        Primitive primitive = Primitive.of(type);
        return primitive == null ? type : primitive.boxClass;
    }

    public static Type unbox(Type type) {
        Primitive primitive = Primitive.ofBox(type);
        return primitive == null ? type : primitive.primitiveClass;
    }

    public static Class unbox(Class type) {
        Primitive primitive = Primitive.ofBox(type);
        return primitive == null ? type : primitive.primitiveClass;
    }

    public static List<?> asList(final Object array) {
        return new AbstractList(){

            @Override
            public Object get(int index) {
                return Array.get(array, index);
            }

            @Override
            public int size() {
                return Array.getLength(array);
            }
        };
    }

    public static List<Boolean> asList(boolean[] elements) {
        return Primitive.asList((Object)elements);
    }

    public static List<Byte> asList(byte[] elements) {
        return Primitive.asList((Object)elements);
    }

    public static List<Character> asList(char[] elements) {
        return Primitive.asList((Object)elements);
    }

    public static List<Short> asList(short[] elements) {
        return Primitive.asList((Object)elements);
    }

    public static List<Integer> asList(int[] elements) {
        return Primitive.asList((Object)elements);
    }

    public static List<Long> asList(long[] elements) {
        return Primitive.asList((Object)elements);
    }

    public static List<Float> asList(float[] elements) {
        return Primitive.asList((Object)elements);
    }

    public static List<Double> asList(double[] elements) {
        return Primitive.asList((Object)elements);
    }

    public Object toArray(Collection collection) {
        int i = 0;
        switch (this) {
            case DOUBLE: {
                double[] doubles = new double[collection.size()];
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    double v = (Double)iterator.next();
                    doubles[i++] = v;
                }
                return doubles;
            }
            case FLOAT: {
                float[] floats = new float[collection.size()];
                Iterator v = collection.iterator();
                while (v.hasNext()) {
                    float v2 = ((Float)v.next()).floatValue();
                    floats[i++] = v2;
                }
                return floats;
            }
            case INT: {
                int[] ints = new int[collection.size()];
                Iterator v2 = collection.iterator();
                while (v2.hasNext()) {
                    int v = (Integer)v2.next();
                    ints[i++] = v;
                }
                return ints;
            }
            case LONG: {
                long[] longs = new long[collection.size()];
                Iterator v = collection.iterator();
                while (v.hasNext()) {
                    long v3 = (Long)v.next();
                    longs[i++] = v3;
                }
                return longs;
            }
            case SHORT: {
                short[] shorts = new short[collection.size()];
                Iterator v3 = collection.iterator();
                while (v3.hasNext()) {
                    short v = (Short)v3.next();
                    shorts[i++] = v;
                }
                return shorts;
            }
            case BOOLEAN: {
                boolean[] booleans = new boolean[collection.size()];
                Iterator v = collection.iterator();
                while (v.hasNext()) {
                    boolean v4 = (Boolean)v.next();
                    booleans[i++] = v4;
                }
                return booleans;
            }
            case BYTE: {
                byte[] bytes = new byte[collection.size()];
                Iterator v4 = collection.iterator();
                while (v4.hasNext()) {
                    byte v = (Byte)v4.next();
                    bytes[i++] = v;
                }
                return bytes;
            }
            case CHAR: {
                char[] chars = new char[collection.size()];
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    char v = ((Character)iterator.next()).charValue();
                    chars[i++] = v;
                }
                return chars;
            }
        }
        throw new RuntimeException("unexpected: " + (Object)((Object)this));
    }

    public Object toArray2(Collection<Number> collection) {
        int i = 0;
        switch (this) {
            case DOUBLE: {
                double[] doubles = new double[collection.size()];
                for (Number number : collection) {
                    doubles[i++] = number.doubleValue();
                }
                return doubles;
            }
            case FLOAT: {
                float[] floats = new float[collection.size()];
                for (Number number : collection) {
                    floats[i++] = number.floatValue();
                }
                return floats;
            }
            case INT: {
                int[] ints = new int[collection.size()];
                for (Number number : collection) {
                    ints[i++] = number.intValue();
                }
                return ints;
            }
            case LONG: {
                long[] longs = new long[collection.size()];
                for (Number number : collection) {
                    longs[i++] = number.longValue();
                }
                return longs;
            }
            case SHORT: {
                short[] shorts = new short[collection.size()];
                for (Number number : collection) {
                    shorts[i++] = number.shortValue();
                }
                return shorts;
            }
            case BOOLEAN: {
                boolean[] booleans = new boolean[collection.size()];
                for (Number number : collection) {
                    booleans[i++] = number.byteValue() != 0;
                }
                return booleans;
            }
            case BYTE: {
                byte[] bytes = new byte[collection.size()];
                for (Number number : collection) {
                    bytes[i++] = number.byteValue();
                }
                return bytes;
            }
            case CHAR: {
                char[] chars = new char[collection.size()];
                for (Number number : collection) {
                    chars[i++] = (char)number.shortValue();
                }
                return chars;
            }
        }
        throw new RuntimeException("unexpected: " + (Object)((Object)this));
    }

    public Object permute(Object array, int[] sources) {
        switch (this) {
            case DOUBLE: {
                double[] doubles0 = (double[])array;
                double[] doubles = new double[doubles0.length];
                for (int i = 0; i < doubles.length; ++i) {
                    doubles[i] = doubles0[sources[i]];
                }
                return doubles;
            }
            case FLOAT: {
                float[] floats0 = (float[])array;
                float[] floats = new float[floats0.length];
                for (int i = 0; i < floats.length; ++i) {
                    floats[i] = floats0[sources[i]];
                }
                return floats;
            }
            case INT: {
                int[] ints0 = (int[])array;
                int[] ints = new int[ints0.length];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = ints0[sources[i]];
                }
                return ints;
            }
            case LONG: {
                long[] longs0 = (long[])array;
                long[] longs = new long[longs0.length];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = longs0[sources[i]];
                }
                return longs;
            }
            case SHORT: {
                short[] shorts0 = (short[])array;
                short[] shorts = new short[shorts0.length];
                for (int i = 0; i < shorts.length; ++i) {
                    shorts[i] = shorts0[sources[i]];
                }
                return shorts;
            }
            case BOOLEAN: {
                boolean[] booleans0 = (boolean[])array;
                boolean[] booleans = new boolean[booleans0.length];
                for (int i = 0; i < booleans.length; ++i) {
                    booleans[i] = booleans0[sources[i]];
                }
                return booleans;
            }
            case BYTE: {
                byte[] bytes0 = (byte[])array;
                byte[] bytes = new byte[bytes0.length];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = bytes0[sources[i]];
                }
                return bytes;
            }
            case CHAR: {
                char[] chars0 = (char[])array;
                char[] chars = new char[chars0.length];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = chars0[sources[i]];
                }
                return chars;
            }
        }
        throw new RuntimeException("unexpected: " + (Object)((Object)this));
    }

    public String arrayToString(Object array) {
        switch (this) {
            case BOOLEAN: {
                return Arrays.toString((boolean[])array);
            }
            case BYTE: {
                return Arrays.toString((byte[])array);
            }
            case CHAR: {
                return Arrays.toString((char[])array);
            }
            case DOUBLE: {
                return Arrays.toString((double[])array);
            }
            case FLOAT: {
                return Arrays.toString((float[])array);
            }
            case INT: {
                return Arrays.toString((int[])array);
            }
            case LONG: {
                return Arrays.toString((long[])array);
            }
            case SHORT: {
                return Arrays.toString((short[])array);
            }
            case OTHER: 
            case VOID: {
                return Arrays.toString((Object[])array);
            }
        }
        throw new AssertionError((Object)("unexpected " + (Object)((Object)this)));
    }

    public void sortArray(Object array) {
        switch (this) {
            case BOOLEAN: {
                boolean[] booleans = (boolean[])array;
                Primitive.sortBooleanArray(booleans, 0, booleans.length);
                return;
            }
            case BYTE: {
                Arrays.sort((byte[])array);
                return;
            }
            case CHAR: {
                Arrays.sort((char[])array);
                return;
            }
            case DOUBLE: {
                Arrays.sort((double[])array);
                return;
            }
            case FLOAT: {
                Arrays.sort((float[])array);
                return;
            }
            case INT: {
                Arrays.sort((int[])array);
                return;
            }
            case LONG: {
                Arrays.sort((long[])array);
                return;
            }
            case SHORT: {
                Arrays.sort((short[])array);
                return;
            }
            case OTHER: 
            case VOID: {
                Arrays.sort((Object[])array);
                return;
            }
        }
        throw new AssertionError((Object)("unexpected " + (Object)((Object)this)));
    }

    public void sortArray(Object array, int fromIndex, int toIndex) {
        switch (this) {
            case BOOLEAN: {
                Primitive.sortBooleanArray((boolean[])array, fromIndex, toIndex);
                return;
            }
            case BYTE: {
                Arrays.sort((byte[])array, fromIndex, toIndex);
                return;
            }
            case CHAR: {
                Arrays.sort((char[])array, fromIndex, toIndex);
                return;
            }
            case DOUBLE: {
                Arrays.sort((double[])array, fromIndex, toIndex);
                return;
            }
            case FLOAT: {
                Arrays.sort((float[])array, fromIndex, toIndex);
                return;
            }
            case INT: {
                Arrays.sort((int[])array, fromIndex, toIndex);
                return;
            }
            case LONG: {
                Arrays.sort((long[])array, fromIndex, toIndex);
                return;
            }
            case SHORT: {
                Arrays.sort((short[])array, fromIndex, toIndex);
                return;
            }
            case OTHER: 
            case VOID: {
                Arrays.sort((Object[])array, fromIndex, toIndex);
                return;
            }
        }
        throw new AssertionError((Object)("unexpected " + (Object)((Object)this)));
    }

    private static void sortBooleanArray(boolean[] booleans, int fromIndex, int toIndex) {
        int midIndex = fromIndex;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (booleans[i]) continue;
            ++midIndex;
        }
        Arrays.fill(booleans, fromIndex, midIndex, false);
        Arrays.fill(booleans, midIndex, toIndex, true);
    }

    public void send(Field field, Object o, Sink sink) throws IllegalAccessException {
        switch (this) {
            case BOOLEAN: {
                sink.set(field.getBoolean(o));
                break;
            }
            case BYTE: {
                sink.set(field.getByte(o));
                break;
            }
            case CHAR: {
                sink.set(field.getChar(o));
                break;
            }
            case SHORT: {
                sink.set(field.getShort(o));
                break;
            }
            case INT: {
                sink.set(field.getInt(o));
                break;
            }
            case LONG: {
                sink.set(field.getLong(o));
                break;
            }
            case FLOAT: {
                sink.set(field.getFloat(o));
                break;
            }
            case DOUBLE: {
                sink.set(field.getDouble(o));
                break;
            }
            default: {
                sink.set(field.get(o));
            }
        }
    }

    public Object arrayItem(Object dataSet, int ordinal) {
        switch (this) {
            case DOUBLE: {
                return Array.getDouble(dataSet, ordinal);
            }
            case FLOAT: {
                return Float.valueOf(Array.getFloat(dataSet, ordinal));
            }
            case BOOLEAN: {
                return Array.getBoolean(dataSet, ordinal);
            }
            case BYTE: {
                return Array.getByte(dataSet, ordinal);
            }
            case CHAR: {
                return Character.valueOf(Array.getChar(dataSet, ordinal));
            }
            case SHORT: {
                return Array.getShort(dataSet, ordinal);
            }
            case INT: {
                return Array.getInt(dataSet, ordinal);
            }
            case LONG: {
                return Array.getLong(dataSet, ordinal);
            }
            case OTHER: {
                return Array.get(dataSet, ordinal);
            }
        }
        throw new AssertionError((Object)("unexpected " + (Object)((Object)this)));
    }

    public void arrayItem(Source source, Object dataSet, int ordinal) {
        switch (this) {
            case DOUBLE: {
                Array.setDouble(dataSet, ordinal, source.getDouble());
                return;
            }
            case FLOAT: {
                Array.setFloat(dataSet, ordinal, source.getFloat());
                return;
            }
            case BOOLEAN: {
                Array.setBoolean(dataSet, ordinal, source.getBoolean());
                return;
            }
            case BYTE: {
                Array.setByte(dataSet, ordinal, source.getByte());
                return;
            }
            case CHAR: {
                Array.setChar(dataSet, ordinal, source.getChar());
                return;
            }
            case SHORT: {
                Array.setShort(dataSet, ordinal, source.getShort());
                return;
            }
            case INT: {
                Array.setInt(dataSet, ordinal, source.getInt());
                return;
            }
            case LONG: {
                Array.setLong(dataSet, ordinal, source.getLong());
                return;
            }
            case OTHER: {
                Array.set(dataSet, ordinal, source.getObject());
                return;
            }
        }
        throw new AssertionError((Object)("unexpected " + (Object)((Object)this)));
    }

    public void arrayItem(Object dataSet, int ordinal, Sink sink) {
        switch (this) {
            case DOUBLE: {
                sink.set(Array.getDouble(dataSet, ordinal));
                return;
            }
            case FLOAT: {
                sink.set(Array.getFloat(dataSet, ordinal));
                return;
            }
            case BOOLEAN: {
                sink.set(Array.getBoolean(dataSet, ordinal));
                return;
            }
            case BYTE: {
                sink.set(Array.getByte(dataSet, ordinal));
                return;
            }
            case CHAR: {
                sink.set(Array.getChar(dataSet, ordinal));
                return;
            }
            case SHORT: {
                sink.set(Array.getShort(dataSet, ordinal));
                return;
            }
            case INT: {
                sink.set(Array.getInt(dataSet, ordinal));
                return;
            }
            case LONG: {
                sink.set(Array.getLong(dataSet, ordinal));
                return;
            }
            case OTHER: {
                sink.set(Array.get(dataSet, ordinal));
                return;
            }
        }
        throw new AssertionError((Object)("unexpected " + (Object)((Object)this)));
    }

    public Object jdbcGet(ResultSet resultSet, int i) throws SQLException {
        switch (this) {
            case BOOLEAN: {
                return resultSet.getBoolean(i);
            }
            case BYTE: {
                return resultSet.getByte(i);
            }
            case CHAR: {
                return Character.valueOf((char)resultSet.getShort(i));
            }
            case DOUBLE: {
                return resultSet.getDouble(i);
            }
            case FLOAT: {
                return Float.valueOf(resultSet.getFloat(i));
            }
            case INT: {
                return resultSet.getInt(i);
            }
            case LONG: {
                return resultSet.getLong(i);
            }
            case SHORT: {
                return resultSet.getShort(i);
            }
        }
        return resultSet.getObject(i);
    }

    public void jdbc(ResultSet resultSet, int i, Sink sink) throws SQLException {
        switch (this) {
            case BOOLEAN: {
                sink.set(resultSet.getBoolean(i));
                break;
            }
            case BYTE: {
                sink.set(resultSet.getByte(i));
                break;
            }
            case CHAR: {
                sink.set((char)resultSet.getShort(i));
                break;
            }
            case DOUBLE: {
                sink.set(resultSet.getDouble(i));
                break;
            }
            case FLOAT: {
                sink.set(resultSet.getFloat(i));
                break;
            }
            case INT: {
                sink.set(resultSet.getInt(i));
                break;
            }
            case LONG: {
                sink.set(resultSet.getLong(i));
                break;
            }
            case SHORT: {
                sink.set(resultSet.getShort(i));
                break;
            }
            default: {
                sink.set(resultSet.getObject(i));
            }
        }
    }

    public void send(Source source, Sink sink) {
        switch (this) {
            case BOOLEAN: {
                sink.set(source.getBoolean());
                break;
            }
            case BYTE: {
                sink.set(source.getByte());
                break;
            }
            case CHAR: {
                sink.set(source.getChar());
                break;
            }
            case DOUBLE: {
                sink.set(source.getDouble());
                break;
            }
            case FLOAT: {
                sink.set(source.getFloat());
                break;
            }
            case INT: {
                sink.set(source.getInt());
                break;
            }
            case LONG: {
                sink.set(source.getLong());
                break;
            }
            case SHORT: {
                sink.set(source.getShort());
                break;
            }
            default: {
                sink.set(source.getObject());
            }
        }
    }

    public Object parse(String stringValue) {
        switch (this) {
            case BOOLEAN: {
                return Boolean.valueOf(stringValue);
            }
            case BYTE: {
                return Byte.valueOf(stringValue);
            }
            case CHAR: {
                return Character.valueOf(stringValue.charAt(0));
            }
            case DOUBLE: {
                return Double.valueOf(stringValue);
            }
            case FLOAT: {
                return Float.valueOf(stringValue);
            }
            case INT: {
                return Integer.valueOf(stringValue);
            }
            case LONG: {
                return Long.valueOf(stringValue);
            }
            case SHORT: {
                return Short.valueOf(stringValue);
            }
        }
        throw new AssertionError((Object)stringValue);
    }

    public boolean assignableFrom(Primitive primitive) {
        return !(this.family != primitive.family || this.ordinal() < primitive.ordinal() || this == SHORT && primitive == CHAR || this == CHAR && primitive == BYTE);
    }

    public Number number(Number value) {
        switch (this) {
            case BYTE: {
                return value.byteValue();
            }
            case DOUBLE: {
                return value.doubleValue();
            }
            case FLOAT: {
                return Float.valueOf(value.floatValue());
            }
            case INT: {
                return value.intValue();
            }
            case LONG: {
                return value.longValue();
            }
            case SHORT: {
                return value.shortValue();
            }
        }
        throw new AssertionError((Object)((Object)((Object)this) + ": " + value));
    }

    static {
        Primitive[] values;
        BOOLEAN = new Primitive(Boolean.TYPE, Boolean.class, 1, false, false, null, null, true, -1);
        BYTE = new Primitive(Byte.TYPE, Byte.class, 2, (byte)0, (byte)-128, null, null, (byte)127, 8);
        CHAR = new Primitive(Character.TYPE, Character.class, 2, Character.valueOf('\u0000'), Character.valueOf('\u0000'), null, null, Character.valueOf('\uffff'), 16);
        SHORT = new Primitive(Short.TYPE, Short.class, 2, (short)0, (short)Short.MIN_VALUE, null, null, (short)Short.MAX_VALUE, 16);
        INT = new Primitive(Integer.TYPE, Integer.class, 2, 0, Integer.MIN_VALUE, null, null, Integer.MAX_VALUE, 32);
        LONG = new Primitive(Long.TYPE, Long.class, 2, 0L, Long.MIN_VALUE, null, null, Long.MAX_VALUE, 64);
        FLOAT = new Primitive(Float.TYPE, Float.class, 2, Float.valueOf(0.0f), Float.valueOf(-3.4028235E38f), Float.valueOf(-1.4E-45f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), 32);
        DOUBLE = new Primitive(Double.TYPE, Double.class, 2, 0.0, -1.7976931348623157E308, -4.9E-324, Double.MIN_VALUE, Double.MAX_VALUE, 64);
        VOID = new Primitive(Void.TYPE, Void.class, 3, null, null, null, null, null, -1);
        OTHER = new Primitive(null, null, 4, null, null, null, null, null, -1);
        $VALUES = new Primitive[]{BOOLEAN, BYTE, CHAR, SHORT, INT, LONG, FLOAT, DOUBLE, VOID, OTHER};
        PRIMITIVE_MAP = new HashMap<Class, Primitive>();
        BOX_MAP = new HashMap<Class, Primitive>();
        for (Primitive value : values = Primitive.values()) {
            if (value.primitiveClass != null) {
                PRIMITIVE_MAP.put(value.primitiveClass, value);
            }
            if (value.boxClass == null) continue;
            BOX_MAP.put(value.boxClass, value);
        }
    }

    public static enum Flavor {
        PRIMITIVE,
        BOX,
        OBJECT;

    }

    public static interface Source {
        public boolean getBoolean();

        public byte getByte();

        public char getChar();

        public short getShort();

        public int getInt();

        public long getLong();

        public float getFloat();

        public double getDouble();

        public Object getObject();
    }

    public static interface Sink {
        public void set(boolean var1);

        public void set(byte var1);

        public void set(char var1);

        public void set(short var1);

        public void set(int var1);

        public void set(long var1);

        public void set(float var1);

        public void set(double var1);

        public void set(Object var1);
    }
}

