/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.Table;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.List;
import java.util.Properties;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.hint.RelHint;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.TranslatableTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class TableScanConverter
extends RelConverter<ResolvedNodes.ResolvedTableScan> {
    TableScanConverter(@UnknownKeyFor @NonNull @Initialized ConversionContext context) {
        super(context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RelNode convert(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedTableScan zetaNode, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs) {
        List<String> tablePath = this.getTablePath(zetaNode.getTable());
        SchemaPlus defaultSchemaPlus = this.getConfig().getDefaultSchema();
        if (defaultSchemaPlus == null) {
            throw new AssertionError((Object)"Default schema is null.");
        }
        org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table calciteTable = TableResolution.resolveCalciteTable(defaultSchemaPlus, tablePath);
        Preconditions.checkNotNull((Object)calciteTable, (String)"Unable to resolve the table path %s in schema %s", tablePath, (Object)defaultSchemaPlus.getName());
        String defaultSchemaName = defaultSchemaPlus.getName();
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)defaultSchemaPlus), (List)ImmutableList.of((Object)defaultSchemaName), this.getCluster().getTypeFactory(), (CalciteConnectionConfig)new CalciteConnectionConfigImpl(new Properties()));
        RelOptTableImpl relOptTable = RelOptTableImpl.create((RelOptSchema)catalogReader, (RelDataType)calciteTable.getRowType(this.getCluster().getTypeFactory()), (org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table)calciteTable, (ImmutableList)ImmutableList.builder().add((Object)defaultSchemaName).addAll(tablePath).build());
        if (calciteTable instanceof TranslatableTable) {
            return ((TranslatableTable)calciteTable).toRel(this.createToRelContext(), (RelOptTable)relOptTable);
        }
        throw new UnsupportedOperationException("Does not support non TranslatableTable type table!");
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getTablePath(@UnknownKeyFor @NonNull @Initialized Table table) {
        if (!this.getTrait().isTableResolved(table)) {
            throw new IllegalArgumentException("Unexpected table found when converting to Calcite rel node: " + table);
        }
        return this.getTrait().getTablePath(table);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RelOptTable.ToRelContext createToRelContext() {
        return new RelOptTable.ToRelContext(){

            public @UnknownKeyFor @NonNull @Initialized RelRoot expandView(@UnknownKeyFor @NonNull @Initialized RelDataType relDataType, @UnknownKeyFor @NonNull @Initialized String s, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> list, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> list1) {
                throw new UnsupportedOperationException("This RelContext does not support expandView");
            }

            public @UnknownKeyFor @NonNull @Initialized RelOptCluster getCluster() {
                return TableScanConverter.this.getCluster();
            }

            public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelHint> getTableHints() {
                return ImmutableList.of();
            }
        };
    }
}

