/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation.impl;

import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.impl.BeamCodegenUtils;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.FunctionParameter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.ImplementableFunction;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;

@Internal
public class CastFunctionImpl
implements ImplementableFunction {
    public CallImplementor getImplementor() {
        return RexImpTable.createImplementor((NotNullImplementor)new ZetaSQLCastCallNotNullImplementor(), (NullPolicy)NullPolicy.STRICT, (boolean)false);
    }

    public List<FunctionParameter> getParameters() {
        return Collections.emptyList();
    }

    private static class ZetaSQLCastCallNotNullImplementor
    implements NotNullImplementor {
        private ZetaSQLCastCallNotNullImplementor() {
        }

        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> list) {
            MethodCallExpression convertedOperand;
            if (rexCall.getOperands().size() != 1 || list.size() != 1) {
                throw new IllegalArgumentException("CAST should have one operand.");
            }
            SqlTypeName toType = rexCall.getType().getSqlTypeName();
            SqlTypeName fromType = ((RexNode)rexCall.getOperands().get(0)).getType().getSqlTypeName();
            Expression translatedOperand = list.get(0);
            if (fromType == SqlTypeName.BINARY && toType == SqlTypeName.VARCHAR) {
                convertedOperand = Expressions.call(BeamCodegenUtils.class, (String)"toStringUTF8", (Expression[])new Expression[]{Expressions.call((Expression)translatedOperand, (String)"getBytes", (Expression[])new Expression[0])});
            } else if (fromType == SqlTypeName.VARBINARY && toType == SqlTypeName.VARCHAR) {
                convertedOperand = Expressions.call(BeamCodegenUtils.class, (String)"toStringUTF8", (Expression[])new Expression[]{translatedOperand});
            } else if (fromType == SqlTypeName.BOOLEAN && toType == SqlTypeName.BIGINT) {
                convertedOperand = Expressions.condition((Expression)translatedOperand, (Expression)Expressions.constant((Object)1L, Long.class), (Expression)Expressions.constant((Object)0L, Long.class));
            } else if (fromType == SqlTypeName.BIGINT && toType == SqlTypeName.BOOLEAN) {
                convertedOperand = Expressions.notEqual((Expression)translatedOperand, (Expression)Expressions.constant((Object)0));
            } else if (fromType == SqlTypeName.TIMESTAMP && toType == SqlTypeName.VARCHAR) {
                convertedOperand = Expressions.call(BeamCodegenUtils.class, (String)"toStringTimestamp", (Expression[])new Expression[]{translatedOperand});
            } else {
                throw new UnsupportedOperationException("Unsupported CAST: " + fromType.name() + " to " + toType.name());
            }
            if (((RexNode)rexCall.getOperands().get(0)).getType().isNullable()) {
                convertedOperand = Expressions.condition((Expression)Expressions.equal((Expression)translatedOperand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)convertedOperand);
            }
            return convertedOperand;
        }
    }
}

