/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.Table;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.List;
import java.util.Properties;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.hint.RelHint;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.TranslatableTable;
import org.checkerframework.checker.nullness.qual.Nullable;

class TableScanConverter
extends RelConverter<ResolvedNodes.ResolvedTableScan> {
    TableScanConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedTableScan zetaNode, List<RelNode> inputs) {
        List<String> tablePath = this.getTablePath(zetaNode.getTable());
        SchemaPlus defaultSchemaPlus = this.getConfig().getDefaultSchema();
        if (defaultSchemaPlus == null) {
            throw new AssertionError((Object)"Default schema is null.");
        }
        org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table calciteTable = TableResolution.resolveCalciteTable(defaultSchemaPlus, tablePath);
        Preconditions.checkNotNull((Object)calciteTable, (String)"Unable to resolve the table path %s in schema %s", tablePath, (Object)defaultSchemaPlus.getName());
        String defaultSchemaName = defaultSchemaPlus.getName();
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)defaultSchemaPlus), (List)ImmutableList.of((Object)defaultSchemaName), this.getCluster().getTypeFactory(), (CalciteConnectionConfig)new CalciteConnectionConfigImpl(new Properties()));
        RelOptTableImpl relOptTable = RelOptTableImpl.create((RelOptSchema)catalogReader, (RelDataType)calciteTable.getRowType(this.getCluster().getTypeFactory()), (org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table)calciteTable, (ImmutableList)ImmutableList.builder().add((Object)defaultSchemaName).addAll(tablePath).build());
        if (calciteTable instanceof TranslatableTable) {
            return ((TranslatableTable)calciteTable).toRel(this.createToRelContext(), (RelOptTable)relOptTable);
        }
        throw new UnsupportedOperationException("Does not support non TranslatableTable type table!");
    }

    private List<String> getTablePath(Table table) {
        if (!this.getTrait().isTableResolved(table)) {
            throw new IllegalArgumentException("Unexpected table found when converting to Calcite rel node: " + table);
        }
        return this.getTrait().getTablePath(table);
    }

    private RelOptTable.ToRelContext createToRelContext() {
        return new RelOptTable.ToRelContext(){

            public RelRoot expandView(RelDataType relDataType, String s, List<String> list, @Nullable List<String> list1) {
                throw new UnsupportedOperationException("This RelContext does not support expandView");
            }

            public RelOptCluster getCluster() {
                return TableScanConverter.this.getCluster();
            }

            public List<RelHint> getTableHints() {
                return ImmutableList.of();
            }
        };
    }
}

