/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_26_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;

class ProjectScanConverter
extends RelConverter<ResolvedNodes.ResolvedProjectScan> {
    ProjectScanConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedProjectScan zetaNode) {
        return Collections.singletonList(zetaNode.getInputScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedProjectScan zetaNode, List<RelNode> inputs) {
        RelNode input = inputs.get(0);
        List<RexNode> projects = this.getExpressionConverter().retrieveRexNode(zetaNode, input.getRowType().getFieldList());
        List<String> fieldNames = this.getTrait().retrieveFieldNames((List<ResolvedColumn>)zetaNode.getColumnList());
        return LogicalProject.create((RelNode)input, (List)ImmutableList.of(), projects, fieldNames);
    }
}

