/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.CalcRelSplitter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ZetaSqlScalarFunctionImpl;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexDynamicParam;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexFieldAccess;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.tools.RelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeamCalcRelType
extends CalcRelSplitter.RelType {
    private static final Logger LOG = LoggerFactory.getLogger(BeamCalcRelType.class);

    BeamCalcRelType(String name) {
        super(name);
    }

    protected boolean canImplement(RexFieldAccess field) {
        return this.supportsType(field.getType());
    }

    protected boolean canImplement(RexLiteral literal) {
        return this.supportsType(literal.getType());
    }

    protected boolean canImplement(RexDynamicParam param) {
        return this.supportsType(param.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canImplement(RexCall call) {
        SqlOperator operator = call.getOperator();
        RexImpTable.RexCallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            return false;
        }
        if (!(operator instanceof SqlUserDefinedFunction)) return false;
        SqlUserDefinedFunction udf = (SqlUserDefinedFunction)call.op;
        if (!(udf.function instanceof ZetaSqlScalarFunctionImpl)) return false;
        ZetaSqlScalarFunctionImpl scalarFunction = (ZetaSqlScalarFunctionImpl)udf.function;
        if (!scalarFunction.functionGroup.equals("user_defined_java_scalar_functions")) {
            return false;
        }
        for (RexNode operand : call.getOperands()) {
            if (operand instanceof RexLocalRef) {
                if (this.supportsType(operand.getType())) continue;
                LOG.error("User-defined function {} received unsupported operand type {}.", (Object)call.op.getName(), (Object)((RexLocalRef)operand).getType());
                return false;
            }
            LOG.error("User-defined function {} received unrecognized operand kind {}.", (Object)call.op.getName(), (Object)operand.getKind());
            return false;
        }
        return true;
    }

    protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traitSet, RelBuilder relBuilder, RelNode input, RexProgram program) {
        RexProgram normalizedProgram = program.normalize(cluster.getRexBuilder(), false);
        return new BeamCalcRel(cluster, traitSet.replace((RelTrait)BeamLogicalConvention.INSTANCE), RelOptRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE)), normalizedProgram);
    }

    private boolean supportsType(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case BIGINT: 
            case BINARY: 
            case BOOLEAN: 
            case CHAR: 
            case DATE: 
            case DECIMAL: 
            case DOUBLE: 
            case NULL: 
            case TIMESTAMP: 
            case VARBINARY: 
            case VARCHAR: {
                return true;
            }
            case ARRAY: {
                return this.supportsType(type.getComponentType());
            }
            case ROW: {
                return type.getFieldList().stream().allMatch(field -> this.supportsType(field.getType()));
            }
        }
        return false;
    }
}

