/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.PreparedExpression;
import com.google.zetasql.Type;
import com.google.zetasql.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamSqlUnparseContext;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlBeamTranslationUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlCalciteTranslationUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class BeamZetaSqlCalcRel
extends AbstractBeamCalcRel {
    private static final @UnknownKeyFor @NonNull @Initialized SqlDialect DIALECT = BeamBigQuerySqlDialect.DEFAULT;
    private final @UnknownKeyFor @NonNull @Initialized BeamSqlUnparseContext context;

    private static @UnknownKeyFor @NonNull @Initialized String columnName(@UnknownKeyFor @NonNull @Initialized int i) {
        return "_" + i;
    }

    public BeamZetaSqlCalcRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
        super(cluster, traits, input, program);
        IntFunction<SqlNode> fn = i -> new SqlIdentifier(BeamZetaSqlCalcRel.columnName(i), SqlParserPos.ZERO);
        this.context = new BeamSqlUnparseContext(fn);
    }

    public @UnknownKeyFor @NonNull @Initialized Calc copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
        return new BeamZetaSqlCalcRel(this.getCluster(), traitSet, input, program);
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> createNullParams(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RelDataType> input) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        for (Map.Entry<String, RelDataType> entry : input.entrySet()) {
            result.put(entry.getKey(), Value.createNullValue((Type)ZetaSqlCalciteTranslationUtils.toZetaSqlType(entry.getValue())));
        }
        return result;
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized String sql;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> nullParams;
        private final @UnknownKeyFor @NonNull @Initialized Schema inputSchema;
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
        private final @UnknownKeyFor @NonNull @Initialized String defaultTimezone;
        private final @UnknownKeyFor @NonNull @Initialized boolean verifyRowValues;
        private transient @UnknownKeyFor @NonNull @Initialized PreparedExpression exp;
        private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> referencedColumns;

        CalcFn(@UnknownKeyFor @NonNull @Initialized String sql, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> nullParams, @UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized String defaultTimezone, @UnknownKeyFor @NonNull @Initialized boolean verifyRowValues) {
            this.sql = sql;
            this.nullParams = nullParams;
            this.inputSchema = inputSchema;
            this.outputSchema = outputSchema;
            this.defaultTimezone = defaultTimezone;
            this.verifyRowValues = verifyRowValues;
        }

        @DoFn.Setup
        public void setup() {
            AnalyzerOptions options = SqlAnalyzer.getAnalyzerOptions(QueryPlanner.QueryParameters.ofNamed(this.nullParams), this.defaultTimezone);
            for (int i = 0; i < this.inputSchema.getFieldCount(); ++i) {
                options.addExpressionColumn(BeamZetaSqlCalcRel.columnName(i), ZetaSqlBeamTranslationUtils.toZetaSqlType(this.inputSchema.getField(i).getType()));
            }
            this.exp = new PreparedExpression(this.sql);
            this.exp.prepare(options);
            ImmutableList.Builder columns = new ImmutableList.Builder();
            for (String c : this.exp.getReferencedColumns()) {
                columns.add((Object)Integer.parseInt(c.substring(1)));
            }
            this.referencedColumns = columns.build();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            HashMap<String, Value> columns = new HashMap<String, Value>();
            Row row = (Row)c.element();
            for (int i : this.referencedColumns) {
                columns.put(BeamZetaSqlCalcRel.columnName(i), ZetaSqlBeamTranslationUtils.toZetaSqlValue(row.getBaseValue(i, Object.class), this.inputSchema.getField(i).getType()));
            }
            Value v = this.exp.execute(columns, this.nullParams);
            if (!v.isNull()) {
                Row outputRow = ZetaSqlBeamTranslationUtils.toBeamRow(v, this.outputSchema, this.verifyRowValues);
                c.output((Object)outputRow);
            }
        }

        @DoFn.Teardown
        public void teardown() {
            this.exp.close();
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"%s expected a single input PCollection, but received %d.", (Object)BeamZetaSqlCalcRel.class.getSimpleName(), (int)pinput.size());
            PCollection upstream = pinput.get(0);
            RexBuilder rexBuilder = BeamZetaSqlCalcRel.this.getCluster().getRexBuilder();
            RexNode rex = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, BeamZetaSqlCalcRel.this.getProgram().getProjectList());
            RexLocalRef condition = BeamZetaSqlCalcRel.this.getProgram().getCondition();
            if (condition != null) {
                rex = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{condition, rex, rexBuilder.makeNullLiteral(BeamZetaSqlCalcRel.this.getRowType())});
            }
            BeamSqlPipelineOptions options = (BeamSqlPipelineOptions)pinput.getPipeline().getOptions().as(BeamSqlPipelineOptions.class);
            Schema outputSchema = CalciteUtils.toSchema((RelDataType)BeamZetaSqlCalcRel.this.getRowType());
            CalcFn calcFn = new CalcFn(BeamZetaSqlCalcRel.this.context.toSql(BeamZetaSqlCalcRel.this.getProgram(), rex).toSqlString(DIALECT).getSql(), BeamZetaSqlCalcRel.createNullParams(BeamZetaSqlCalcRel.this.context.getNullParams()), upstream.getSchema(), outputSchema, options.getZetaSqlDefaultTimezone(), options.getVerifyRowValues());
            calcFn.setup();
            return ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
        }
    }
}

