/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.FileDescriptorSetsBuilder;
import com.google.zetasql.FunctionProtos;
import com.google.zetasql.TableValuedFunction;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;

class TVFScanConverter
extends RelConverter<ResolvedNodes.ResolvedTVFScan> {
    TVFScanConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedTVFScan zetaNode, List<RelNode> inputs) {
        RelNode input = inputs.get(0);
        RexCall call = this.getExpressionConverter().convertTableValuedFunction(input, zetaNode.getTvf(), (List<ResolvedNodes.ResolvedTVFArgument>)zetaNode.getArgumentList(), (List<ResolvedColumn>)(((ResolvedNodes.ResolvedTVFArgument)zetaNode.getArgumentList().get(0)).getScan() != null ? ((ResolvedNodes.ResolvedTVFArgument)zetaNode.getArgumentList().get(0)).getScan().getColumnList() : Collections.emptyList()));
        LogicalTableFunctionScan tableFunctionScan = LogicalTableFunctionScan.create((RelOptCluster)this.getCluster(), inputs, (RexNode)call, null, (RelDataType)call.getType(), (Set)Collections.EMPTY_SET);
        this.context.clearFunctionArgumentRefMapping();
        return tableFunctionScan;
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedTVFScan zetaNode) {
        ArrayList<ResolvedNode> inputs = new ArrayList<ResolvedNode>();
        if (zetaNode.getTvf() != null && this.context.getUserDefinedTableValuedFunctions().containsKey(zetaNode.getTvf().getNamePath())) {
            inputs.add(this.context.getUserDefinedTableValuedFunctions().get(zetaNode.getTvf().getNamePath()));
        }
        for (ResolvedNodes.ResolvedTVFArgument argument : zetaNode.getArgumentList()) {
            if (argument.getScan() == null) continue;
            inputs.add((ResolvedNode)argument.getScan());
        }
        if (zetaNode.getTvf() instanceof TableValuedFunction.FixedOutputSchemaTVF) {
            FileDescriptorSetsBuilder temp = new FileDescriptorSetsBuilder();
            FunctionProtos.TableValuedFunctionProto tableValuedFunctionProto = zetaNode.getTvf().serialize(temp);
            for (int i = 0; i < tableValuedFunctionProto.getSignature().getArgumentList().size(); ++i) {
                ResolvedNodes.ResolvedTVFArgument resolvedTVFArgument;
                String argumentName = tableValuedFunctionProto.getSignature().getArgument(i).getOptions().getArgumentName();
                if (((ResolvedNodes.ResolvedTVFArgument)zetaNode.getArgumentList().get(i)).nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_TVFARGUMENT || (resolvedTVFArgument = (ResolvedNodes.ResolvedTVFArgument)zetaNode.getArgumentList().get(i)).getExpr().nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_LITERAL) continue;
                ResolvedNodes.ResolvedLiteral literal = (ResolvedNodes.ResolvedLiteral)resolvedTVFArgument.getExpr();
                this.context.addToFunctionArgumentRefMapping(argumentName, this.getExpressionConverter().convertResolvedLiteral(literal));
            }
        }
        return inputs;
    }
}

