/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelRecordType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;

class TVFScanConverter
extends RelConverter<ResolvedNodes.ResolvedTVFScan> {
    TVFScanConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedTVFScan zetaNode, List<RelNode> inputs) {
        RelNode input = inputs.get(0);
        LogicalTableFunctionScan tableFunctionScan = LogicalTableFunctionScan.create((RelOptCluster)this.getCluster(), inputs, (RexNode)this.getExpressionConverter().convertTableValuedFunction(input, zetaNode.getTvf(), (List<ResolvedNodes.ResolvedTVFArgument>)zetaNode.getArgumentList(), (List<ResolvedColumn>)((ResolvedNodes.ResolvedTVFArgument)zetaNode.getArgumentList().get(0)).getScan().getColumnList()), null, (RelDataType)this.createRowTypeWithWindowStartAndEnd(input.getRowType()), (Set)Collections.EMPTY_SET);
        return tableFunctionScan;
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedTVFScan zetaNode) {
        ArrayList<ResolvedNode> inputs = new ArrayList<ResolvedNode>();
        for (ResolvedNodes.ResolvedTVFArgument argument : zetaNode.getArgumentList()) {
            if (argument.getScan() == null) continue;
            inputs.add((ResolvedNode)argument.getScan());
        }
        return inputs;
    }

    private RelDataType createRowTypeWithWindowStartAndEnd(RelDataType inputRowType) {
        ArrayList<RelDataTypeFieldImpl> newFields = new ArrayList<RelDataTypeFieldImpl>(inputRowType.getFieldList());
        RelDataType timestampType = this.getCluster().getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
        RelDataTypeFieldImpl windowStartField = new RelDataTypeFieldImpl("window_start", newFields.size(), timestampType);
        newFields.add(windowStartField);
        RelDataTypeFieldImpl windowEndField = new RelDataTypeFieldImpl("window_end", newFields.size(), timestampType);
        newFields.add(windowEndField);
        return new RelRecordType(inputRowType.getStructKind(), newFields);
    }
}

