/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.common.collect.ImmutableList;
import com.google.zetasql.ArrayType;
import com.google.zetasql.StructType;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.ZetaSQLType;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Internal
public class TypeUtils {
    private static final ImmutableMap<SqlTypeName, Type> CALCITE_TO_ZETA_SIMPLE_TYPES = ImmutableMap.builder().put((Object)SqlTypeName.BIGINT, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64)).put((Object)SqlTypeName.INTEGER, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT32)).put((Object)SqlTypeName.VARCHAR, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING)).put((Object)SqlTypeName.BOOLEAN, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BOOL)).put((Object)SqlTypeName.FLOAT, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_FLOAT)).put((Object)SqlTypeName.DOUBLE, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE)).put((Object)SqlTypeName.VARBINARY, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BYTES)).put((Object)SqlTypeName.TIMESTAMP, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)).put((Object)SqlTypeName.DATE, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATE)).put((Object)SqlTypeName.TIME, (Object)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIME)).build();
    private static final ImmutableMap<ZetaSQLType.TypeKind, Function<RexBuilder, RelDataType>> ZETA_TO_CALCITE_SIMPLE_TYPES = ImmutableMap.builder().put((Object)ZetaSQLType.TypeKind.TYPE_NUMERIC, TypeUtils.relDataTypeFactory(SqlTypeName.DECIMAL)).put((Object)ZetaSQLType.TypeKind.TYPE_INT32, TypeUtils.relDataTypeFactory(SqlTypeName.INTEGER)).put((Object)ZetaSQLType.TypeKind.TYPE_INT64, TypeUtils.relDataTypeFactory(SqlTypeName.BIGINT)).put((Object)ZetaSQLType.TypeKind.TYPE_FLOAT, TypeUtils.relDataTypeFactory(SqlTypeName.FLOAT)).put((Object)ZetaSQLType.TypeKind.TYPE_DOUBLE, TypeUtils.relDataTypeFactory(SqlTypeName.DOUBLE)).put((Object)ZetaSQLType.TypeKind.TYPE_STRING, TypeUtils.relDataTypeFactory(SqlTypeName.VARCHAR)).put((Object)ZetaSQLType.TypeKind.TYPE_BOOL, TypeUtils.relDataTypeFactory(SqlTypeName.BOOLEAN)).put((Object)ZetaSQLType.TypeKind.TYPE_BYTES, TypeUtils.relDataTypeFactory(SqlTypeName.VARBINARY)).put((Object)ZetaSQLType.TypeKind.TYPE_DATE, TypeUtils.relDataTypeFactory(SqlTypeName.DATE)).put((Object)ZetaSQLType.TypeKind.TYPE_TIME, TypeUtils.relDataTypeFactory(SqlTypeName.TIME)).put((Object)ZetaSQLType.TypeKind.TYPE_TIMESTAMP, TypeUtils.relDataTypeFactory(SqlTypeName.TIMESTAMP)).build();

    static Type toZetaType(RelDataType calciteType) {
        if (CALCITE_TO_ZETA_SIMPLE_TYPES.containsKey((Object)calciteType.getSqlTypeName())) {
            return (Type)CALCITE_TO_ZETA_SIMPLE_TYPES.get((Object)calciteType.getSqlTypeName());
        }
        switch (calciteType.getSqlTypeName()) {
            case ARRAY: {
                return TypeFactory.createArrayType((Type)TypeUtils.toZetaType(calciteType.getComponentType()));
            }
            case MAP: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING);
            }
            case ROW: {
                List structFields = calciteType.getFieldList().stream().map(f -> new StructType.StructField(f.getName(), TypeUtils.toZetaType(f.getType()))).collect(Collectors.toList());
                return TypeFactory.createStructType(structFields);
            }
        }
        throw new RuntimeException("Unsupported RelDataType: " + calciteType);
    }

    public static RelDataType toRelDataType(RexBuilder rexBuilder, Type type, boolean isNullable) {
        if (type.getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_ARRAY)) {
            return TypeUtils.toArrayRelDataType(rexBuilder, type.asArray(), isNullable);
        }
        if (type.getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_STRUCT)) {
            return TypeUtils.toStructRelDataType(rexBuilder, type.asStruct(), isNullable);
        }
        return TypeUtils.toSimpleRelDataType(type.getKind(), rexBuilder, isNullable);
    }

    public static RelDataType toArrayRelDataType(RexBuilder rexBuilder, ArrayType arrayType, boolean isNullable) {
        return rexBuilder.getTypeFactory().createArrayType(TypeUtils.toRelDataType(rexBuilder, arrayType.getElementType(), isNullable), -1L);
    }

    private static RelDataType toStructRelDataType(RexBuilder rexBuilder, StructType structType, boolean isNullable) {
        ImmutableList fields = structType.getFieldList();
        List fieldNames = fields.stream().map(StructType.StructField::getName).collect(Collectors.toList());
        List fieldTypes = fields.stream().map(f -> TypeUtils.toRelDataType(rexBuilder, f.getType(), isNullable)).collect(Collectors.toList());
        return rexBuilder.getTypeFactory().createStructType(fieldTypes, fieldNames);
    }

    public static RelDataType toSimpleRelDataType(ZetaSQLType.TypeKind kind, RexBuilder rexBuilder) {
        return TypeUtils.toSimpleRelDataType(kind, rexBuilder, true);
    }

    public static RelDataType toSimpleRelDataType(ZetaSQLType.TypeKind kind, RexBuilder rexBuilder, boolean isNullable) {
        if (!ZETA_TO_CALCITE_SIMPLE_TYPES.containsKey((Object)kind)) {
            throw new RuntimeException("Unsupported column type: " + kind);
        }
        RelDataType relDataType = (RelDataType)((Function)ZETA_TO_CALCITE_SIMPLE_TYPES.get((Object)kind)).apply(rexBuilder);
        return TypeUtils.nullable(rexBuilder, relDataType, isNullable);
    }

    private static RelDataType nullable(RexBuilder r, RelDataType relDataType, boolean isNullable) {
        return r.getTypeFactory().createTypeWithNullability(relDataType, isNullable);
    }

    private static Function<RexBuilder, RelDataType> relDataTypeFactory(SqlTypeName typeName) {
        return r -> r.getTypeFactory().createSqlType(typeName);
    }
}

