/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.protobuf.ProtoDomain;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaTranslator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ProtoBeamConverter {
    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Message> toProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
        return new ToProto(descriptor);
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Message, @UnknownKeyFor @NonNull @Initialized Row> toRow(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new FromProto(schema);
    }

    static @UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> createProtoToBeamConverter(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: {
                return ProtoBeamConverter.createWrappableProtoToBeamConverter(ProtoToBeamConverter.identity());
            }
            case BYTES: {
                return ProtoBeamConverter.createWrappableProtoToBeamConverter(ByteString::toByteArray);
            }
            case ARRAY: 
            case ITERABLE: {
                ProtoToBeamConverter<Object, Object> elementConverter = ProtoBeamConverter.createProtoToBeamConverter((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getCollectionElementType()));
                return proto -> ((List)proto).stream().map(element -> Preconditions.checkNotNull(elementConverter.convert(element))).collect(Collectors.toList());
            }
            case MAP: {
                ProtoToBeamConverter<Object, Object> keyConverter = ProtoBeamConverter.createProtoToBeamConverter((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getMapKeyType()));
                ProtoToBeamConverter<Object, Object> valueConverter = ProtoBeamConverter.createProtoToBeamConverter((Schema.FieldType)Preconditions.checkNotNull((Object)fieldType.getMapValueType()));
                return proto -> {
                    List list = (List)proto;
                    if (list.isEmpty()) {
                        return Collections.emptyMap();
                    }
                    Descriptors.Descriptor descriptor = ((Message)list.get(0)).getDescriptorForType();
                    Descriptors.FieldDescriptor keyFieldDescriptor = descriptor.findFieldByNumber(1);
                    Descriptors.FieldDescriptor valueFieldDescriptor = descriptor.findFieldByNumber(2);
                    return list.stream().collect(Collectors.toMap(protoElement -> keyConverter.convert(protoElement.getField(keyFieldDescriptor)), protoElement -> valueConverter.convert(protoElement.getField(valueFieldDescriptor)), (a, b) -> b));
                };
            }
            case ROW: {
                SerializableFunction<Message, Row> converter = ProtoBeamConverter.toRow((Schema)Preconditions.checkNotNull((Object)fieldType.getRowSchema()));
                return message -> converter.apply((Object)((Message)message));
            }
            case LOGICAL_TYPE: {
                switch (((Schema.LogicalType)Preconditions.checkNotNull((Object)fieldType.getLogicalType())).getIdentifier()) {
                    case "Uint32": 
                    case "Sint32": 
                    case "Fixed32": 
                    case "SFixed32": 
                    case "Uint64": 
                    case "Sint64": 
                    case "Fixed64": 
                    case "SFixed64": {
                        return ProtoBeamConverter.createWrappableProtoToBeamConverter(ProtoToBeamConverter.identity());
                    }
                    case "beam:logical_type:nanos_duration:v1": {
                        return proto -> {
                            Message message = (Message)proto;
                            Descriptors.Descriptor durationDescriptor = message.getDescriptorForType();
                            Descriptors.FieldDescriptor secondsFieldDescriptor = durationDescriptor.findFieldByNumber(1);
                            Descriptors.FieldDescriptor nanosFieldDescriptor = durationDescriptor.findFieldByNumber(2);
                            long seconds = (Long)message.getField(secondsFieldDescriptor);
                            int nanos = (Integer)message.getField(nanosFieldDescriptor);
                            return java.time.Duration.ofSeconds(seconds, nanos);
                        };
                    }
                    case "beam:logical_type:nanos_instant:v1": {
                        return proto -> {
                            Message message = (Message)proto;
                            Descriptors.Descriptor timestampDescriptor = message.getDescriptorForType();
                            Descriptors.FieldDescriptor secondsFieldDescriptor = timestampDescriptor.findFieldByNumber(1);
                            Descriptors.FieldDescriptor nanosFieldDescriptor = timestampDescriptor.findFieldByNumber(2);
                            long seconds = (Long)message.getField(secondsFieldDescriptor);
                            int nanos = (Integer)message.getField(nanosFieldDescriptor);
                            return Instant.ofEpochSecond(seconds, nanos);
                        };
                    }
                    case "Enum": {
                        EnumerationType enumerationType = (EnumerationType)fieldType.getLogicalType(EnumerationType.class);
                        return enumValue -> enumerationType.toInputType(Integer.valueOf(((Descriptors.EnumValueDescriptor)enumValue).getNumber()));
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException("Unsupported field type: " + fieldType.getTypeName());
    }

    static @UnknownKeyFor @NonNull @Initialized BeamToProtoConverter<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> createBeamToProtoConverter(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.isRepeated()) {
            if (fieldDescriptor.isMapField()) {
                Descriptors.Descriptor mapDescriptor = fieldDescriptor.getMessageType();
                Descriptors.FieldDescriptor keyDescriptor = mapDescriptor.findFieldByNumber(1);
                Descriptors.FieldDescriptor valueDescriptor = mapDescriptor.findFieldByNumber(2);
                BeamToProtoConverter<Object, Object> keyToProto = ProtoBeamConverter.createBeamToProtoSingularConverter(keyDescriptor);
                BeamToProtoConverter<Object, Object> valueToProto = ProtoBeamConverter.createBeamToProtoSingularConverter(valueDescriptor);
                return map -> {
                    ImmutableList.Builder protoList = ImmutableList.builder();
                    ((Map)map).forEach((k, v) -> {
                        DynamicMessage.Builder message = DynamicMessage.newBuilder((Descriptors.Descriptor)mapDescriptor);
                        Object protoKey = Preconditions.checkNotNull(keyToProto.convert(k));
                        message.setField(keyDescriptor, protoKey);
                        Object protoValue = Preconditions.checkNotNull(valueToProto.convert(v));
                        message.setField(valueDescriptor, protoValue);
                        protoList.add((Object)message.build());
                    });
                    return protoList.build();
                };
            }
            BeamToProtoConverter<Object, Object> converter = ProtoBeamConverter.createBeamToProtoSingularConverter(fieldDescriptor);
            return list -> ((List)list).stream().map(beamElement -> converter.convert(beamElement)).collect(Collectors.toList());
        }
        return ProtoBeamConverter.createBeamToProtoSingularConverter(fieldDescriptor);
    }

    static @UnknownKeyFor @NonNull @Initialized BeamToProtoConverter<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> createBeamToProtoSingularConverter(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getJavaType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case STRING: {
                return ProtoBeamConverter.createWrappableBeamToProtoConverter(fieldDescriptor, BeamToProtoConverter.identity());
            }
            case BYTE_STRING: {
                return ProtoBeamConverter.createWrappableBeamToProtoConverter(fieldDescriptor, bytes -> ByteString.copyFrom((byte[])((byte[])bytes)));
            }
            case ENUM: {
                return value -> fieldDescriptor.getEnumType().findValueByNumber(((EnumerationType.Value)value).getValue());
            }
            case MESSAGE: {
                String fullName;
                switch (fullName = fieldDescriptor.getMessageType().getFullName()) {
                    case "google.protobuf.Int32Value": 
                    case "google.protobuf.UInt32Value": 
                    case "google.protobuf.Int64Value": 
                    case "google.protobuf.UInt64Value": 
                    case "google.protobuf.FloatValue": 
                    case "google.protobuf.DoubleValue": 
                    case "google.protobuf.StringValue": 
                    case "google.protobuf.BoolValue": {
                        return ProtoBeamConverter.createWrappableBeamToProtoConverter(fieldDescriptor, BeamToProtoConverter.identity());
                    }
                    case "google.protobuf.BytesValue": {
                        return ProtoBeamConverter.createWrappableBeamToProtoConverter(fieldDescriptor, bytes -> ByteString.copyFrom((byte[])((byte[])bytes)));
                    }
                    case "google.protobuf.Timestamp": {
                        return beam -> {
                            Instant instant = (Instant)beam;
                            return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
                        };
                    }
                    case "google.protobuf.Duration": {
                        return beam -> {
                            java.time.Duration duration = (java.time.Duration)beam;
                            return Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano()).build();
                        };
                    }
                    case "google.protobuf.Any": {
                        throw new UnsupportedOperationException("google.protobuf.Any is not supported");
                    }
                }
                SerializableFunction<Row, Message> converter = ProtoBeamConverter.toProto(fieldDescriptor.getMessageType());
                return value -> converter.apply((Object)((Row)value));
            }
        }
        throw new UnsupportedOperationException("Unsupported proto type: " + fieldDescriptor.getJavaType());
    }

    static <ProtoUnwrappedT, BeamT> @UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<@UnknownKeyFor @NonNull @Initialized Object, BeamT> createWrappableProtoToBeamConverter(@UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<ProtoUnwrappedT, BeamT> converter) {
        return protoValue -> {
            Object unwrappedProtoValue;
            if (protoValue instanceof Message) {
                Message protoWrapper = (Message)protoValue;
                Descriptors.FieldDescriptor wrapperValueFieldDescriptor = protoWrapper.getDescriptorForType().findFieldByNumber(1);
                unwrappedProtoValue = Preconditions.checkNotNull((Object)protoWrapper.getField(wrapperValueFieldDescriptor));
            } else {
                unwrappedProtoValue = protoValue;
            }
            return converter.convert(unwrappedProtoValue);
        };
    }

    static <BeamT, ProtoUnwrappedT> @UnknownKeyFor @NonNull @Initialized BeamToProtoConverter<BeamT, @UnknownKeyFor @NonNull @Initialized Object> createWrappableBeamToProtoConverter(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized BeamToProtoConverter<BeamT, ProtoUnwrappedT> converter) {
        return beamValue -> {
            Object protoValue = converter.convert(beamValue);
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                Descriptors.Descriptor wrapperDescriptor = fieldDescriptor.getMessageType();
                Descriptors.FieldDescriptor wrapperValueFieldDescriptor = wrapperDescriptor.findFieldByNumber(1);
                DynamicMessage.Builder wrapper = DynamicMessage.newBuilder((Descriptors.Descriptor)wrapperDescriptor);
                wrapper.setField(wrapperValueFieldDescriptor, protoValue);
                return wrapper.build();
            }
            return protoValue;
        };
    }

    static class ToProtoOneOfSetter
    implements ToProtoSetter<OneOfType.Value> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.OneofDescriptor oneofDescriptor;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ToProtoFieldSetter<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> protoSetters;

        ToProtoOneOfSetter(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.OneofDescriptor oneofDescriptor) {
            this.oneofDescriptor = oneofDescriptor;
            this.protoSetters = ToProtoOneOfSetter.createConverters(oneofDescriptor.getFields());
        }

        private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ToProtoFieldSetter<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> createConverters(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor> fieldDescriptors) {
            LinkedHashMap<String, ToProtoFieldSetter<Object, Object>> converters = new LinkedHashMap<String, ToProtoFieldSetter<Object, Object>>();
            for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
                Preconditions.checkState((!fieldDescriptor.isRepeated() ? 1 : 0) != 0);
                converters.put(fieldDescriptor.getName(), new ToProtoFieldSetter(fieldDescriptor));
            }
            return converters;
        }

        @Override
        public void setToProto(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized OneOfType.Value oneOfValue) {
            if (oneOfValue != null) {
                OneOfType oneOfType = (OneOfType)fieldType.getLogicalType(OneOfType.class);
                int number = oneOfValue.getCaseType().getValue();
                try {
                    String subFieldName = (String)Preconditions.checkNotNull((Object)oneOfType.getCaseEnumType().getEnumName(number));
                    ToProtoFieldSetter protoSetter = (ToProtoFieldSetter)Preconditions.checkNotNull(this.protoSetters.get(subFieldName), (String)"No setter for field '%s'", (Object)subFieldName);
                    protoSetter.setToProto(message, oneOfType.getOneOfSchema().getField(subFieldName).getType(), oneOfValue.getValue());
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(String.format("Failed to set oneof to proto. oneof: %s, number: %d", this.oneofDescriptor.getName(), number), e);
                }
            }
        }
    }

    static class ToProtoFieldSetter<@UnknownKeyFor BeamT, @UnknownKeyFor ProtoT>
    implements ToProtoSetter<BeamT> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor;
        private final @UnknownKeyFor @NonNull @Initialized BeamToProtoConverter<BeamT, ProtoT> converter;

        ToProtoFieldSetter(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor) {
            this.fieldDescriptor = fieldDescriptor;
            this.converter = ProtoBeamConverter.createBeamToProtoConverter(fieldDescriptor);
        }

        @Override
        public void setToProto(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @Nullable BeamT beamFieldValue) {
            try {
                if (beamFieldValue != null) {
                    ProtoT protoValue = this.converter.convert(beamFieldValue);
                    message.setField(this.fieldDescriptor, protoValue);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to set field to proto. field:%s", this.fieldDescriptor.getName()), e);
            }
        }
    }

    static class ToProto
    implements SerializableFunction<Row, Message> {
        private transient // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor;
        private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ToProtoSetter<@UnknownKeyFor @NonNull @Initialized Object>> toProtos;

        public ToProto(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
            this.initialize(descriptor);
        }

        @EnsuresNonNull(value={"this.descriptor", "this.toProtos"})
        private void initialize(@UnknownInitialization ToProto this, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
            this.descriptor = descriptor;
            this.toProtos = new LinkedHashMap<String, ToProtoSetter<Object>>();
            for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                if (fieldDescriptor.getRealContainingOneof() != null) {
                    Descriptors.OneofDescriptor realContainingOneof = fieldDescriptor.getRealContainingOneof();
                    if (realContainingOneof.getField(0) != fieldDescriptor) continue;
                    ToProtoOneOfSetter setter = new ToProtoOneOfSetter(realContainingOneof);
                    this.toProtos.put(realContainingOneof.getName(), setter);
                    continue;
                }
                this.toProtos.put(fieldDescriptor.getName(), new ToProtoFieldSetter(fieldDescriptor));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Message apply(@UnknownKeyFor @NonNull @Initialized Row row) {
            Schema schema = row.getSchema();
            DynamicMessage.Builder message = DynamicMessage.newBuilder((Descriptors.Descriptor)this.descriptor);
            for (Map.Entry<String, ToProtoSetter<Object>> entry : this.toProtos.entrySet()) {
                String fieldName = entry.getKey();
                ToProtoSetter<Object> converter = entry.getValue();
                converter.setToProto((Message.Builder)message, schema.getField(fieldName).getType(), row.getValue(fieldName));
            }
            return message.build();
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String messageFullName = this.descriptor.getFullName();
            ProtoDomain protoDomain = ProtoDomain.buildFrom(this.descriptor);
            oos.writeObject(protoDomain);
            oos.writeObject(messageFullName);
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            ProtoDomain protoDomain = (ProtoDomain)ois.readObject();
            String messageFullName = (String)ois.readObject();
            this.initialize(protoDomain.getDescriptor(messageFullName));
        }
    }

    static class FromProtoOneOfGetter
    implements FromProtoGetter<OneOfType.Value> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field;
        private final @UnknownKeyFor @NonNull @Initialized OneOfType oneOfType;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> converter;

        FromProtoOneOfGetter(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            this.field = field;
            this.oneOfType = (OneOfType)Preconditions.checkNotNull((Object)((OneOfType)field.getType().getLogicalType(OneOfType.class)));
            this.converter = FromProtoOneOfGetter.createConverters(this.oneOfType.getOneOfSchema());
        }

        private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> createConverters(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            HashMap<String, ProtoToBeamConverter<Object, Object>> converters = new HashMap<String, ProtoToBeamConverter<Object, Object>>();
            for (Schema.Field field : schema.getFields()) {
                converters.put(field.getName(), ProtoBeamConverter.createProtoToBeamConverter(field.getType()));
            }
            return converters;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized OneOfType.Value getFromProto(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.Descriptor descriptor = message.getDescriptorForType();
            for (Map.Entry<String, ProtoToBeamConverter<Object, Object>> entry : this.converter.entrySet()) {
                String subFieldName = entry.getKey();
                try {
                    ProtoToBeamConverter<Object, Object> value = entry.getValue();
                    Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(subFieldName);
                    if (!message.hasField(fieldDescriptor)) continue;
                    Object protoValue = message.getField(fieldDescriptor);
                    return this.oneOfType.createValue(subFieldName, value.convert(protoValue));
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(String.format("Failed to get oneof from proto. oneof: %s, subfield: %s", this.field.getName(), subFieldName), e);
                }
            }
            return null;
        }
    }

    static class FromProtoFieldGetter<@UnknownKeyFor ProtoT, @UnknownKeyFor BeamT>
    implements FromProtoGetter<BeamT> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field;
        private final @UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<ProtoT, BeamT> converter;

        FromProtoFieldGetter(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            this.field = field;
            this.converter = ProtoBeamConverter.createProtoToBeamConverter(field.getType());
        }

        @Override
        public @Nullable BeamT getFromProto(@UnknownKeyFor @NonNull @Initialized Message message) {
            try {
                Descriptors.Descriptor descriptor = message.getDescriptorForType();
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)Preconditions.checkNotNull((Object)descriptor.findFieldByName(this.field.getName()));
                @Nullable Object protoValue = this.field.getType().getNullable() != false && ProtoSchemaTranslator.isNullable(fieldDescriptor) && !message.hasField(fieldDescriptor) ? null : message.getField(fieldDescriptor);
                return protoValue != null ? (BeamT)this.converter.convert(protoValue) : null;
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to get field from proto. field: %s", this.field.getName()), e);
            }
        }
    }

    static class FromProto
    implements SerializableFunction<Message, Row> {
        private transient @UnknownKeyFor @NonNull @Initialized Schema schema;
        private transient /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FromProtoGetter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> toBeams;

        public FromProto(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.initialize(schema);
        }

        public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized Message message) {
            Row.Builder rowBuilder = Row.withSchema((Schema)this.schema);
            for (FromProtoGetter<?> toBeam : this.toBeams) {
                rowBuilder.addValue(toBeam.getFromProto(message));
            }
            return rowBuilder.build();
        }

        @EnsuresNonNull(value={"this.schema", "this.toBeams"})
        private void initialize(@UnknownInitialization FromProto this, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.schema = schema;
            this.toBeams = new ArrayList();
            for (Schema.Field field : schema.getFields()) {
                Schema.FieldType fieldType = field.getType();
                if (fieldType.isLogicalType("OneOf")) {
                    this.toBeams.add(new FromProtoOneOfGetter(field));
                    continue;
                }
                this.toBeams.add(new FromProtoFieldGetter(field));
            }
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
            oos.writeObject(this.schema);
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            this.initialize((Schema)ois.readObject());
        }
    }

    static interface ToProtoSetter<@UnknownKeyFor BeamT> {
        public void setToProto(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder var1, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType var2, @Nullable BeamT var3);
    }

    @FunctionalInterface
    static interface ProtoToBeamConverter<@UnknownKeyFor ProtoT, @UnknownKeyFor BeamT> {
        public static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> IDENTITY = protoValue -> protoValue;

        public static <T> @UnknownKeyFor @NonNull @Initialized ProtoToBeamConverter<T, T> identity() {
            return IDENTITY;
        }

        public @NonNull BeamT convert(@NonNull ProtoT var1);
    }

    static interface FromProtoGetter<@UnknownKeyFor BeamT> {
        public @Nullable BeamT getFromProto(@UnknownKeyFor @NonNull @Initialized Message var1);
    }

    static interface BeamToProtoConverter<@UnknownKeyFor BeamT, @UnknownKeyFor ProtoT> {
        public static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized BeamToProtoConverter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> IDENTITY = value -> value;

        public static <T> @UnknownKeyFor @NonNull @Initialized BeamToProtoConverter<T, T> identity() {
            return IDENTITY;
        }

        public @NonNull ProtoT convert(@NonNull BeamT var1);
    }
}

