/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.DynamicMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.protobuf.ProtoByteBuddyUtils;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaTranslator;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ProtoMessageSchema
extends GetterBasedSchemaProvider {
    public <T> @Nullable Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
        this.checkForDynamicType(typeDescriptor);
        return ProtoSchemaTranslator.getSchema(typeDescriptor.getRawType());
    }

    public List<FieldValueGetter> fieldValueGetters(Class<?> targetClass, Schema schema) {
        return ProtoByteBuddyUtils.getGetters(targetClass, schema, new ProtoClassFieldValueTypeSupplier(), new ProtoByteBuddyUtils.ProtoTypeConversionsFactory());
    }

    public List<FieldValueTypeInformation> fieldValueTypeInformations(Class<?> targetClass, Schema schema) {
        return JavaBeanUtils.getFieldTypes(targetClass, (Schema)schema, (FieldValueTypeSupplier)new ProtoClassFieldValueTypeSupplier());
    }

    public SchemaUserTypeCreator schemaTypeCreator(Class<?> targetClass, Schema schema) {
        SchemaUserTypeCreator creator = ProtoByteBuddyUtils.getBuilderCreator(targetClass, schema, new ProtoClassFieldValueTypeSupplier());
        if (creator == null) {
            throw new RuntimeException("Cannot create creator for " + targetClass);
        }
        return creator;
    }

    private <T> void checkForDynamicType(TypeDescriptor<T> typeDescriptor) {
        if (typeDescriptor.getRawType().equals(DynamicMessage.class)) {
            throw new RuntimeException("DynamicMessage is not allowed for the standard ProtoSchemaProvider, use ProtoDynamicMessageSchema  instead.");
        }
    }

    private static final class ProtoClassFieldValueTypeSupplier
    implements FieldValueTypeSupplier {
        private ProtoClassFieldValueTypeSupplier() {
        }

        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            throw new RuntimeException("Unexpected call.");
        }

        public List<FieldValueTypeInformation> get(Class<?> clazz, Schema schema) {
            Multimap methods = ReflectUtils.getMethodsMap(clazz);
            ArrayList types = Lists.newArrayListWithCapacity((int)schema.getFieldCount());
            for (Schema.Field field : schema.getFields()) {
                if (field.getType().isLogicalType("OneOf")) {
                    OneOfType oneOfType = (OneOfType)field.getType().getLogicalType(OneOfType.class);
                    HashMap oneOfTypes = Maps.newHashMap();
                    for (Schema.Field oneOfField : oneOfType.getOneOfSchema().getFields()) {
                        Method method = ProtoByteBuddyUtils.getProtoGetter((Multimap<String, Method>)methods, oneOfField.getName(), oneOfField.getType());
                        oneOfTypes.put(oneOfField.getName(), FieldValueTypeInformation.forGetter((Method)method).withName(field.getName()));
                    }
                    types.add(FieldValueTypeInformation.forOneOf((String)field.getName(), (boolean)field.getType().getNullable(), (Map)oneOfTypes).withName(field.getName()));
                    continue;
                }
                Method method = ProtoByteBuddyUtils.getProtoGetter((Multimap<String, Method>)methods, field.getName(), field.getType());
                types.add(FieldValueTypeInformation.forGetter((Method)method).withName(field.getName()));
            }
            return types;
        }
    }
}

