/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaLogicalTypes;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaTranslator;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.NamingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.description.method.MethodList;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.description.method.ParameterDescription;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.description.type.TypeDefinition;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.implementation.Implementation;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.matcher.ElementMatcher;
import org.apache.beam.vendor.bytebuddy.v1_9_3.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;

public class ProtoByteBuddyUtils {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final TypeDescriptor<ByteString> BYTE_STRING_TYPE_DESCRIPTOR = TypeDescriptor.of(ByteString.class);
    private static final TypeDescriptor<Timestamp> PROTO_TIMESTAMP_TYPE_DESCRIPTOR = TypeDescriptor.of(Timestamp.class);
    private static final TypeDescriptor<Duration> PROTO_DURATION_TYPE_DESCRIPTOR = TypeDescriptor.of(Duration.class);
    private static final TypeDescriptor<Int32Value> PROTO_INT32_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(Int32Value.class);
    private static final TypeDescriptor<Int64Value> PROTO_INT64_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(Int64Value.class);
    private static final TypeDescriptor<UInt32Value> PROTO_UINT32_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(UInt32Value.class);
    private static final TypeDescriptor<UInt64Value> PROTO_UINT64_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(UInt64Value.class);
    private static final TypeDescriptor<FloatValue> PROTO_FLOAT_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(FloatValue.class);
    private static final TypeDescriptor<DoubleValue> PROTO_DOUBLE_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(DoubleValue.class);
    private static final TypeDescriptor<BoolValue> PROTO_BOOL_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(BoolValue.class);
    private static final TypeDescriptor<StringValue> PROTO_STRING_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(StringValue.class);
    private static final TypeDescriptor<BytesValue> PROTO_BYTES_VALUE_TYPE_DESCRIPTOR = TypeDescriptor.of(BytesValue.class);
    private static final TypeDescription.ForLoadedType BYTE_STRING_TYPE = new TypeDescription.ForLoadedType(ByteString.class);
    private static final TypeDescription.ForLoadedType BYTE_ARRAY_TYPE = new TypeDescription.ForLoadedType(byte[].class);
    private static final TypeDescription.ForLoadedType PROTO_ENUM_TYPE = new TypeDescription.ForLoadedType(ProtocolMessageEnum.class);
    private static final TypeDescription.ForLoadedType INTEGER_TYPE = new TypeDescription.ForLoadedType(Integer.class);
    private static final Map<TypeDescriptor<?>, TypeDescription.ForLoadedType> WRAPPER_LOADED_TYPES = ImmutableMap.builder().put(PROTO_INT32_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(Int32Value.class)).put(PROTO_INT64_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(Int64Value.class)).put(PROTO_UINT32_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(UInt32Value.class)).put(PROTO_UINT64_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(UInt64Value.class)).put(PROTO_FLOAT_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(FloatValue.class)).put(PROTO_DOUBLE_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(DoubleValue.class)).put(PROTO_BOOL_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(BoolValue.class)).put(PROTO_STRING_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(StringValue.class)).put(PROTO_BYTES_VALUE_TYPE_DESCRIPTOR, (Object)new TypeDescription.ForLoadedType(BytesValue.class)).build();
    private static final Map<Schema.TypeName, String> PROTO_GETTER_SUFFIX = ImmutableMap.of((Object)Schema.TypeName.ARRAY, (Object)"List", (Object)Schema.TypeName.ITERABLE, (Object)"List", (Object)Schema.TypeName.MAP, (Object)"Map");
    private static final Map<Schema.TypeName, String> PROTO_SETTER_PREFIX = ImmutableMap.of((Object)Schema.TypeName.ARRAY, (Object)"addAll", (Object)Schema.TypeName.ITERABLE, (Object)"addAll", (Object)Schema.TypeName.MAP, (Object)"putAll");
    private static final String DEFAULT_PROTO_GETTER_PREFIX = "get";
    private static final String DEFAULT_PROTO_SETTER_PREFIX = "set";
    private static final Map<ReflectUtils.ClassWithSchema, List<FieldValueGetter>> CACHED_GETTERS = Maps.newConcurrentMap();

    static String protoGetterName(String name, Schema.FieldType fieldType) {
        String camel = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name);
        return DEFAULT_PROTO_GETTER_PREFIX + camel + PROTO_GETTER_SUFFIX.getOrDefault(fieldType.getTypeName(), "");
    }

    static String protoSetterName(String name, Schema.FieldType fieldType) {
        String camel = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name);
        return ProtoByteBuddyUtils.protoSetterPrefix(fieldType) + camel;
    }

    static String protoSetterPrefix(Schema.FieldType fieldType) {
        return PROTO_SETTER_PREFIX.getOrDefault(fieldType.getTypeName(), DEFAULT_PROTO_SETTER_PREFIX);
    }

    public static List<FieldValueGetter> getGetters(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        Multimap methods = ReflectUtils.getMethodsMap(clazz);
        return CACHED_GETTERS.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, (Schema)schema), c -> {
            List types = fieldValueTypeSupplier.get(clazz, schema);
            return types.stream().map(t -> ProtoByteBuddyUtils.createGetter(t, typeConversionsFactory, clazz, (Multimap<String, Method>)methods, schema.getField(t.getName()), fieldValueTypeSupplier)).collect(Collectors.toList());
        });
    }

    private static FieldValueGetter createGetter(FieldValueTypeInformation fieldValueTypeInformation, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory, Class clazz, Multimap<String, Method> methods, Schema.Field field, FieldValueTypeSupplier fieldValueTypeSupplier) {
        if (field.getType().isLogicalType("OneOf")) {
            OneOfType oneOfType = (OneOfType)field.getType().getLogicalType(OneOfType.class);
            Method caseMethod = ProtoByteBuddyUtils.getProtoGetter(methods, field.getName() + "_case", Schema.FieldType.logicalType((Schema.LogicalType)oneOfType.getCaseEnumType()));
            HashMap oneOfGetters = Maps.newHashMap();
            Map<String, FieldValueTypeInformation> oneOfFieldTypes = fieldValueTypeSupplier.get(clazz, oneOfType.getOneOfSchema()).stream().collect(Collectors.toMap(FieldValueTypeInformation::getName, f -> f));
            for (Schema.Field oneOfField : oneOfType.getOneOfSchema().getFields()) {
                int protoFieldIndex = ProtoSchemaTranslator.getFieldNumber(oneOfField.getType());
                FieldValueGetter oneOfFieldGetter = ProtoByteBuddyUtils.createGetter(oneOfFieldTypes.get(oneOfField.getName()), typeConversionsFactory, clazz, methods, oneOfField, fieldValueTypeSupplier);
                oneOfGetters.put(protoFieldIndex, oneOfFieldGetter);
            }
            return new OneOfFieldValueGetter(field.getName(), (Supplier<Method> & Serializable)() -> caseMethod, oneOfGetters, oneOfType);
        }
        return JavaBeanUtils.createGetter((FieldValueTypeInformation)fieldValueTypeInformation, (ByteBuddyUtils.TypeConversionsFactory)typeConversionsFactory);
    }

    private static Class getProtoGeneratedBuilder(Class<?> clazz) {
        String builderClassName = clazz.getName() + "$Builder";
        try {
            return Class.forName(builderClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static Method getProtoSetter(Multimap<String, Method> methods, String name, Schema.FieldType fieldType) {
        TypeDescriptor builderDescriptor = TypeDescriptor.of(MessageLite.Builder.class);
        return methods.get((Object)ProtoByteBuddyUtils.protoSetterName(name, fieldType)).stream().filter(m -> m.getParameterCount() == 1).filter(m -> !TypeDescriptor.of((Type)m.getGenericParameterTypes()[0]).isSubtypeOf(builderDescriptor)).findAny().orElseThrow(IllegalArgumentException::new);
    }

    static Method getProtoGetter(Multimap<String, Method> methods, String name, Schema.FieldType fieldType) {
        return methods.get((Object)ProtoByteBuddyUtils.protoGetterName(name, fieldType)).stream().filter(m -> m.getParameterCount() == 0).findAny().orElseThrow(IllegalArgumentException::new);
    }

    @Nullable
    public static SchemaUserTypeCreator getBuilderCreator(Class<?> protoClass, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        Class builderClass = ProtoByteBuddyUtils.getProtoGeneratedBuilder(protoClass);
        if (builderClass == null) {
            return null;
        }
        ArrayList setters = Lists.newArrayListWithCapacity((int)schema.getFieldCount());
        Multimap methods = ReflectUtils.getMethodsMap((Class)builderClass);
        for (Schema.Field field : schema.getFields()) {
            if (field.getType().isLogicalType("OneOf")) {
                OneOfType oneOfType = (OneOfType)field.getType().getLogicalType(OneOfType.class);
                HashMap oneOfMethods = Maps.newHashMap();
                for (Schema.Field oneOfField : oneOfType.getOneOfSchema().getFields()) {
                    Method method = ProtoByteBuddyUtils.getProtoSetter((Multimap<String, Method>)methods, oneOfField.getName(), oneOfField.getType());
                    oneOfMethods.put(ProtoSchemaTranslator.getFieldNumber(oneOfField.getType()), method);
                }
                setters.add(new ProtoOneOfSetter(oneOfMethods::get, field.getName()));
                continue;
            }
            Method method = ProtoByteBuddyUtils.getProtoSetter((Multimap<String, Method>)methods, field.getName(), field.getType());
            setters.add(JavaBeanUtils.createSetter((FieldValueTypeInformation)FieldValueTypeInformation.forSetter((Method)method, (String)ProtoByteBuddyUtils.protoSetterPrefix(field.getType())), (ByteBuddyUtils.TypeConversionsFactory)new ProtoTypeConversionsFactory()));
        }
        return ProtoByteBuddyUtils.createBuilderCreator(protoClass, builderClass, setters, schema);
    }

    static SchemaUserTypeCreator createBuilderCreator(Class<?> protoClass, Class<?> builderClass, List<FieldValueSetter> setters, Schema schema) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(builderClass)).subclass(Supplier.class).method((ElementMatcher)ElementMatchers.named((String)DEFAULT_PROTO_GETTER_PREFIX)).intercept((Implementation)new BuilderSupplier(protoClass));
            Supplier supplier = (Supplier)builder.make().load(ReflectHelpers.findClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new ProtoCreatorFactory(supplier, setters);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for class " + builderClass + " with schema " + schema);
        }
    }

    static /* synthetic */ TypeDescriptor access$100() {
        return PROTO_STRING_VALUE_TYPE_DESCRIPTOR;
    }

    static /* synthetic */ TypeDescriptor access$200() {
        return PROTO_BOOL_VALUE_TYPE_DESCRIPTOR;
    }

    static /* synthetic */ TypeDescriptor access$300() {
        return PROTO_DOUBLE_VALUE_TYPE_DESCRIPTOR;
    }

    static /* synthetic */ TypeDescriptor access$400() {
        return PROTO_FLOAT_VALUE_TYPE_DESCRIPTOR;
    }

    static /* synthetic */ TypeDescriptor access$500() {
        return PROTO_UINT64_VALUE_TYPE_DESCRIPTOR;
    }

    static /* synthetic */ TypeDescriptor access$600() {
        return PROTO_UINT32_VALUE_TYPE_DESCRIPTOR;
    }

    static /* synthetic */ TypeDescriptor access$700() {
        return PROTO_INT64_VALUE_TYPE_DESCRIPTOR;
    }

    static /* synthetic */ TypeDescriptor access$800() {
        return PROTO_INT32_VALUE_TYPE_DESCRIPTOR;
    }

    static class BuilderSupplier
    implements Implementation {
        private final Class<?> protoClass;

        public BuilderSupplier(Class<?> protoClass) {
            this.protoClass = protoClass;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription.ForLoadedType loadedProto = new TypeDescription.ForLoadedType(this.protoClass);
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)loadedProto.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"newBuilder").and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly())), MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    static class ProtoCreatorFactory
    implements SchemaUserTypeCreator {
        private final Supplier<? extends MessageLite.Builder> builderCreator;
        private final List<FieldValueSetter> setters;

        public ProtoCreatorFactory(Supplier<? extends MessageLite.Builder> builderCreator, List<FieldValueSetter> setters) {
            this.builderCreator = builderCreator;
            this.setters = setters;
        }

        public Object create(Object ... params) {
            MessageLite.Builder builder = this.builderCreator.get();
            for (int i = 0; i < params.length; ++i) {
                this.setters.get(i).set((Object)builder, params[i]);
            }
            return builder.build();
        }
    }

    static class ProtoOneOfSetter<BuilderT extends MessageLite.Builder>
    implements FieldValueSetter<BuilderT, OneOfType.Value> {
        private final Function<Integer, Method> methods;
        private final String name;

        ProtoOneOfSetter(Function<Integer, Method> methods, String name) {
            this.methods = methods;
            this.name = name;
        }

        public void set(BuilderT builder, OneOfType.Value oneOfValue) {
            Method method = this.methods.apply(oneOfValue.getCaseType().getValue());
            try {
                method.invoke(builder, oneOfValue.getValue());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public String name() {
            return this.name;
        }
    }

    static class OneOfFieldValueGetter<ProtoT extends MessageLite>
    implements FieldValueGetter<ProtoT, OneOfType.Value> {
        private final String name;
        private final Supplier<Method> getCaseMethod;
        private final Map<Integer, FieldValueGetter<ProtoT, ?>> getterMethodMap;
        private final OneOfType oneOfType;

        public OneOfFieldValueGetter(String name, Supplier<Method> getCaseMethod, Map<Integer, FieldValueGetter<ProtoT, ?>> getterMethodMap, OneOfType oneOfType) {
            this.name = name;
            this.getCaseMethod = getCaseMethod;
            this.getterMethodMap = getterMethodMap;
            this.oneOfType = oneOfType;
        }

        @Nullable
        public OneOfType.Value get(ProtoT object) {
            try {
                Internal.EnumLite caseValue = (Internal.EnumLite)this.getCaseMethod.get().invoke(object, new Object[0]);
                if (caseValue.getNumber() == 0) {
                    return null;
                }
                Object value = this.getterMethodMap.get(caseValue.getNumber()).get(object);
                return this.oneOfType.createValue(this.oneOfType.getCaseEnumType().valueOf(caseValue.getNumber()), value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public String name() {
            return this.name;
        }
    }

    static class ProtoTypeConversionsFactory
    implements ByteBuddyUtils.TypeConversionsFactory {
        ProtoTypeConversionsFactory() {
        }

        public ByteBuddyUtils.TypeConversion<Type> createTypeConversion(boolean returnRawTypes) {
            return new ProtoConvertType(returnRawTypes);
        }

        public ByteBuddyUtils.TypeConversion<StackManipulation> createGetterConversions(StackManipulation readValue) {
            return new ProtoConvertValueForGetter(readValue);
        }

        public ByteBuddyUtils.TypeConversion<StackManipulation> createSetterConversions(StackManipulation readValue) {
            return new ProtoConvertValueForSetter(readValue);
        }
    }

    static class ProtoConvertValueForSetter
    extends ByteBuddyUtils.ConvertValueForSetter {
        ProtoConvertValueForSetter(StackManipulation readValue) {
            super(readValue);
        }

        protected ProtoTypeConversionsFactory getFactory() {
            return new ProtoTypeConversionsFactory();
        }

        public StackManipulation convert(TypeDescriptor type) {
            if (type.isSubtypeOf(TypeDescriptor.of(ByteString.class))) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, TypeCasting.to((TypeDefinition)BYTE_ARRAY_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)BYTE_STRING_TYPE.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"copyFrom").and((ElementMatcher)ElementMatchers.takesArguments((TypeDescription[])new TypeDescription[]{BYTE_ARRAY_TYPE})))).getOnly()))});
            }
            if (type.isSubtypeOf(TypeDescriptor.of(ProtocolMessageEnum.class))) {
                TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, Assigner.DEFAULT.assign(INTEGER_TYPE.asBoxed().asGenericType(), INTEGER_TYPE.asUnboxed().asGenericType(), Assigner.Typing.STATIC), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"forNumber").and((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.takesArguments((int)1))))).getOnly()))});
            }
            if (type.equals((Object)PROTO_TIMESTAMP_TYPE_DESCRIPTOR)) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ProtoSchemaLogicalTypes.TimestampNanos.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"toTimestamp"))).getOnly()))});
            }
            if (type.equals((Object)PROTO_DURATION_TYPE_DESCRIPTOR)) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ProtoSchemaLogicalTypes.DurationNanos.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"toDuration"))).getOnly()))});
            }
            TypeDescription.ForLoadedType wrapperType = (TypeDescription.ForLoadedType)WRAPPER_LOADED_TYPES.get(type);
            if (wrapperType != null) {
                if (type.equals((Object)PROTO_BYTES_VALUE_TYPE_DESCRIPTOR)) {
                    this.readValue = (StackManipulation)this.getFactory().createSetterConversions(this.readValue).convert(TypeDescriptor.of(ByteString.class));
                }
                MethodDescription.InDefinedShape ofMethod = (MethodDescription.InDefinedShape)((MethodList)wrapperType.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"of"))).getOnly();
                TypeDescription.Generic argumentType = ((ParameterDescription.InDefinedShape)ofMethod.getParameters().get(0)).getType();
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, Assigner.DEFAULT.assign(argumentType.asErasure().asBoxed().asGenericType(), argumentType, Assigner.Typing.STATIC), MethodInvocation.invoke((MethodDescription.InDefinedShape)ofMethod)});
            }
            return (StackManipulation)super.convert(type);
        }
    }

    static class ProtoConvertValueForGetter
    extends ByteBuddyUtils.ConvertValueForGetter {
        ProtoConvertValueForGetter(StackManipulation readValue) {
            super(readValue);
        }

        protected ProtoTypeConversionsFactory getFactory() {
            return new ProtoTypeConversionsFactory();
        }

        public StackManipulation convert(TypeDescriptor type) {
            if (type.equals((Object)BYTE_STRING_TYPE_DESCRIPTOR) || type.isSubtypeOf(BYTE_STRING_TYPE_DESCRIPTOR)) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)BYTE_STRING_TYPE.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"toByteArray"))).getOnly()))});
            }
            if (type.isSubtypeOf(TypeDescriptor.of(ProtocolMessageEnum.class))) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)PROTO_ENUM_TYPE.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"getNumber").and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly())), Assigner.DEFAULT.assign(INTEGER_TYPE.asUnboxed().asGenericType(), INTEGER_TYPE.asGenericType(), Assigner.Typing.STATIC)});
            }
            if (type.equals((Object)PROTO_TIMESTAMP_TYPE_DESCRIPTOR)) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ProtoSchemaLogicalTypes.TimestampNanos.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"toRow"))).getOnly()))});
            }
            if (type.equals((Object)PROTO_DURATION_TYPE_DESCRIPTOR)) {
                return new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ProtoSchemaLogicalTypes.DurationNanos.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"toRow"))).getOnly()))});
            }
            TypeDescription.ForLoadedType wrapperType = (TypeDescription.ForLoadedType)WRAPPER_LOADED_TYPES.get(type);
            if (wrapperType != null) {
                MethodDescription.InDefinedShape getValueMethod = (MethodDescription.InDefinedShape)((MethodList)wrapperType.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"getValue"))).getOnly();
                TypeDescription.Generic returnType = getValueMethod.getReturnType();
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)getValueMethod), Assigner.DEFAULT.assign(returnType, returnType.asErasure().asBoxed().asGenericType(), Assigner.Typing.STATIC)});
                if (type.equals((Object)PROTO_BYTES_VALUE_TYPE_DESCRIPTOR)) {
                    stackManipulation = (StackManipulation)this.getFactory().createGetterConversions((StackManipulation)stackManipulation).convert(BYTE_STRING_TYPE_DESCRIPTOR);
                }
                return stackManipulation;
            }
            return (StackManipulation)super.convert(type);
        }
    }

    static class ProtoConvertType
    extends ByteBuddyUtils.ConvertType {
        private static final Map<TypeDescriptor<?>, Class<?>> TYPE_OVERRIDES = ImmutableMap.builder().put((Object)ProtoByteBuddyUtils.access$1000(), Row.class).put((Object)ProtoByteBuddyUtils.access$900(), Row.class).put((Object)ProtoByteBuddyUtils.access$800(), Integer.class).put((Object)ProtoByteBuddyUtils.access$700(), Long.class).put((Object)ProtoByteBuddyUtils.access$600(), Integer.class).put((Object)ProtoByteBuddyUtils.access$500(), Long.class).put((Object)ProtoByteBuddyUtils.access$400(), Float.class).put((Object)ProtoByteBuddyUtils.access$300(), Double.class).put((Object)ProtoByteBuddyUtils.access$200(), Boolean.class).put((Object)ProtoByteBuddyUtils.access$100(), String.class).put((Object)ProtoByteBuddyUtils.access$000(), byte[].class).build();

        ProtoConvertType(boolean returnRawValues) {
            super(returnRawValues);
        }

        public Type convert(TypeDescriptor typeDescriptor) {
            if (typeDescriptor.equals((Object)BYTE_STRING_TYPE_DESCRIPTOR) || typeDescriptor.isSubtypeOf(BYTE_STRING_TYPE_DESCRIPTOR)) {
                return byte[].class;
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(ProtocolMessageEnum.class))) {
                return Integer.class;
            }
            if (typeDescriptor.equals((Object)PROTO_TIMESTAMP_TYPE_DESCRIPTOR) || typeDescriptor.equals((Object)PROTO_DURATION_TYPE_DESCRIPTOR)) {
                return Row.class;
            }
            Type type = TYPE_OVERRIDES.get(typeDescriptor);
            return type != null ? type : (Type)super.convert(typeDescriptor);
        }
    }
}

