/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.expansion.service.ExpansionServiceConfig;
import org.apache.beam.sdk.expansion.service.ExpansionServiceOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.resources.PipelineResources;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface TransformProvider<@UnknownKeyFor InputT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput> {
    public @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> getTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec var1, @UnknownKeyFor @NonNull @Initialized PipelineOptions var2);

    default public InputT createInput(@UnknownKeyFor @NonNull @Initialized Pipeline p, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs) {
        if ((inputs = (Map)Preconditions.checkArgumentNotNull(inputs)).size() == 0) {
            return (InputT)p.begin();
        }
        if (inputs.size() == 1) {
            return (InputT)((PInput)Iterables.getOnlyElement(inputs.values()));
        }
        PCollectionTuple inputTuple = PCollectionTuple.empty((Pipeline)p);
        for (Map.Entry entry : inputs.entrySet()) {
            inputTuple = inputTuple.and(new TupleTag((String)entry.getKey()), (PCollection)entry.getValue());
        }
        return (InputT)inputTuple;
    }

    default public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> extractOutputs(OutputT output) {
        if (output instanceof PDone) {
            return Collections.emptyMap();
        }
        if (output instanceof PCollection) {
            return ImmutableMap.of((Object)"output", (Object)((PCollection)output));
        }
        if (output instanceof PCollectionTuple) {
            return ((PCollectionTuple)output).getAll().entrySet().stream().collect(Collectors.toMap(entry -> ((TupleTag)entry.getKey()).getId(), Map.Entry::getValue));
        }
        if (output instanceof PCollectionList) {
            PCollectionList listOutput = (PCollectionList)output;
            ImmutableMap.Builder indexToPCollection = ImmutableMap.builder();
            int i = 0;
            for (PCollection pc : listOutput.getAll()) {
                indexToPCollection.put((Object)Integer.toString(i), (Object)pc);
                ++i;
            }
            return indexToPCollection.build();
        }
        if (output instanceof POutput) {
            Map values = output.expand();
            HashMap returnMap = new HashMap();
            for (Map.Entry entry2 : values.entrySet()) {
                if (!(entry2.getValue() instanceof PCollection)) {
                    throw new UnsupportedOperationException("Unable to parse the output type " + output.getClass() + " due to key " + entry2.getKey() + " not mapping to a PCollection");
                }
                returnMap.put(((TupleTag)entry2.getKey()).getId(), (PCollection)entry2.getValue());
            }
            return returnMap;
        }
        throw new UnsupportedOperationException("Unknown output type: " + output.getClass());
    }

    default public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> apply(@UnknownKeyFor @NonNull @Initialized Pipeline p, @UnknownKeyFor @NonNull @Initialized String name, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec spec, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs) {
        return this.extractOutputs(Pipeline.applyTransform((String)name, this.createInput(p, inputs), this.getTransform(spec, p.getOptions())));
    }

    default public @UnknownKeyFor @NonNull @Initialized String getTransformUniqueID(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec spec) {
        if (BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM).equals(spec.getUrn())) {
            try {
                ExternalTransforms.SchemaTransformPayload payload = ExternalTransforms.SchemaTransformPayload.parseFrom((ByteString)spec.getPayload());
                return payload.getIdentifier();
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Invalid payload type for URN " + BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM), e);
            }
        }
        return spec.getUrn();
    }

    default public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDependencies(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec spec, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        ExpansionServiceConfig config = ((ExpansionServiceOptions)options.as(ExpansionServiceOptions.class)).getExpansionServiceConfig();
        String transformUniqueID = this.getTransformUniqueID(spec);
        if (config.getDependencies().containsKey(transformUniqueID)) {
            List<String> updatedDependencies = config.getDependencies().get(transformUniqueID).stream().map(dependency -> dependency.getPath()).collect(Collectors.toList());
            return updatedDependencies;
        }
        List filesToStage = ((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).getFilesToStage();
        if (filesToStage == null || filesToStage.isEmpty()) {
            ClassLoader classLoader = Environments.class.getClassLoader();
            if (classLoader == null) {
                throw new RuntimeException("Cannot detect classpath: classloader is null (is it the bootstrap classloader?)");
            }
            filesToStage = PipelineResources.detectClassPathResourcesToStage((ClassLoader)classLoader, (PipelineOptions)options);
            if (filesToStage.isEmpty()) {
                throw new IllegalArgumentException("No classpath elements found.");
            }
        }
        return filesToStage;
    }
}

