/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.data;

import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnDataGrpc;
import org.apache.beam.runners.fnexecution.FnService;
import org.apache.beam.runners.fnexecution.data.FnDataService;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.BeamFnDataBufferingOutboundObserver;
import org.apache.beam.sdk.fn.data.BeamFnDataGrpcMultiplexer;
import org.apache.beam.sdk.fn.data.BeamFnDataInboundObserver;
import org.apache.beam.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.sdk.fn.data.DecodingFnDataReceiver;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.data.InboundDataClient;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcDataService
extends BeamFnDataGrpc.BeamFnDataImplBase
implements FnService,
FnDataService {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcDataService.class);
    private final SettableFuture<BeamFnDataGrpcMultiplexer> connectedClient;
    private final Queue<BeamFnDataGrpcMultiplexer> additionalMultiplexers;
    private final PipelineOptions options;
    private final ExecutorService executor;
    private final OutboundObserverFactory outboundObserverFactory;

    public static GrpcDataService create(PipelineOptions options, ExecutorService executor, OutboundObserverFactory outboundObserverFactory) {
        return new GrpcDataService(options, executor, outboundObserverFactory);
    }

    private GrpcDataService(PipelineOptions options, ExecutorService executor, OutboundObserverFactory outboundObserverFactory) {
        this.connectedClient = SettableFuture.create();
        this.additionalMultiplexers = new LinkedBlockingQueue<BeamFnDataGrpcMultiplexer>();
        this.options = options;
        this.executor = executor;
        this.outboundObserverFactory = outboundObserverFactory;
    }

    @Deprecated
    public GrpcDataService() {
        this.connectedClient = null;
        this.additionalMultiplexers = null;
        this.options = null;
        this.executor = null;
        this.outboundObserverFactory = null;
    }

    public StreamObserver<BeamFnApi.Elements> data(StreamObserver<BeamFnApi.Elements> outboundElementObserver) {
        LOG.info("Beam Fn Data client connected.");
        BeamFnDataGrpcMultiplexer multiplexer = new BeamFnDataGrpcMultiplexer(null, this.outboundObserverFactory, inbound -> outboundElementObserver);
        if (!this.connectedClient.set((Object)multiplexer)) {
            this.additionalMultiplexers.offer(multiplexer);
        }
        try {
            return ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).getInboundObserver();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.connectedClient.cancel(true);
        for (BeamFnDataGrpcMultiplexer additional : this.additionalMultiplexers) {
            try {
                additional.close();
            }
            catch (Exception exception) {}
        }
        if (!this.connectedClient.isCancelled()) {
            ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).close();
        }
    }

    @Override
    public <T> InboundDataClient receive(LogicalEndpoint inputLocation, Coder<T> coder, FnDataReceiver<T> listener) {
        LOG.debug("Registering receiver for instruction {} and transform {}", (Object)inputLocation.getInstructionId(), (Object)inputLocation.getTransformId());
        BeamFnDataInboundObserver observer = BeamFnDataInboundObserver.forConsumer((LogicalEndpoint)inputLocation, (FnDataReceiver)new DecodingFnDataReceiver(coder, listener));
        if (this.connectedClient.isDone()) {
            try {
                ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).registerConsumer(inputLocation, (BiConsumer)observer);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.executor.submit(() -> {
                try {
                    ((BeamFnDataGrpcMultiplexer)this.connectedClient.get()).registerConsumer(inputLocation, (BiConsumer)observer);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            });
        }
        return observer;
    }

    @Override
    public <T> CloseableFnDataReceiver<T> send(LogicalEndpoint outputLocation, Coder<T> coder) {
        LOG.debug("Creating sender for instruction {} and transform {}", (Object)outputLocation.getInstructionId(), (Object)outputLocation.getTransformId());
        try {
            return BeamFnDataBufferingOutboundObserver.forLocation((PipelineOptions)this.options, (LogicalEndpoint)outputLocation, coder, (StreamObserver)((BeamFnDataGrpcMultiplexer)this.connectedClient.get(3L, TimeUnit.MINUTES)).getOutboundObserver());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("No client connected within timeout", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

