/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.CloudObjects;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.TimestampPrefixingWindowCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class CloudObjectTranslators {
    private static final @UnknownKeyFor @NonNull @Initialized String CODER_FIELD = "serialized_coder";
    private static final @UnknownKeyFor @NonNull @Initialized String TYPE_FIELD = "type";

    private CloudObjectTranslators() {
    }

    private static @UnknownKeyFor @NonNull @Initialized CloudObject addComponents(@UnknownKeyFor @NonNull @Initialized CloudObject base, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> components, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
        if (!components.isEmpty()) {
            ArrayList<CloudObject> cloudComponents = new ArrayList<CloudObject>(components.size());
            for (Coder<?> component : components) {
                cloudComponents.add(CloudObjects.asCloudObject(component, sdkComponents));
            }
            Structs.addList((Map<String, Object>)((Object)base), "component_encodings", cloudComponents);
        }
        return base;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents(@UnknownKeyFor @NonNull @Initialized CloudObject target) {
        List<Map<String, Object>> cloudComponents = Structs.getListOfMaps((Map<String, Object>)((Object)target), "component_encodings", Collections.emptyList());
        ArrayList components = new ArrayList();
        for (Map<String, Object> cloudComponent : cloudComponents) {
            components.add(CloudObjects.coderFromCloudObject(CloudObject.fromSpec(cloudComponent)));
        }
        return components;
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized KvCoder> pair() {
        return new CloudObjectTranslator<KvCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized KvCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject result = CloudObject.forClassName("kind:pair");
                Structs.addBoolean((Map<String, Object>)((Object)result), "is_pair_like", true);
                return CloudObjectTranslators.addComponents(result, (List)ImmutableList.of((Object)target.getKeyCoder(), (Object)target.getValueCoder()), sdkComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KvCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument((components.size() == 2 ? 1 : 0) != 0, (String)"Expecting 2 components, got %s", (int)components.size());
                return KvCoder.of((Coder)((Coder)components.get(0)), (Coder)((Coder)components.get(1)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized KvCoder> getSupportedClass() {
                return KvCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:pair";
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized IterableCoder> stream() {
        return new CloudObjectTranslator<IterableCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized IterableCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject result = CloudObject.forClassName("kind:stream");
                Structs.addBoolean((Map<String, Object>)((Object)result), "is_stream_like", true);
                return CloudObjectTranslators.addComponents(result, Collections.singletonList(target.getElemCoder()), sdkComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized IterableCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument((components.size() == 1 ? 1 : 0) != 0, (String)"Expecting 1 component, got %s", (int)components.size());
                return IterableCoder.of((Coder)((Coder)components.get(0)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized IterableCoder> getSupportedClass() {
                return IterableCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:stream";
            }
        };
    }

    static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized LengthPrefixCoder> lengthPrefix() {
        return new CloudObjectTranslator<LengthPrefixCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized LengthPrefixCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:length_prefix"), Collections.singletonList(target.getValueCoder()), sdkComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized LengthPrefixCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument((components.size() == 1 ? 1 : 0) != 0, (String)"Expecting 1 component, got %s", (int)components.size());
                return LengthPrefixCoder.of((Coder)((Coder)components.get(0)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized LengthPrefixCoder> getSupportedClass() {
                return LengthPrefixCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:length_prefix";
            }
        };
    }

    static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized GlobalWindow.Coder> globalWindow() {
        return new CloudObjectTranslator<GlobalWindow.Coder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized GlobalWindow.Coder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:global_window"), Collections.emptyList(), sdkComponents);
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized GlobalWindow.Coder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                return GlobalWindow.Coder.INSTANCE;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized GlobalWindow.Coder> getSupportedClass() {
                return GlobalWindow.Coder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:global_window";
            }
        };
    }

    static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized IntervalWindow.IntervalWindowCoder> intervalWindow() {
        return new CloudObjectTranslator<IntervalWindow.IntervalWindowCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized IntervalWindow.IntervalWindowCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:interval_window"), Collections.emptyList(), sdkComponents);
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized IntervalWindow.IntervalWindowCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                return IntervalWindow.IntervalWindowCoder.of();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized IntervalWindow.IntervalWindowCoder> getSupportedClass() {
                return IntervalWindow.IntervalWindowCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:interval_window";
            }
        };
    }

    static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized TimestampPrefixingWindowCoder> customWindow() {
        return new CloudObjectTranslator<TimestampPrefixingWindowCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized TimestampPrefixingWindowCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject result = CloudObject.forClassName("kind:custom_window");
                return CloudObjectTranslators.addComponents(result, target.getComponents(), sdkComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TimestampPrefixingWindowCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                List components = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument((components.size() == 1 ? 1 : 0) != 0, (String)"Expecting 1 component, got %s", (int)components.size());
                return TimestampPrefixingWindowCoder.of((Coder)((Coder)components.get(0)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TimestampPrefixingWindowCoder> getSupportedClass() {
                return TimestampPrefixingWindowCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:custom_window";
            }
        };
    }

    static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WindowedValues.FullWindowedValueCoder> windowedValue() {
        return new CloudObjectTranslator<WindowedValues.FullWindowedValueCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized WindowedValues.FullWindowedValueCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject result = CloudObject.forClassName("kind:windowed_value");
                Structs.addBoolean((Map<String, Object>)((Object)result), "is_wrapper", true);
                return CloudObjectTranslators.addComponents(result, (List)ImmutableList.of((Object)target.getValueCoder(), (Object)target.getWindowCoder()), sdkComponents);
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized WindowedValues.FullWindowedValueCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                List components = CloudObjectTranslators.getComponents(object);
                Preconditions.checkArgument((components.size() == 2 ? 1 : 0) != 0, (Object)("Expecting 2 components, got " + components.size()));
                Coder window = (Coder)components.get(1);
                return WindowedValues.FullWindowedValueCoder.of((Coder)((Coder)components.get(0)), (Coder)window);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized WindowedValues.FullWindowedValueCoder> getSupportedClass() {
                return WindowedValues.FullWindowedValueCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:windowed_value";
            }
        };
    }

    static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized ByteArrayCoder> bytes() {
        return new CloudObjectTranslator<ByteArrayCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized ByteArrayCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClassName("kind:bytes"), Collections.emptyList(), sdkComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ByteArrayCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                return ByteArrayCoder.of();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ByteArrayCoder> getSupportedClass() {
                return ByteArrayCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return "kind:bytes";
            }
        };
    }

    static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized VarLongCoder> varInt() {
        return new CloudObjectTranslator<VarLongCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized VarLongCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClass(target.getClass()), Collections.emptyList(), sdkComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized VarLongCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject object) {
                return VarLongCoder.of();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized VarLongCoder> getSupportedClass() {
                return VarLongCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(VarLongCoder.class).getClassName();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized Coder> javaSerialized() {
        return new CloudObjectTranslator<Coder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized Coder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject cloudObject = CloudObject.forClass(CustomCoder.class);
                Structs.addString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.TYPE_FIELD, target.getClass().getName());
                Structs.addString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.CODER_FIELD, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target)));
                return cloudObject;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                String serializedCoder = Structs.getString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.CODER_FIELD);
                String type = Structs.getString((Map<String, Object>)((Object)cloudObject), CloudObjectTranslators.TYPE_FIELD);
                return (Coder)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)serializedCoder), (String)type);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CustomCoder> getSupportedClass() {
                return CustomCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(CustomCoder.class).getClassName();
            }
        };
    }

    public static <T extends Coder> @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<T> atomic(final @UnknownKeyFor @NonNull @Initialized Class<T> coderClass) {
        InstanceBuilder.ofType(coderClass).fromFactoryMethod("of").build();
        return new CloudObjectTranslator<T>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(T target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                return CloudObject.forClass(coderClass);
            }

            @Override
            public T fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                return (Coder)InstanceBuilder.ofType((Class)coderClass).fromFactoryMethod("of").build();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends T> getSupportedClass() {
                return coderClass;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(coderClass).getClassName();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized IterableLikeCoder> iterableLike(final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized IterableLikeCoder> clazz) {
        return new CloudObjectTranslator<IterableLikeCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized IterableLikeCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(clazz);
                return CloudObjectTranslators.addComponents(base, Collections.singletonList(target.getElemCoder()), sdkComponents);
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized IterableLikeCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                List elemCoderList = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument((elemCoderList.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 component for %s, got %s", (Object)cloudObject.getClassName(), (int)elemCoderList.size());
                return (IterableLikeCoder)InstanceBuilder.ofType((Class)clazz).fromFactoryMethod("of").withArg(Coder.class, (Object)((Coder)elemCoderList.get(0))).build();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized IterableLikeCoder> getSupportedClass() {
                return clazz;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(clazz).getClassName();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized MapCoder> map() {
        return new CloudObjectTranslator<MapCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized MapCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(MapCoder.class);
                return CloudObjectTranslators.addComponents(base, (List)ImmutableList.of((Object)target.getKeyCoder(), (Object)target.getValueCoder()), sdkComponents);
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized MapCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                List components = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument((components.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 components for %s, got %s", (Object)MapCoder.class.getSimpleName(), (int)components.size());
                return MapCoder.of((Coder)((Coder)components.get(0)), (Coder)((Coder)components.get(1)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MapCoder> getSupportedClass() {
                return MapCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(MapCoder.class).getClassName();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimestampedValue.TimestampedValueCoder> timestampedValue() {
        return new CloudObjectTranslator<TimestampedValue.TimestampedValueCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TimestampedValue.TimestampedValueCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(TimestampedValue.TimestampedValueCoder.class);
                return CloudObjectTranslators.addComponents(base, (List)ImmutableList.of((Object)target.getValueCoder()), sdkComponents);
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TimestampedValue.TimestampedValueCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                List components = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument((components.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 components for %s, got %s", (Object)TimestampedValue.TimestampedValueCoder.class.getSimpleName(), (int)components.size());
                return TimestampedValue.TimestampedValueCoder.of((Coder)((Coder)components.get(0)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TimestampedValue.TimestampedValueCoder> getSupportedClass() {
                return TimestampedValue.TimestampedValueCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(TimestampedValue.TimestampedValueCoder.class).getClassName();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized NullableCoder> nullable() {
        return new CloudObjectTranslator<NullableCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized NullableCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(NullableCoder.class);
                return CloudObjectTranslators.addComponents(base, Collections.singletonList(target.getValueCoder()), sdkComponents);
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                List componentList = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument((componentList.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 component for %s, got %s", (Object)NullableCoder.class.getSimpleName(), (int)componentList.size());
                return NullableCoder.of((Coder)((Coder)componentList.get(0)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized NullableCoder> getSupportedClass() {
                return NullableCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(NullableCoder.class).getClassName();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<@UnknownKeyFor @NonNull @Initialized UnionCoder> union() {
        return new CloudObjectTranslator<UnionCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized UnionCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                return CloudObjectTranslators.addComponents(CloudObject.forClass(UnionCoder.class), target.getElementCoders(), sdkComponents);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized UnionCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                List elementCoders = CloudObjectTranslators.getComponents(cloudObject);
                return UnionCoder.of((List)elementCoders);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UnionCoder> getSupportedClass() {
                return UnionCoder.class;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(UnionCoder.class).getClassName();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized CloudObjectTranslator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CoGbkResult.CoGbkResultCoder> coGroupByKeyResult() {
        return new CloudObjectTranslator<CoGbkResult.CoGbkResultCoder>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized CoGbkResult.CoGbkResultCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
                CloudObject base = CloudObject.forClass(CoGbkResult.CoGbkResultCoder.class);
                Structs.addObject((Map<String, Object>)((Object)base), "co_gbk_result_schema", (Map<String, Object>)((Object)this.toCloudObject(target.getSchema())));
                return CloudObjectTranslators.addComponents(base, Collections.singletonList(target.getUnionCoder()), sdkComponents);
            }

            private @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema) {
                CloudObject result = CloudObject.forClass(CoGbkResultSchema.class);
                ArrayList<CloudObject> tags = new ArrayList<CloudObject>(schema.getTupleTagList().size());
                for (TupleTag tag : schema.getTupleTagList().getAll()) {
                    CloudObject tagCloudObject = CloudObject.forClass(TupleTag.class);
                    Structs.addString((Map<String, Object>)((Object)tagCloudObject), "value", tag.getId());
                    tags.add(tagCloudObject);
                }
                Structs.addList((Map<String, Object>)((Object)result), "tuple_tags", tags);
                return result;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized CoGbkResult.CoGbkResultCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                List components = CloudObjectTranslators.getComponents(cloudObject);
                Preconditions.checkArgument((components.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 component for %s, got %s", (Object)CoGbkResult.CoGbkResultCoder.class.getSimpleName(), (int)components.size());
                Preconditions.checkArgument((boolean)(components.get(0) instanceof UnionCoder), (String)"Expected only component to be a %s, got %s", (Object)UnionCoder.class.getSimpleName(), (Object)((Coder)components.get(0)).getClass().getName());
                return CoGbkResult.CoGbkResultCoder.of((CoGbkResultSchema)this.schemaFromCloudObject(CloudObject.fromSpec(Structs.getObject((Map<String, Object>)((Object)cloudObject), "co_gbk_result_schema"))), (UnionCoder)((UnionCoder)components.get(0)));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized CoGbkResult.CoGbkResultCoder> getSupportedClass() {
                return CoGbkResult.CoGbkResultCoder.class;
            }

            private @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schemaFromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
                ArrayList<TupleTag> tags = new ArrayList<TupleTag>();
                List<Map<String, Object>> serializedTags = Structs.getListOfMaps((Map<String, Object>)((Object)cloudObject), "tuple_tags", Collections.emptyList());
                for (Map<String, Object> serializedTag : serializedTags) {
                    TupleTag tag = new TupleTag(Structs.getString(serializedTag, "value"));
                    tags.add(tag);
                }
                return CoGbkResultSchema.of(tags);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
                return CloudObject.forClass(CoGbkResult.CoGbkResultCoder.class).getClassName();
            }
        };
    }
}

