/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.Map;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.UnmodifiableIterator;

public class GroupIntoBatchesOverride {

    static class StreamingGroupIntoBatches<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final transient DataflowRunner runner;
        private final GroupIntoBatches<K, V> original;

        public StreamingGroupIntoBatches(DataflowRunner runner, GroupIntoBatches<K, V> original) {
            this.runner = runner;
            this.original = original;
        }

        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            this.runner.maybeRecordPCollectionWithAutoSharding(input);
            return (PCollection)input.apply(this.original);
        }
    }

    static class StreamingGroupIntoBatchesOverrideFactory<K, V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> {
        private final DataflowRunner runner;

        StreamingGroupIntoBatchesOverrideFactory(DataflowRunner runner) {
            this.runner = runner;
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StreamingGroupIntoBatches(this.runner, (GroupIntoBatches)transform.getTransform()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<KV<K, Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    static class BatchGroupIntoBatches<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final long batchSize;

        private BatchGroupIntoBatches(long batchSize) {
            this.batchSize = batchSize;
        }

        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            return (PCollection)((PCollection)input.apply("GroupAll", (PTransform)GroupByKey.create())).apply("SplitIntoBatches", (PTransform)ParDo.of((DoFn)new DoFn<KV<K, Iterable<V>>, KV<K, Iterable<V>>>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    UnmodifiableIterator iterator = Iterators.partition(((Iterable)((KV)c.element()).getValue()).iterator(), (int)((int)batchSize));
                    while (iterator.hasNext()) {
                        c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)((Iterable)iterator.next())));
                    }
                }
            }));
        }
    }

    static class BatchGroupIntoBatchesOverrideFactory<K, V>
    implements PTransformOverrideFactory<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> {
        BatchGroupIntoBatchesOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>, GroupIntoBatches<K, V>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new BatchGroupIntoBatches(((GroupIntoBatches)transform.getTransform()).getBatchSize()));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<KV<K, Iterable<V>>> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

