/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.CombineContextFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class CombineFnUtil {
    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> bindContext(@UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> stateContext) {
        CombineWithContext.Context context = CombineContextFactory.createFromStateContext(stateContext);
        return new NonSerializableBoundedCombineFn(combineFn, context);
    }

    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> toFnWithContext(@UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> globalCombineFn) {
        if (globalCombineFn instanceof CombineWithContext.CombineFnWithContext) {
            CombineWithContext.CombineFnWithContext combineFnWithContext = (CombineWithContext.CombineFnWithContext)globalCombineFn;
            return combineFnWithContext;
        }
        final Combine.CombineFn combineFn = (Combine.CombineFn)globalCombineFn;
        return new CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT>(){

            @Override
            public AccumT createAccumulator(@UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                return combineFn.createAccumulator();
            }

            @Override
            public AccumT addInput(AccumT accumulator, InputT input, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                return combineFn.addInput(accumulator, input);
            }

            @Override
            public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                return combineFn.mergeAccumulators(accumulators);
            }

            @Override
            public OutputT extractOutput(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                return combineFn.extractOutput(accumulator);
            }

            @Override
            public AccumT compact(AccumT accumulator, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context c) {
                return combineFn.compact(accumulator);
            }

            @Override
            public OutputT defaultValue() {
                return combineFn.defaultValue();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                return combineFn.getAccumulatorCoder(registry, inputCoder);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                return combineFn.getDefaultOutputCoder(registry, inputCoder);
            }

            @Override
            public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                combineFn.populateDisplayData(builder);
            }
        };
    }

    private static class NonSerializableBoundedCombineFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends Combine.CombineFn<InputT, AccumT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context context;

        private NonSerializableBoundedCombineFn(@UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context context) {
            this.combineFn = combineFn;
            this.context = context;
        }

        @Override
        public AccumT createAccumulator() {
            return this.combineFn.createAccumulator(this.context);
        }

        @Override
        public AccumT addInput(AccumT accumulator, InputT value) {
            return this.combineFn.addInput(accumulator, value, this.context);
        }

        @Override
        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            return this.combineFn.mergeAccumulators(accumulators, this.context);
        }

        @Override
        public OutputT extractOutput(AccumT accumulator) {
            return this.combineFn.extractOutput(accumulator, this.context);
        }

        @Override
        public AccumT compact(AccumT accumulator) {
            return this.combineFn.compact(accumulator, this.context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            return this.combineFn.getAccumulatorCoder(registry, (Coder)inputCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            return this.combineFn.getDefaultOutputCoder(registry, (Coder)inputCoder);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.combineFn.populateDisplayData(builder);
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            throw new NotSerializableException("Cannot serialize the CombineFn resulting from CombineFnUtil.bindContext.");
        }
    }
}

