/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Description(value="Options that are used to control the Memory Monitor.")
public interface MemoryMonitorOptions
extends PipelineOptions {
    @Description(value="The GC thrashing threshold percentage. A given period of time is considered \"thrashing\" if this percentage of CPU time is spent in garbage collection. Dataflow will force fail tasks after sustained periods of thrashing.")
    @Default.Double(value=50.0)
    public @UnknownKeyFor @NonNull @Initialized Double getGCThrashingPercentagePerPeriod();

    public void setGCThrashingPercentagePerPeriod(@UnknownKeyFor @NonNull @Initialized Double var1);

    @Description(value="A remote file system to upload captured heap dumps to.")
    public @UnknownKeyFor @NonNull @Initialized String getRemoteHeapDumpLocation();

    public void setRemoteHeapDumpLocation(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="A remote file system to upload captured heap dumps to.")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized boolean getGzipCompressHeapDumps();

    public void setGzipCompressHeapDumps(@UnknownKeyFor @NonNull @Initialized boolean var1);
}

