/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.util.Weighted;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WeightedList<@UnknownKeyFor T>
implements Weighted {
    private final @UnknownKeyFor @NonNull @Initialized List<T> backing;
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong weight;

    public static <T> @UnknownKeyFor @NonNull @Initialized WeightedList<T> of(@UnknownKeyFor @NonNull @Initialized List<T> backing, @UnknownKeyFor @NonNull @Initialized long weight) {
        return new WeightedList<T>(backing, weight);
    }

    public WeightedList(@UnknownKeyFor @NonNull @Initialized List<T> backing, @UnknownKeyFor @NonNull @Initialized long weight) {
        this.backing = backing;
        this.weight = new AtomicLong(weight);
    }

    public @UnknownKeyFor @NonNull @Initialized List<T> getBacking() {
        return this.backing;
    }

    public @UnknownKeyFor @NonNull @Initialized int size() {
        return this.backing.size();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getWeight() {
        return this.weight.longValue();
    }

    public void add(T element, @UnknownKeyFor @NonNull @Initialized long weight) {
        this.backing.add(element);
        this.accumulateWeight(weight);
    }

    public void addAll(@UnknownKeyFor @NonNull @Initialized WeightedList<T> values) {
        this.addAll(values.getBacking(), values.getWeight());
    }

    public void addAll(@UnknownKeyFor @NonNull @Initialized List<T> values, @UnknownKeyFor @NonNull @Initialized long weight) {
        this.backing.addAll(values);
        this.accumulateWeight(weight);
    }

    public void accumulateWeight(@UnknownKeyFor @NonNull @Initialized long weight) {
        this.weight.accumulateAndGet(weight, (first, second) -> {
            try {
                return Math.addExact(first, second);
            }
            catch (ArithmeticException e) {
                return Long.MAX_VALUE;
            }
        });
    }
}

