/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.BoundedTrie;
import org.apache.beam.sdk.metrics.BoundedTrieResult;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.metrics.StringSet;
import org.apache.beam.sdk.metrics.StringSetResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Lineage {
    public static final @UnknownKeyFor @NonNull @Initialized String LINEAGE_NAMESPACE = "lineage";
    private static final @UnknownKeyFor @NonNull @Initialized Lineage SOURCES = new Lineage(Type.SOURCE);
    private static final @UnknownKeyFor @NonNull @Initialized Lineage SINKS = new Lineage(Type.SINK);
    private static final @UnknownKeyFor @NonNull @Initialized Pattern RESERVED_CHARS = Pattern.compile("[:\\s.`]");
    private final @UnknownKeyFor @NonNull @Initialized Metric metric;

    private Lineage(@UnknownKeyFor @NonNull @Initialized Type type) {
        this.metric = Metrics.MetricsFlag.lineageRollupEnabled() ? Metrics.boundedTrie(LINEAGE_NAMESPACE, type == Type.SOURCE ? Type.SOURCEV2.toString() : Type.SINKV2.toString()) : Metrics.stringSet(LINEAGE_NAMESPACE, type.toString());
    }

    public static @UnknownKeyFor @NonNull @Initialized Lineage getSources() {
        return SOURCES;
    }

    public static @UnknownKeyFor @NonNull @Initialized Lineage getSinks() {
        return SINKS;
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> getFQNParts(@UnknownKeyFor @NonNull @Initialized String system, @Nullable @UnknownKeyFor @Initialized String subtype, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments, @Nullable @UnknownKeyFor @Initialized String lastSegmentSep) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(system + ":");
        if (subtype != null) {
            parts.add(subtype + ":");
        }
        if (segments != null) {
            Iterator<String> iterator = segments.iterator();
            String previousSegment = null;
            while (iterator.hasNext()) {
                if (previousSegment != null) {
                    parts.add(Lineage.wrapSegment(previousSegment) + ".");
                }
                previousSegment = iterator.next();
            }
            if (previousSegment != null) {
                if (lastSegmentSep != null) {
                    List subSegments = Splitter.onPattern((String)lastSegmentSep).splitToList((CharSequence)Lineage.wrapSegment(previousSegment));
                    for (int i = 0; i < subSegments.size() - 1; ++i) {
                        parts.add((String)subSegments.get(i) + lastSegmentSep);
                    }
                    parts.add((String)subSegments.get(subSegments.size() - 1));
                } else {
                    parts.add(Lineage.wrapSegment(previousSegment));
                }
            }
        }
        return parts;
    }

    public void add(@UnknownKeyFor @NonNull @Initialized String system, @Nullable @UnknownKeyFor @Initialized String subtype, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments, @Nullable @UnknownKeyFor @Initialized String lastSegmentSep) {
        this.add(Lineage.getFQNParts(system, subtype, segments, lastSegmentSep));
    }

    public void add(@UnknownKeyFor @NonNull @Initialized String system, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments, @Nullable @UnknownKeyFor @Initialized String lastSegmentSep) {
        this.add(system, null, segments, lastSegmentSep);
    }

    public void add(@UnknownKeyFor @NonNull @Initialized String system, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments) {
        this.add(system, segments, null);
    }

    public void add(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> rollupSegments) {
        ImmutableList segments = ImmutableList.copyOf(rollupSegments);
        if (Metrics.MetricsFlag.lineageRollupEnabled()) {
            ((BoundedTrie)this.metric).add((Iterable<String>)segments);
        } else {
            ((StringSet)this.metric).add(String.join((CharSequence)"", (Iterable<? extends CharSequence>)segments));
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> query(@UnknownKeyFor @NonNull @Initialized MetricResults results, @UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized String truncatedMarker) {
        MetricQueryResults lineageQueryResults = Lineage.getLineageQueryResults(results, type);
        HashSet<String> result = new HashSet<String>();
        truncatedMarker = truncatedMarker == null ? "*" : truncatedMarker;
        for (MetricResult<BoundedTrieResult> metrics : lineageQueryResults.getBoundedTries()) {
            String end;
            try {
                for (List<String> fqn : metrics.getCommitted().getResult()) {
                    end = Boolean.parseBoolean(fqn.get(fqn.size() - 1)) ? truncatedMarker : "";
                    result.add(String.join((CharSequence)"", fqn.subList(0, fqn.size() - 1)) + end);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            for (List<String> fqn : metrics.getAttempted().getResult()) {
                end = Boolean.parseBoolean(fqn.get(fqn.size() - 1)) ? truncatedMarker : "";
                result.add(String.join((CharSequence)"", fqn.subList(0, fqn.size() - 1)) + end);
            }
        }
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> query(@UnknownKeyFor @NonNull @Initialized MetricResults results, @UnknownKeyFor @NonNull @Initialized Type type) {
        if (Metrics.MetricsFlag.lineageRollupEnabled()) {
            if (type == Type.SOURCE) {
                type = Type.SOURCEV2;
            }
            if (type == Type.SINK) {
                type = Type.SINKV2;
            }
            return Lineage.query(results, type, "*");
        }
        return Lineage.queryLineageV1(results, type);
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> queryLineageV1(@UnknownKeyFor @NonNull @Initialized MetricResults results, @UnknownKeyFor @NonNull @Initialized Type type) {
        MetricQueryResults lineageQueryResults = Lineage.getLineageQueryResults(results, type);
        HashSet<String> result = new HashSet<String>();
        for (MetricResult<StringSetResult> metrics : lineageQueryResults.getStringSets()) {
            try {
                result.addAll(metrics.getCommitted().getStringSet());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            result.addAll(metrics.getAttempted().getStringSet());
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized MetricQueryResults getLineageQueryResults(@UnknownKeyFor @NonNull @Initialized MetricResults results, @UnknownKeyFor @NonNull @Initialized Type type) {
        MetricsFilter filter = MetricsFilter.builder().addNameFilter(MetricNameFilter.named(LINEAGE_NAMESPACE, type.toString())).build();
        return results.queryMetrics(filter);
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized String wrapSegment(@UnknownKeyFor @NonNull @Initialized String value) {
        if (RESERVED_CHARS.matcher(value = value.replace("`", "``")).find()) {
            return String.format("`%s`", value);
        }
        return value;
    }

    public static enum Type {
        SOURCE("sources"),
        SINK("sinks"),
        SOURCEV2("sources_v2"),
        SINKV2("sinks_v2");

        private final @UnknownKeyFor @NonNull @Initialized String name;

        private Type(String name) {
            this.name = name;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.name;
        }
    }
}

