/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.direct.TransformExecutor;
import org.apache.beam.runners.direct.TransformExecutorService;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransformExecutorServices {
    private TransformExecutorServices() {
    }

    public static @UnknownKeyFor @NonNull @Initialized TransformExecutorService parallel(@UnknownKeyFor @NonNull @Initialized ExecutorService executor) {
        return new ParallelTransformExecutor(executor);
    }

    public static @UnknownKeyFor @NonNull @Initialized TransformExecutorService serial(@UnknownKeyFor @NonNull @Initialized ExecutorService executor) {
        return new SerialTransformExecutor(executor);
    }

    private static class SerialTransformExecutor
    implements TransformExecutorService {
        private final @UnknownKeyFor @NonNull @Initialized ExecutorService executor;
        private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized TransformExecutor> currentlyEvaluating;
        private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized TransformExecutor> workQueue;
        private @UnknownKeyFor @NonNull @Initialized boolean active = true;

        private SerialTransformExecutor(@UnknownKeyFor @NonNull @Initialized ExecutorService executor) {
            this.executor = executor;
            this.currentlyEvaluating = new AtomicReference();
            this.workQueue = new ConcurrentLinkedQueue<TransformExecutor>();
        }

        @Override
        public void schedule(@UnknownKeyFor @NonNull @Initialized TransformExecutor work) {
            this.workQueue.offer(work);
            this.updateCurrentlyEvaluating();
        }

        @Override
        public void complete(@UnknownKeyFor @NonNull @Initialized TransformExecutor completed) {
            if (!this.currentlyEvaluating.compareAndSet(completed, null)) {
                throw new IllegalStateException("Finished work " + completed + " but could not complete due to unexpected currently executing " + this.currentlyEvaluating.get());
            }
            this.updateCurrentlyEvaluating();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            SerialTransformExecutor serialTransformExecutor = this;
            synchronized (serialTransformExecutor) {
                this.active = false;
            }
            this.workQueue.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCurrentlyEvaluating() {
            if (this.currentlyEvaluating.get() == null) {
                SerialTransformExecutor serialTransformExecutor = this;
                synchronized (serialTransformExecutor) {
                    TransformExecutor newWork = this.workQueue.poll();
                    if (this.active && newWork != null) {
                        if (this.currentlyEvaluating.compareAndSet(null, newWork)) {
                            this.executor.submit(newWork);
                        } else {
                            this.workQueue.offer(newWork);
                        }
                    }
                }
            }
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(SerialTransformExecutor.class).add("currentlyEvaluating", this.currentlyEvaluating).add("workQueue", this.workQueue).toString();
        }
    }

    private static class ParallelTransformExecutor
    implements TransformExecutorService {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ParallelTransformExecutor.class);
        private final @UnknownKeyFor @NonNull @Initialized ExecutorService executor;
        private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean active = new AtomicBoolean(true);

        private ParallelTransformExecutor(@UnknownKeyFor @NonNull @Initialized ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public void schedule(@UnknownKeyFor @NonNull @Initialized TransformExecutor work) {
            if (this.active.get()) {
                try {
                    this.executor.submit(work);
                }
                catch (RejectedExecutionException rejected) {
                    boolean stillActive = this.active.get();
                    if (stillActive) {
                        throw new IllegalStateException(String.format("Execution of Work %s was rejected, but the %s is still active", work, ParallelTransformExecutor.class.getSimpleName()));
                    }
                    LOG.debug("Rejected execution of Work {} on executor {}. Suppressed exception because evaluator is not active", (Object)work, (Object)this);
                }
            }
        }

        @Override
        public void complete(@UnknownKeyFor @NonNull @Initialized TransformExecutor completed) {
        }

        @Override
        public void shutdown() {
            this.active.set(false);
        }
    }
}

