/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import org.apache.beam.sdk.metrics.BoundedTrieResult;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricFiltering;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.metrics.StringSetResult;
import org.apache.beam.sdk.util.HistogramData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DefaultMetricResults
extends MetricResults {
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> counters;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> gauges;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized StringSetResult>> stringSets;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized BoundedTrieResult>> boundedTries;
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized HistogramData>> histograms;

    public DefaultMetricResults(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> counters, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> gauges, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized StringSetResult>> stringSets, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized BoundedTrieResult>> boundedTries, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized HistogramData>> histograms) {
        this.counters = counters;
        this.distributions = distributions;
        this.gauges = gauges;
        this.stringSets = stringSets;
        this.boundedTries = boundedTries;
        this.histograms = histograms;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricQueryResults queryMetrics(@Nullable @UnknownKeyFor @Initialized MetricsFilter filter) {
        return MetricQueryResults.create(Iterables.filter(this.counters, counter -> MetricFiltering.matches(filter, counter.getKey())), Iterables.filter(this.distributions, distribution -> MetricFiltering.matches(filter, distribution.getKey())), Iterables.filter(this.gauges, gauge -> MetricFiltering.matches(filter, gauge.getKey())), Iterables.filter(this.stringSets, stringSets -> MetricFiltering.matches(filter, stringSets.getKey())), Iterables.filter(this.boundedTries, boundedTries -> MetricFiltering.matches(filter, boundedTries.getKey())), Iterables.filter(this.histograms, histogram -> MetricFiltering.matches(filter, histogram.getKey())));
    }
}

