/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MetadataCoderV2
extends AtomicCoder<MatchResult.Metadata> {
    private static final @UnknownKeyFor @NonNull @Initialized MetadataCoderV2 INSTANCE = new MetadataCoderV2();
    private static final @UnknownKeyFor @NonNull @Initialized MetadataCoder V1_CODER = MetadataCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized VarLongCoder LONG_CODER = VarLongCoder.of();

    private MetadataCoderV2() {
    }

    public static @UnknownKeyFor @NonNull @Initialized MetadataCoderV2 of() {
        return INSTANCE;
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
        V1_CODER.encode(value, os);
        LONG_CODER.encode(value.lastModifiedMillis(), os);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        MatchResult.Metadata.Builder builder = V1_CODER.decodeBuilder(is);
        long lastModifiedMillis = LONG_CODER.decode(is);
        return builder.setLastModifiedMillis(lastModifiedMillis).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }
}

