/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.renderer;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.QueryablePipeline;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PortablePipelineDotRenderer {
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder dotBuilder = new StringBuilder();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> valueToProducerNodeId = new HashMap<String, Integer>();
    private @UnknownKeyFor @NonNull @Initialized int indent;
    private @UnknownKeyFor @NonNull @Initialized int nextNodeId;

    private PortablePipelineDotRenderer() {
    }

    static @UnknownKeyFor @NonNull @Initialized String toDotString(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        return new PortablePipelineDotRenderer().toDot(pipeline);
    }

    private @UnknownKeyFor @NonNull @Initialized String toDot(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        QueryablePipeline p = QueryablePipeline.forTransforms((Collection<String>)pipeline.getRootTransformIdsList(), pipeline.getComponents());
        this.begin();
        for (PipelineNode.PTransformNode transform : p.getTopologicallyOrderedTransforms()) {
            this.visitTransform(transform);
        }
        this.end();
        return this.dotBuilder.toString();
    }

    private void visitTransform(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode node) {
        int nodeId = this.nextNodeId++;
        RunnerApi.PTransform transform = node.getTransform();
        this.writeLine("%d [label=\"%s\\n%s\"]", nodeId, PortablePipelineDotRenderer.escapeString(transform.getUniqueName()), PortablePipelineDotRenderer.escapeString(transform.getSpec().getUrn()));
        transform.getOutputsMap().values().forEach(x -> this.valueToProducerNodeId.put((String)x, nodeId));
        transform.getInputsMap().forEach((key, value) -> {
            int producerId = this.valueToProducerNodeId.get(value);
            String style = "solid";
            this.writeLine("%d -> %d [style=%s label=\"%s\"]", producerId, nodeId, style, PortablePipelineDotRenderer.escapeString(value.substring(value.lastIndexOf(95) + 1)));
        });
    }

    private void begin() {
        this.writeLine("digraph {", new Object[0]);
        this.enterBlock();
        this.writeLine("rankdir=LR", new Object[0]);
    }

    private void end() {
        this.exitBlock();
        this.writeLine("}", new Object[0]);
    }

    private void enterBlock() {
        this.indent += 4;
    }

    private void exitBlock() {
        this.indent -= 4;
    }

    @FormatMethod
    private void writeLine(@FormatString @UnknownKeyFor @NonNull @Initialized String format, Object ... args) {
        if (this.indent != 0) {
            this.dotBuilder.append(String.format("%-" + this.indent + "s", ""));
        }
        this.dotBuilder.append(String.format(format, args));
        this.dotBuilder.append(System.lineSeparator());
    }

    private static @UnknownKeyFor @NonNull @Initialized String escapeString(@UnknownKeyFor @NonNull @Initialized String x) {
        return x.replace("\"", "\\\"");
    }
}

