/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.state;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.ByteStringCoder;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.DataStreams;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StateRequestHandlers {
    public static @UnknownKeyFor @NonNull @Initialized StateRequestHandler delegateBasedUponType(@UnknownKeyFor @NonNull @Initialized EnumMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateKey.TypeCase, @UnknownKeyFor @NonNull @Initialized StateRequestHandler> handlers) {
        return new StateKeyTypeDelegatingStateRequestHandler(handlers);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateRequestHandler forSideInputHandlerFactory(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String,  @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.SideInputSpec>> sideInputSpecs, @UnknownKeyFor @NonNull @Initialized SideInputHandlerFactory sideInputHandlerFactory) {
        return new StateRequestHandlerToSideInputHandlerFactoryAdapter(sideInputSpecs, sideInputHandlerFactory);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateRequestHandler forBagUserStateHandlerFactory( @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor, @UnknownKeyFor @NonNull @Initialized BagUserStateHandlerFactory bagUserStateHandlerFactory) {
        return new ByteStringStateRequestHandlerToBagUserStateHandlerFactoryAdapter(processBundleDescriptor, bagUserStateHandlerFactory);
    }

    static class ByteStringStateRequestHandlerToBagUserStateHandlerFactoryAdapter
    implements StateRequestHandler {
        private final  @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor;
        private final @UnknownKeyFor @NonNull @Initialized BagUserStateHandlerFactory handlerFactory;
        private final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap< @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.BagUserStateSpec, @UnknownKeyFor @NonNull @Initialized BagUserStateHandler> handlerCache;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleRequest.CacheToken cacheToken;

        ByteStringStateRequestHandlerToBagUserStateHandlerFactoryAdapter( @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.ExecutableProcessBundleDescriptor processBundleDescriptor, @UnknownKeyFor @NonNull @Initialized BagUserStateHandlerFactory handlerFactory) {
            this.processBundleDescriptor = processBundleDescriptor;
            this.handlerFactory = handlerFactory;
            this.handlerCache = new ConcurrentHashMap();
            this.cacheToken = ByteStringStateRequestHandlerToBagUserStateHandlerFactoryAdapter.createCacheToken();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handle(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request) throws @UnknownKeyFor @NonNull @Initialized Exception {
            try {
                Preconditions.checkState((boolean)BeamFnApi.StateKey.TypeCase.BAG_USER_STATE.equals((Object)request.getStateKey().getTypeCase()), (String)"Unsupported %s type %s, expected %s", (Object)BeamFnApi.StateRequest.class.getSimpleName(), (Object)request.getStateKey().getTypeCase(), (Object)BeamFnApi.StateKey.TypeCase.BAG_USER_STATE);
                BeamFnApi.StateKey.BagUserState stateKey = request.getStateKey().getBagUserState();
                ProcessBundleDescriptors.BagUserStateSpec referenceSpec = this.processBundleDescriptor.getBagUserStateSpecs().get(stateKey.getTransformId()).get(stateKey.getUserStateId());
                Preconditions.checkState((boolean)(referenceSpec.keyCoder() instanceof ByteStringCoder), (String)"This %s only supports the %s as the key coder.", (Object)BagUserStateHandlerFactory.class.getSimpleName(), (Object)ByteStringCoder.class.getSimpleName());
                Preconditions.checkState((boolean)(referenceSpec.valueCoder() instanceof ByteStringCoder), (String)"This %s only supports the %s as the value coder.", (Object)BagUserStateHandlerFactory.class.getSimpleName(), (Object)ByteStringCoder.class.getSimpleName());
                BagUserStateHandler handler = this.handlerCache.computeIfAbsent(referenceSpec, this::createHandler);
                ByteString key = stateKey.getKey();
                BoundedWindow window = (BoundedWindow)referenceSpec.windowCoder().decode(stateKey.getWindow().newInput());
                switch (request.getRequestCase()) {
                    case GET: {
                        return ByteStringStateRequestHandlerToBagUserStateHandlerFactoryAdapter.handleGetRequest(request, key, window, handler);
                    }
                    case APPEND: {
                        return ByteStringStateRequestHandlerToBagUserStateHandlerFactoryAdapter.handleAppendRequest(request, key, window, handler);
                    }
                    case CLEAR: {
                        return ByteStringStateRequestHandlerToBagUserStateHandlerFactoryAdapter.handleClearRequest(request, key, window, handler);
                    }
                }
                throw new Exception(String.format("Unsupported request type %s for user state.", request.getRequestCase()));
            }
            catch (Exception e) {
                CompletableFuture<BeamFnApi.StateResponse.Builder> f = new CompletableFuture<BeamFnApi.StateResponse.Builder>();
                f.completeExceptionally(e);
                return f;
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleRequest.CacheToken> getCacheTokens() {
            return Collections.singleton(this.cacheToken);
        }

        private static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handleGetRequest(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request, @UnknownKeyFor @NonNull @Initialized ByteString key, W window, @UnknownKeyFor @NonNull @Initialized BagUserStateHandler<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ByteString, W> handler) {
            Preconditions.checkState((boolean)request.getGet().getContinuationToken().isEmpty(), (Object)"Continuation tokens are unsupported.");
            return CompletableFuture.completedFuture(BeamFnApi.StateResponse.newBuilder().setId(request.getId()).setGet(BeamFnApi.StateGetResponse.newBuilder().setData(ByteString.copyFrom(handler.get(key, window)))));
        }

        private static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handleAppendRequest(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request, @UnknownKeyFor @NonNull @Initialized ByteString key, W window, @UnknownKeyFor @NonNull @Initialized BagUserStateHandler<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ByteString, W> handler) {
            handler.append(key, window, (Iterator<ByteString>)ImmutableList.of((Object)request.getAppend().getData()).iterator());
            return CompletableFuture.completedFuture(BeamFnApi.StateResponse.newBuilder().setId(request.getId()).setAppend(BeamFnApi.StateAppendResponse.getDefaultInstance()));
        }

        private static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handleClearRequest(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request, @UnknownKeyFor @NonNull @Initialized ByteString key, W window, @UnknownKeyFor @NonNull @Initialized BagUserStateHandler<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ByteString, W> handler) {
            handler.clear(key, window);
            return CompletableFuture.completedFuture(BeamFnApi.StateResponse.newBuilder().setId(request.getId()).setClear(BeamFnApi.StateClearResponse.getDefaultInstance()));
        }

        private <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized BagUserStateHandler<K, V, W> createHandler( @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.BagUserStateSpec cacheKey) {
            return this.handlerFactory.forUserState(cacheKey.transformId(), cacheKey.userStateId(), cacheKey.keyCoder(), cacheKey.valueCoder(), cacheKey.windowCoder());
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleRequest.CacheToken createCacheToken() {
            ByteString token = ByteString.copyFrom((byte[])UUID.randomUUID().toString().getBytes(Charsets.UTF_8));
            return BeamFnApi.ProcessBundleRequest.CacheToken.newBuilder().setUserState(BeamFnApi.ProcessBundleRequest.CacheToken.UserState.getDefaultInstance()).setToken(token).build();
        }
    }

    static class StateRequestHandlerToSideInputHandlerFactoryAdapter
    implements StateRequestHandler {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String,  @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.SideInputSpec>> sideInputSpecs;
        private final @UnknownKeyFor @NonNull @Initialized SideInputHandlerFactory sideInputHandlerFactory;
        private final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap< @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.SideInputSpec, @UnknownKeyFor @NonNull @Initialized SideInputHandler> handlerCache;

        StateRequestHandlerToSideInputHandlerFactoryAdapter(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String,  @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.SideInputSpec>> sideInputSpecs, @UnknownKeyFor @NonNull @Initialized SideInputHandlerFactory sideInputHandlerFactory) {
            this.sideInputSpecs = sideInputSpecs;
            this.sideInputHandlerFactory = sideInputHandlerFactory;
            this.handlerCache = new ConcurrentHashMap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handle(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkState((boolean)BeamFnApi.StateRequest.RequestCase.GET.equals((Object)request.getRequestCase()), (Object)String.format("Unsupported request type %s for side input.", request.getRequestCase()));
            try {
                switch (request.getStateKey().getTypeCase()) {
                    case MULTIMAP_SIDE_INPUT: {
                        BeamFnApi.StateKey.MultimapSideInput stateKey = request.getStateKey().getMultimapSideInput();
                        ProcessBundleDescriptors.SideInputSpec referenceSpec = this.sideInputSpecs.get(stateKey.getTransformId()).get(stateKey.getSideInputId());
                        MultimapSideInputHandler handler = (MultimapSideInputHandler)this.handlerCache.computeIfAbsent(referenceSpec, this::createHandler);
                        return this.handleGetMultimapValuesRequest(request, handler);
                    }
                    case MULTIMAP_KEYS_SIDE_INPUT: {
                        BeamFnApi.StateKey.MultimapKeysSideInput stateKey = request.getStateKey().getMultimapKeysSideInput();
                        ProcessBundleDescriptors.SideInputSpec referenceSpec = this.sideInputSpecs.get(stateKey.getTransformId()).get(stateKey.getSideInputId());
                        MultimapSideInputHandler handler = (MultimapSideInputHandler)this.handlerCache.computeIfAbsent(referenceSpec, this::createHandler);
                        return this.handleGetMultimapKeysRequest(request, handler);
                    }
                    case ITERABLE_SIDE_INPUT: {
                        BeamFnApi.StateKey.IterableSideInput stateKey = request.getStateKey().getIterableSideInput();
                        ProcessBundleDescriptors.SideInputSpec referenceSpec = this.sideInputSpecs.get(stateKey.getTransformId()).get(stateKey.getSideInputId());
                        IterableSideInputHandler handler = (IterableSideInputHandler)this.handlerCache.computeIfAbsent(referenceSpec, this::createHandler);
                        return this.handleGetIterableValuesRequest(request, handler);
                    }
                }
                throw new IllegalStateException(String.format("Unsupported %s type %s, expected %s or %s", BeamFnApi.StateRequest.class.getSimpleName(), request.getStateKey().getTypeCase(), BeamFnApi.StateKey.TypeCase.MULTIMAP_SIDE_INPUT, BeamFnApi.StateKey.TypeCase.MULTIMAP_KEYS_SIDE_INPUT));
            }
            catch (Exception e) {
                CompletableFuture<BeamFnApi.StateResponse.Builder> f = new CompletableFuture<BeamFnApi.StateResponse.Builder>();
                f.completeExceptionally(e);
                return f;
            }
        }

        private <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handleGetMultimapKeysRequest(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request, @UnknownKeyFor @NonNull @Initialized MultimapSideInputHandler<K, V, W> handler) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkState((boolean)request.getGet().getContinuationToken().isEmpty(), (Object)"Continuation tokens are unsupported.");
            BeamFnApi.StateKey.MultimapKeysSideInput stateKey = request.getStateKey().getMultimapKeysSideInput();
            ProcessBundleDescriptors.SideInputSpec sideInputReferenceSpec = this.sideInputSpecs.get(stateKey.getTransformId()).get(stateKey.getSideInputId());
            BoundedWindow window = (BoundedWindow)sideInputReferenceSpec.windowCoder().decode(stateKey.getWindow().newInput());
            Iterable<K> keys = handler.get(window);
            ArrayList encodedValues = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = DataStreams.outbound(encodedValues::add);
            for (K key : keys) {
                handler.keyCoder().encode(key, (OutputStream)outputStream);
                outputStream.delimitElement();
            }
            outputStream.close();
            BeamFnApi.StateResponse.Builder response = BeamFnApi.StateResponse.newBuilder();
            response.setId(request.getId());
            response.setGet(BeamFnApi.StateGetResponse.newBuilder().setData(ByteString.copyFrom(encodedValues)).build());
            return CompletableFuture.completedFuture(response);
        }

        private <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handleGetMultimapValuesRequest(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request, @UnknownKeyFor @NonNull @Initialized MultimapSideInputHandler<K, V, W> handler) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkState((boolean)request.getGet().getContinuationToken().isEmpty(), (Object)"Continuation tokens are unsupported.");
            BeamFnApi.StateKey.MultimapSideInput stateKey = request.getStateKey().getMultimapSideInput();
            ProcessBundleDescriptors.SideInputSpec sideInputReferenceSpec = this.sideInputSpecs.get(stateKey.getTransformId()).get(stateKey.getSideInputId());
            BoundedWindow window = (BoundedWindow)sideInputReferenceSpec.windowCoder().decode(stateKey.getWindow().newInput());
            Iterable<V> values = handler.get(handler.keyCoder().decode(stateKey.getKey().newInput()), window);
            ArrayList encodedValues = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = DataStreams.outbound(encodedValues::add);
            for (V value : values) {
                handler.valueCoder().encode(value, (OutputStream)outputStream);
                outputStream.delimitElement();
            }
            outputStream.close();
            BeamFnApi.StateResponse.Builder response = BeamFnApi.StateResponse.newBuilder();
            response.setId(request.getId());
            response.setGet(BeamFnApi.StateGetResponse.newBuilder().setData(ByteString.copyFrom(encodedValues)).build());
            return CompletableFuture.completedFuture(response);
        }

        private <V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handleGetIterableValuesRequest(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request, @UnknownKeyFor @NonNull @Initialized IterableSideInputHandler<V, W> handler) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkState((boolean)request.getGet().getContinuationToken().isEmpty(), (Object)"Continuation tokens are unsupported.");
            BeamFnApi.StateKey.IterableSideInput stateKey = request.getStateKey().getIterableSideInput();
            ProcessBundleDescriptors.SideInputSpec sideInputReferenceSpec = this.sideInputSpecs.get(stateKey.getTransformId()).get(stateKey.getSideInputId());
            BoundedWindow window = (BoundedWindow)sideInputReferenceSpec.windowCoder().decode(stateKey.getWindow().newInput());
            Iterable<V> values = handler.get(window);
            ArrayList encodedValues = new ArrayList();
            DataStreams.ElementDelimitedOutputStream outputStream = DataStreams.outbound(encodedValues::add);
            for (V value : values) {
                handler.elementCoder().encode(value, (OutputStream)outputStream);
                outputStream.delimitElement();
            }
            outputStream.close();
            BeamFnApi.StateResponse.Builder response = BeamFnApi.StateResponse.newBuilder();
            response.setId(request.getId());
            response.setGet(BeamFnApi.StateGetResponse.newBuilder().setData(ByteString.copyFrom(encodedValues)).build());
            return CompletableFuture.completedFuture(response);
        }

        private @UnknownKeyFor @NonNull @Initialized SideInputHandler createHandler(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized ProcessBundleDescriptors.SideInputSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> cacheKey) {
            switch (cacheKey.accessPattern().getUrn()) {
                case "beam:side_input:iterable:v1": {
                    return this.sideInputHandlerFactory.forIterableSideInput(cacheKey.transformId(), cacheKey.sideInputId(), cacheKey.elementCoder(), cacheKey.windowCoder());
                }
                case "beam:side_input:multimap:v1": {
                    return this.sideInputHandlerFactory.forMultimapSideInput(cacheKey.transformId(), cacheKey.sideInputId(), (KvCoder)cacheKey.elementCoder(), cacheKey.windowCoder());
                }
            }
            throw new IllegalStateException(String.format("Unsupported access pattern for side input %s", cacheKey));
        }
    }

    static class StateKeyTypeDelegatingStateRequestHandler
    implements StateRequestHandler {
        private final @UnknownKeyFor @NonNull @Initialized EnumMap<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateKey.TypeCase, @UnknownKeyFor @NonNull @Initialized StateRequestHandler> handlers;

        StateKeyTypeDelegatingStateRequestHandler(@UnknownKeyFor @NonNull @Initialized EnumMap<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateKey.TypeCase, @UnknownKeyFor @NonNull @Initialized StateRequestHandler> handlers) {
            this.handlers = handlers;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handle(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.handlers.getOrDefault(request.getStateKey().getTypeCase(), this::handlerNotFound).handle(request);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleRequest.CacheToken> getCacheTokens() {
            HashSet<BeamFnApi.ProcessBundleRequest.CacheToken> cacheTokens = new HashSet<BeamFnApi.ProcessBundleRequest.CacheToken>();
            for (StateRequestHandler handler : this.handlers.values()) {
                for (BeamFnApi.ProcessBundleRequest.CacheToken cacheToken : handler.getCacheTokens()) {
                    cacheTokens.add(cacheToken);
                }
            }
            return cacheTokens;
        }

        private @UnknownKeyFor @NonNull @Initialized CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateResponse.Builder> handlerNotFound(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request) {
            CompletableFuture<BeamFnApi.StateResponse.Builder> rval = new CompletableFuture<BeamFnApi.StateResponse.Builder>();
            rval.completeExceptionally(new IllegalStateException());
            return rval;
        }
    }

    @ThreadSafe
    public static interface BagUserStateHandlerFactory<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
        public @UnknownKeyFor @NonNull @Initialized BagUserStateHandler<K, V, W> forUserState(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized Coder<K> var3, @UnknownKeyFor @NonNull @Initialized Coder<V> var4, @UnknownKeyFor @NonNull @Initialized Coder<W> var5);

        public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized BagUserStateHandlerFactory<K, V, W> unsupported() {
            return (pTransformId, userStateId, keyCoder, valueCoder, windowCoder) -> {
                throw new UnsupportedOperationException(String.format("The %s does not support handling sides inputs for PTransform %s with user state id %s.", BagUserStateHandler.class.getSimpleName(), pTransformId, userStateId));
            };
        }
    }

    @ThreadSafe
    public static interface BagUserStateHandler<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
        public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K var1, W var2);

        public void append(K var1, W var2, @UnknownKeyFor @NonNull @Initialized Iterator<V> var3);

        public void clear(K var1, W var2);
    }

    @ThreadSafe
    public static interface SideInputHandlerFactory {
        public <V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized IterableSideInputHandler<V, W> forIterableSideInput(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized Coder<V> var3, @UnknownKeyFor @NonNull @Initialized Coder<W> var4);

        public <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized MultimapSideInputHandler<K, V, W> forMultimapSideInput(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> var3, @UnknownKeyFor @NonNull @Initialized Coder<W> var4);

        public static @UnknownKeyFor @NonNull @Initialized SideInputHandlerFactory unsupported() {
            return new SideInputHandlerFactory(){

                @Override
                public <V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized IterableSideInputHandler<V, W> forIterableSideInput(@UnknownKeyFor @NonNull @Initialized String pTransformId, @UnknownKeyFor @NonNull @Initialized String sideInputId, @UnknownKeyFor @NonNull @Initialized Coder<V> elementCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                    throw new UnsupportedOperationException(String.format("The %s does not support handling sides inputs for PTransform %s with side input id %s.", SideInputHandlerFactory.class.getSimpleName(), pTransformId, sideInputId));
                }

                @Override
                public <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized MultimapSideInputHandler<K, V, W> forMultimapSideInput(@UnknownKeyFor @NonNull @Initialized String pTransformId, @UnknownKeyFor @NonNull @Initialized String sideInputId, @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> elementCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
                    throw new UnsupportedOperationException(String.format("The %s does not support handling sides inputs for PTransform %s with side input id %s.", SideInputHandlerFactory.class.getSimpleName(), pTransformId, sideInputId));
                }
            };
        }
    }

    @ThreadSafe
    public static interface MultimapSideInputHandler<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends SideInputHandler {
        public @UnknownKeyFor @NonNull @Initialized Iterable<K> get(W var1);

        public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K var1, W var2);

        public @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder();

        public @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder();
    }

    @ThreadSafe
    public static interface IterableSideInputHandler<@UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends SideInputHandler {
        public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(W var1);

        public @UnknownKeyFor @NonNull @Initialized Coder<V> elementCoder();
    }

    @ThreadSafe
    public static interface SideInputHandler {
    }
}

