/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.apache.beam.model.pipeline.v1.MetricsApi;

public class SpecMonitoringInfoValidator {
    protected final MetricsApi.MonitoringInfoSpec[] specs = (MetricsApi.MonitoringInfoSpec[])Arrays.stream(MetricsApi.MonitoringInfoSpecs.Enum.values()).filter(x -> !x.name().equals("UNRECOGNIZED")).map(x -> (MetricsApi.MonitoringInfoSpec)x.getValueDescriptor().getOptions().getExtension(MetricsApi.monitoringInfoSpec)).toArray(MetricsApi.MonitoringInfoSpec[]::new);

    public Optional<String> validate(MetricsApi.MonitoringInfo monitoringInfo) {
        MetricsApi.MonitoringInfoSpec spec = null;
        if (monitoringInfo.getUrn().isEmpty() || monitoringInfo.getType().isEmpty()) {
            return Optional.of(String.format("MonitoringInfo requires both urn %s and type %s to be specified.", monitoringInfo.getUrn(), monitoringInfo.getType()));
        }
        for (MetricsApi.MonitoringInfoSpec specIterator : this.specs) {
            if (!monitoringInfo.getUrn().equals(specIterator.getUrn()) || !monitoringInfo.getType().equals(specIterator.getType())) continue;
            spec = specIterator;
            break;
        }
        if (spec == null) {
            return Optional.empty();
        }
        HashSet requiredLabels = new HashSet(spec.getRequiredLabelsList());
        if (!monitoringInfo.getLabelsMap().keySet().containsAll(requiredLabels)) {
            return Optional.of(String.format("MonitoringInfo with urn: %s should have labels: %s, actual: %s", monitoringInfo.getUrn(), requiredLabels, monitoringInfo.getLabelsMap()));
        }
        return Optional.empty();
    }
}

