/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.DefaultArtifactResolver;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environments {
    private static final Logger LOG = LoggerFactory.getLogger(Environments.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    public static final String ENVIRONMENT_DOCKER = "DOCKER";
    public static final String ENVIRONMENT_PROCESS = "PROCESS";
    public static final String ENVIRONMENT_EXTERNAL = "EXTERNAL";
    public static final String ENVIRONMENT_EMBEDDED = "EMBEDDED";
    public static final String ENVIRONMENT_LOOPBACK = "LOOPBACK";
    private static final String dockerContainerImageOption = "docker_container_image";
    private static final String externalServiceAddressOption = "external_service_address";
    private static final String processCommandOption = "process_command";
    private static final String processVariablesOption = "process_variables";
    private static final Map<String, Set<String>> allowedEnvironmentOptions = ImmutableMap.builder().put((Object)"DOCKER", (Object)ImmutableSet.of((Object)"docker_container_image")).put((Object)"EXTERNAL", (Object)ImmutableSet.of((Object)"external_service_address")).put((Object)"PROCESS", (Object)ImmutableSet.of((Object)"process_command", (Object)"process_variables")).build();
    private static final String JAVA_SDK_HARNESS_CONTAINER_URL = Environments.getDefaultJavaSdkHarnessContainerUrl();
    public static final RunnerApi.Environment JAVA_SDK_HARNESS_ENVIRONMENT = Environments.createDockerEnvironment(JAVA_SDK_HARNESS_CONTAINER_URL);

    private Environments() {
    }

    public static RunnerApi.Environment createOrGetDefaultEnvironment(PortablePipelineOptions options) {
        RunnerApi.Environment defaultEnvironment;
        Environments.verifyEnvironmentOptions(options);
        String type = options.getDefaultEnvironmentType();
        String config = options.getDefaultEnvironmentConfig();
        if (Strings.isNullOrEmpty((String)type)) {
            defaultEnvironment = JAVA_SDK_HARNESS_ENVIRONMENT;
        } else {
            switch (type) {
                case "EMBEDDED": {
                    defaultEnvironment = Environments.createEmbeddedEnvironment(config);
                    break;
                }
                case "EXTERNAL": 
                case "LOOPBACK": {
                    defaultEnvironment = Environments.createExternalEnvironment(Environments.getExternalServiceAddress(options));
                    break;
                }
                case "PROCESS": {
                    defaultEnvironment = Environments.createProcessEnvironment(options);
                    break;
                }
                default: {
                    defaultEnvironment = Environments.createDockerEnvironment(Environments.getDockerContainerImage(options));
                }
            }
        }
        return defaultEnvironment.toBuilder().addAllDependencies(Environments.getDeferredArtifacts((PipelineOptions)options)).addAllCapabilities(Environments.getJavaCapabilities()).build();
    }

    public static RunnerApi.Environment createDockerEnvironment(String dockerImageUrl) {
        if (dockerImageUrl.isEmpty()) {
            return JAVA_SDK_HARNESS_ENVIRONMENT;
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(dockerImageUrl).build().toByteString()).build();
    }

    private static RunnerApi.Environment createExternalEnvironment(String externalServiceAddress) {
        if (externalServiceAddress.isEmpty()) {
            throw new IllegalArgumentException(String.format("External service address must not be empty (set it using '--environmentOptions=%s=...'?).", externalServiceAddressOption));
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.EXTERNAL)).setPayload(RunnerApi.ExternalPayload.newBuilder().setEndpoint(Endpoints.ApiServiceDescriptor.newBuilder().setUrl(externalServiceAddress).build()).build().toByteString()).build();
    }

    private static RunnerApi.Environment createEmbeddedEnvironment(String config) {
        return RunnerApi.Environment.newBuilder().setUrn(ENVIRONMENT_EMBEDDED).setPayload(ByteString.copyFromUtf8((String)((String)MoreObjects.firstNonNull((Object)config, (Object)"")))).build();
    }

    private static RunnerApi.Environment createProcessEnvironment(PortablePipelineOptions options) {
        if (options.getEnvironmentOptions() != null) {
            String processCommand = PortablePipelineOptions.getEnvironmentOption((PortablePipelineOptions)options, (String)processCommandOption);
            if (processCommand.isEmpty()) {
                throw new IllegalArgumentException(String.format("Environment option '%s' must be set for process environment.", processCommandOption));
            }
            return Environments.createProcessEnvironment("", "", processCommand, Environments.getProcessVariables(options));
        }
        try {
            ProcessPayloadReferenceJSON payloadReferenceJSON = (ProcessPayloadReferenceJSON)MAPPER.readValue(options.getDefaultEnvironmentConfig(), ProcessPayloadReferenceJSON.class);
            return Environments.createProcessEnvironment(payloadReferenceJSON.getOs(), payloadReferenceJSON.getArch(), payloadReferenceJSON.getCommand(), payloadReferenceJSON.getEnv());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to parse process environment config: %s", options.getDefaultEnvironmentConfig()), e);
        }
    }

    public static RunnerApi.Environment createProcessEnvironment(String os, String arch, String command, Map<String, String> env) {
        RunnerApi.ProcessPayload.Builder builder = RunnerApi.ProcessPayload.newBuilder();
        if (!Strings.isNullOrEmpty((String)os)) {
            builder.setOs(os);
        }
        if (!Strings.isNullOrEmpty((String)arch)) {
            builder.setArch(arch);
        }
        if (!Strings.isNullOrEmpty((String)command)) {
            builder.setCommand(command);
        }
        if (env != null) {
            builder.putAllEnv(env);
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.PROCESS)).setPayload(builder.build().toByteString()).build();
    }

    public static Optional<RunnerApi.Environment> getEnvironment(String ptransformId, RunnerApi.Components components) {
        RunnerApi.PTransform ptransform = components.getTransformsOrThrow(ptransformId);
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironmentsOrThrow(envId));
    }

    public static Optional<RunnerApi.Environment> getEnvironment(RunnerApi.PTransform ptransform, RehydratedComponents components) {
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironment(envId));
    }

    public static List<RunnerApi.ArtifactInformation> getArtifacts(List<String> stagingFiles) {
        ImmutableList.Builder artifactsBuilder = ImmutableList.builder();
        LinkedHashSet<String> deduplicatedStagingFiles = new LinkedHashSet<String>(stagingFiles);
        for (String path : deduplicatedStagingFiles) {
            HashCode hashCode;
            File file;
            String stagedName = null;
            if (path.contains("=")) {
                String[] components = path.split("=", 2);
                file = new File(components[1]);
                stagedName = components[0];
            } else {
                file = new File(path);
            }
            if (!file.exists()) continue;
            RunnerApi.ArtifactInformation.Builder artifactBuilder = RunnerApi.ArtifactInformation.newBuilder();
            artifactBuilder.setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE));
            artifactBuilder.setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO));
            if (file.isDirectory()) {
                File zippedFile;
                try {
                    zippedFile = Environments.zipDirectory(file);
                    hashCode = Files.asByteSource((File)zippedFile).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(zippedFile.getPath()).setSha256(hashCode.toString()).build().toByteString());
            } else {
                try {
                    hashCode = Files.asByteSource((File)file).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(file.getPath()).setSha256(hashCode.toString()).build().toByteString());
            }
            if (stagedName == null) {
                stagedName = Environments.createStagingFileName(file, hashCode);
            }
            artifactBuilder.setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName(stagedName).build().toByteString());
            artifactsBuilder.add((Object)artifactBuilder.build());
        }
        return artifactsBuilder.build();
    }

    public static List<RunnerApi.ArtifactInformation> getDeferredArtifacts(PipelineOptions options) {
        List stagingFiles = ((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).getFilesToStage();
        if (stagingFiles == null || stagingFiles.isEmpty()) {
            return ImmutableList.of();
        }
        String key = UUID.randomUUID().toString();
        DefaultArtifactResolver.INSTANCE.register(info -> {
            if (BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.DEFERRED).equals(info.getTypeUrn())) {
                RunnerApi.DeferredArtifactPayload deferredArtifactPayload;
                try {
                    deferredArtifactPayload = RunnerApi.DeferredArtifactPayload.parseFrom((ByteString)info.getTypePayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Error parsing deferred artifact payload.", e);
                }
                if (key.equals(deferredArtifactPayload.getKey())) {
                    return Optional.of(Environments.getArtifacts(stagingFiles));
                }
                return Optional.empty();
            }
            return Optional.empty();
        });
        return ImmutableList.of((Object)RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.DEFERRED)).setTypePayload(RunnerApi.DeferredArtifactPayload.newBuilder().setKey(key).build().toByteString()).build());
    }

    public static Set<String> getJavaCapabilities() {
        ImmutableSet.Builder capabilities = ImmutableSet.builder();
        capabilities.addAll(ModelCoders.urns());
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardProtocols.Enum.MULTI_CORE_BUNDLE_PROCESSING));
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardProtocols.Enum.PROGRESS_REPORTING));
        capabilities.add((Object)("beam:version:sdk_base:" + JAVA_SDK_HARNESS_CONTAINER_URL));
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.TRUNCATE_SIZED_RESTRICTION));
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.TO_STRING));
        return capabilities.build();
    }

    public static JavaVersion getJavaVersion() {
        return JavaVersion.forSpecification(System.getProperty("java.specification.version"));
    }

    public static String createStagingFileName(File path, HashCode hash) {
        String encodedHash = Base64Variants.MODIFIED_FOR_URL.encode(hash.asBytes());
        String fileName = Files.getNameWithoutExtension((String)path.getAbsolutePath());
        String ext = path.isDirectory() ? "jar" : Files.getFileExtension((String)path.getAbsolutePath());
        String suffix = Strings.isNullOrEmpty((String)ext) ? "" : "." + ext;
        return String.format("%s-%s%s", fileName, encodedHash, suffix);
    }

    private static File zipDirectory(File directory) throws IOException {
        File zipFile = File.createTempFile(directory.getName(), ".zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            ZipFiles.zipDirectory((File)directory, (OutputStream)fos);
        }
        return zipFile;
    }

    private static String getDefaultJavaSdkHarnessContainerUrl() {
        return String.format("%s/%s%s_sdk:%s", ReleaseInfo.getReleaseInfo().getDefaultDockerRepoRoot(), ReleaseInfo.getReleaseInfo().getDefaultDockerRepoPrefix(), Environments.getJavaVersion().toString(), ReleaseInfo.getReleaseInfo().getSdkVersion());
    }

    private static String getDockerContainerImage(PortablePipelineOptions options) {
        String environmentConfig = options.getDefaultEnvironmentConfig();
        String environmentOption = PortablePipelineOptions.getEnvironmentOption((PortablePipelineOptions)options, (String)dockerContainerImageOption);
        if (environmentConfig != null && !environmentConfig.isEmpty()) {
            return environmentConfig;
        }
        return environmentOption;
    }

    private static String getExternalServiceAddress(PortablePipelineOptions options) {
        String environmentConfig = options.getDefaultEnvironmentConfig();
        String environmentOption = PortablePipelineOptions.getEnvironmentOption((PortablePipelineOptions)options, (String)externalServiceAddressOption);
        if (environmentConfig != null && !environmentConfig.isEmpty()) {
            return environmentConfig;
        }
        return environmentOption;
    }

    private static Map<String, String> getProcessVariables(PortablePipelineOptions options) {
        ImmutableMap.Builder variables = ImmutableMap.builder();
        String assignments = PortablePipelineOptions.getEnvironmentOption((PortablePipelineOptions)options, (String)processVariablesOption);
        for (String assignment : assignments.split(",", -1)) {
            String[] tokens = assignment.split("=", -1);
            if (tokens.length == 1) {
                throw new IllegalArgumentException(String.format("Process environment variable '%s' is not assigned a value.", tokens[0]));
            }
            variables.put((Object)tokens[0], (Object)tokens[1]);
        }
        return variables.build();
    }

    private static void verifyEnvironmentOptions(PortablePipelineOptions options) {
        if (options.getEnvironmentOptions() == null || options.getEnvironmentOptions().isEmpty()) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)options.getDefaultEnvironmentConfig())) {
            throw new IllegalArgumentException("Pipeline options defaultEnvironmentConfig and environmentOptions are mutually exclusive.");
        }
        Set<String> allowedOptions = allowedEnvironmentOptions.getOrDefault(options.getDefaultEnvironmentType(), (Set<String>)ImmutableSet.of());
        for (String option : options.getEnvironmentOptions()) {
            String optionName = option.split("=", -1)[0];
            if (allowedOptions.contains(optionName)) continue;
            throw new IllegalArgumentException(String.format("Environment option '%s' is incompatible with environment type '%s'.", option, options.getDefaultEnvironmentType()));
        }
    }

    private static class ProcessPayloadReferenceJSON {
        private @Nullable String os;
        private @Nullable String arch;
        private @Nullable String command;
        private @Nullable Map<String, String> env;

        private ProcessPayloadReferenceJSON() {
        }

        public @Nullable String getOs() {
            return this.os;
        }

        public @Nullable String getArch() {
            return this.arch;
        }

        public @Nullable String getCommand() {
            return this.command;
        }

        public @Nullable Map<String, String> getEnv() {
            return this.env;
        }
    }

    public static enum JavaVersion {
        java8("java", "1.8"),
        java11("java11", "11"),
        java17("java17", "17");

        private final String legacyName;
        private final String specification;

        private JavaVersion(String legacyName, String specification) {
            this.legacyName = legacyName;
            this.specification = specification;
        }

        public String legacyName() {
            return this.legacyName;
        }

        public String specification() {
            return this.specification;
        }

        public static JavaVersion forSpecification(String specification) {
            for (JavaVersion ver : JavaVersion.values()) {
                if (!ver.specification.equals(specification)) continue;
                return ver;
            }
            throw new UnsupportedOperationException(String.format("unsupported Java version: %s", specification));
        }
    }
}

