/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.beam.repackaged.direct_java.runners.core.DoFnRunners;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.OutputAndTimeBoundedSplittableProcessElementInvoker;
import org.apache.beam.repackaged.direct_java.runners.core.OutputWindowedValue;
import org.apache.beam.repackaged.direct_java.runners.core.ProcessFnRunner;
import org.apache.beam.repackaged.direct_java.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.DoFnLifecycleManager;
import org.apache.beam.runners.direct.DoFnLifecycleManagerRemovingTransformEvaluator;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.ParDoEvaluatorFactory;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.joda.time.Duration;
import org.joda.time.Instant;

class SplittableProcessElementsEvaluatorFactory<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>
implements TransformEvaluatorFactory {
    private final ParDoEvaluatorFactory<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> delegateFactory;
    private final ScheduledExecutorService ses;
    private final EvaluationContext evaluationContext;
    private final PipelineOptions options;

    SplittableProcessElementsEvaluatorFactory(EvaluationContext evaluationContext, PipelineOptions options) {
        this.evaluationContext = evaluationContext;
        this.options = options;
        this.delegateFactory = new ParDoEvaluatorFactory<KeyedWorkItem<byte[], KV<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, RestrictionT>>, OutputT>(evaluationContext, SplittableProcessElementsEvaluatorFactory.processFnRunnerFactory(), new CacheLoader<AppliedPTransform<?, ?, ?>, DoFnLifecycleManager>(){

            public DoFnLifecycleManager load(AppliedPTransform<?, ?, ?> application) {
                Preconditions.checkArgument((boolean)SplittableParDoViaKeyedWorkItems.ProcessElements.class.isInstance(application.getTransform()), (Object)("No know extraction of the fn from " + application));
                SplittableParDoViaKeyedWorkItems.ProcessElements transform = (SplittableParDoViaKeyedWorkItems.ProcessElements)application.getTransform();
                return DoFnLifecycleManager.of(transform.newProcessFn(transform.getFn()));
            }
        }, options);
        this.ses = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setThreadFactory(MoreExecutors.platformThreadFactory()).setNameFormat("direct-splittable-process-element-checkpoint-executor_" + this.hashCode()).build());
    }

    public <T> TransformEvaluator<T> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) throws Exception {
        TransformEvaluator<KeyedWorkItem<byte[], KV<?, RestrictionT>>> evaluator = this.createEvaluator(application, inputBundle);
        return evaluator;
    }

    @Override
    public void cleanup() throws Exception {
        this.ses.shutdownNow();
        this.delegateFactory.cleanup();
    }

    private TransformEvaluator<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>> createEvaluator(AppliedPTransform<PCollection<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple, SplittableParDoViaKeyedWorkItems.ProcessElements<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>> application, CommittedBundle<InputT> inputBundle) throws Exception {
        final SplittableParDoViaKeyedWorkItems.ProcessElements transform = (SplittableParDoViaKeyedWorkItems.ProcessElements)application.getTransform();
        DoFnLifecycleManagerRemovingTransformEvaluator<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>> evaluator = this.delegateFactory.createEvaluator(application, inputBundle.getPCollection(), inputBundle.getKey(), ((SplittableParDoViaKeyedWorkItems.ProcessElements)application.getTransform()).getSideInputs(), ((SplittableParDoViaKeyedWorkItems.ProcessElements)application.getTransform()).getMainOutputTag(), ((SplittableParDoViaKeyedWorkItems.ProcessElements)application.getTransform()).getAdditionalOutputTags().getAll(), DoFnSchemaInformation.create(), Collections.emptyMap());
        final ParDoEvaluator<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>> pde = evaluator.getParDoEvaluator();
        SplittableParDoViaKeyedWorkItems.ProcessFn processFn = (SplittableParDoViaKeyedWorkItems.ProcessFn)((ProcessFnRunner)ProcessFnRunner.class.cast(pde.getFnRunner())).getFn();
        DirectExecutionContext.DirectStepContext stepContext = pde.getStepContext();
        processFn.setStateInternalsFactory(key -> stepContext.stateInternals());
        processFn.setTimerInternalsFactory(key -> stepContext.timerInternals());
        OutputWindowedValue outputWindowedValue = new OutputWindowedValue<OutputT>(){
            private final DoFnRunners.OutputManager outputManager;
            {
                this.outputManager = pde.getOutputManager();
            }

            @Override
            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                this.outputManager.output(transform.getMainOutputTag(), WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane));
            }

            @Override
            public <AdditionalOutputT> void outputWindowedValue(TupleTag<AdditionalOutputT> tag, AdditionalOutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                this.outputManager.output(tag, WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane));
            }
        };
        processFn.setProcessElementInvoker(new OutputAndTimeBoundedSplittableProcessElementInvoker(transform.getFn(), this.options, outputWindowedValue, this.evaluationContext.createSideInputReader(transform.getSideInputs()), this.ses, 100, Duration.standardSeconds((long)1L), stepContext::bundleFinalizer));
        return evaluator;
    }

    private static <InputT, OutputT, RestrictionT> ParDoEvaluator.DoFnRunnerFactory<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> processFnRunnerFactory() {
        return (options, fn, sideInputs, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation, sideInputMapping) -> {
            SplittableParDoViaKeyedWorkItems.ProcessFn processFn = (SplittableParDoViaKeyedWorkItems.ProcessFn)fn;
            return DoFnRunners.newProcessFnRunner(processFn, options, sideInputs, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation, sideInputMapping);
        };
    }
}

