/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.AbstractLegacyArtifactStagingService;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.BeamFileSystemLegacyArtifactRetrievalService;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFileSystemLegacyArtifactStagingService
extends AbstractLegacyArtifactStagingService {
    private static final Logger LOG = LoggerFactory.getLogger(BeamFileSystemLegacyArtifactStagingService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String MANIFEST = "MANIFEST";
    public static final String ARTIFACTS = "artifacts";

    @Override
    public String getArtifactUri(String stagingSession, String encodedFileName) throws Exception {
        StagingSessionToken stagingSessionToken = StagingSessionToken.decode(stagingSession);
        ResourceId artifactDirResourceId = this.getArtifactDirResourceId(stagingSessionToken);
        return artifactDirResourceId.resolve(encodedFileName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
    }

    @Override
    public WritableByteChannel openUri(String uri) throws IOException {
        return FileSystems.create((ResourceId)FileSystems.matchNewResource((String)uri, (boolean)false), (String)"application/octet-stream");
    }

    @Override
    public void removeUri(String uri) throws IOException {
        FileSystems.delete(Collections.singletonList(FileSystems.matchNewResource((String)uri, (boolean)false)), (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
    }

    @Override
    public void removeArtifacts(String stagingSessionToken) throws Exception {
        StagingSessionToken parsedToken = StagingSessionToken.decode(stagingSessionToken);
        ResourceId dir = this.getJobDirResourceId(parsedToken);
        ResourceId manifestResourceId = dir.resolve(MANIFEST, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        LOG.debug("Removing dir {}", (Object)dir);
        if (FileSystems.match((String)manifestResourceId.toString()).status() == MatchResult.Status.OK) {
            ArtifactApi.ProxyManifest proxyManifest = BeamFileSystemLegacyArtifactRetrievalService.loadManifest(manifestResourceId);
            for (ArtifactApi.ProxyManifest.Location location : proxyManifest.getLocationList()) {
                String uri = location.getUri();
                LOG.debug("Removing artifact: {}", (Object)uri);
                FileSystems.delete(Collections.singletonList(FileSystems.matchNewResource((String)uri, (boolean)false)), (MoveOptions[])new MoveOptions[0]);
            }
            ResourceId artifactsResourceId = dir.resolve(ARTIFACTS, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
            if (!proxyManifest.getLocationList().isEmpty()) {
                LOG.debug("Removing artifacts dir: {}", (Object)artifactsResourceId);
                FileSystems.delete(Collections.singletonList(artifactsResourceId), (MoveOptions[])new MoveOptions[0]);
            }
            LOG.debug("Removing manifest: {}", (Object)manifestResourceId);
            FileSystems.delete(Collections.singletonList(manifestResourceId), (MoveOptions[])new MoveOptions[0]);
        }
        FileSystems.delete(Collections.singletonList(dir), (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
    }

    @Override
    public WritableByteChannel openManifest(String stagingSession) throws Exception {
        return FileSystems.create((ResourceId)this.getManifestFileResourceId(StagingSessionToken.decode(stagingSession)), (String)"text/plain");
    }

    @Override
    public String getRetrievalToken(String stagingSession) throws Exception {
        StagingSessionToken stagingSessionToken = StagingSessionToken.decode(stagingSession);
        ResourceId manifestResourceId = this.getManifestFileResourceId(stagingSessionToken);
        return manifestResourceId.toString();
    }

    private ResourceId getJobDirResourceId(StagingSessionToken stagingSessionToken) {
        ResourceId baseResourceId = FileSystems.matchNewResource((String)stagingSessionToken.getBasePath(), (boolean)true);
        return baseResourceId.resolve(stagingSessionToken.getSessionId(), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
    }

    private ResourceId getManifestFileResourceId(StagingSessionToken stagingSessionToken) {
        return this.getJobDirResourceId(stagingSessionToken).resolve(MANIFEST, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    private ResourceId getArtifactDirResourceId(StagingSessionToken stagingSessionToken) {
        return this.getJobDirResourceId(stagingSessionToken).resolve(ARTIFACTS, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
    }

    public static String generateStagingSessionToken(String sessionId, String basePath) {
        StagingSessionToken stagingSessionToken = new StagingSessionToken();
        stagingSessionToken.setSessionId(sessionId);
        stagingSessionToken.setBasePath(basePath);
        return stagingSessionToken.encode();
    }

    protected static class StagingSessionToken
    implements Serializable {
        private String sessionId;
        private String basePath;

        protected StagingSessionToken() {
        }

        public String getSessionId() {
            return this.sessionId;
        }

        private void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getBasePath() {
            return this.basePath;
        }

        private void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public String encode() {
            try {
                return MAPPER.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                String message = String.format("Error %s occurred while serializing %s", e.getMessage(), this);
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription(message));
            }
        }

        public static StagingSessionToken decode(String stagingSessionToken) throws Exception {
            try {
                return (StagingSessionToken)MAPPER.readValue(stagingSessionToken, StagingSessionToken.class);
            }
            catch (JsonProcessingException e) {
                String message = String.format("Unable to deserialize staging token %s. Expected format: %s. Error: %s", stagingSessionToken, "{\"sessionId\": \"sessionId\", \"basePath\": \"basePath\"}", e.getMessage());
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription(message));
            }
        }

        public String toString() {
            return "StagingSessionToken{sessionId='" + this.sessionId + "', basePath='" + this.basePath + "'}";
        }
    }
}

