/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.artifact.AbstractLegacyArtifactRetrievalService;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFileSystemLegacyArtifactRetrievalService
extends AbstractLegacyArtifactRetrievalService {
    private static final Logger LOG = LoggerFactory.getLogger(BeamFileSystemLegacyArtifactRetrievalService.class);
    private static final Cache<String, ArtifactApi.ProxyManifest> MANIFEST_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(100L).build();

    public BeamFileSystemLegacyArtifactRetrievalService() {
        super(MANIFEST_CACHE);
    }

    public static BeamFileSystemLegacyArtifactRetrievalService create() {
        return new BeamFileSystemLegacyArtifactRetrievalService();
    }

    @Override
    public InputStream openUri(String retrievalToken, String uri) throws IOException {
        ResourceId artifactResourceId = FileSystems.matchNewResource((String)uri, (boolean)false);
        return Channels.newInputStream(FileSystems.open((ResourceId)artifactResourceId));
    }

    @Override
    public InputStream openManifest(String retrievalToken) throws IOException {
        ResourceId manifestResourceId = BeamFileSystemLegacyArtifactRetrievalService.getManifestLocationFromToken(retrievalToken);
        try {
            return Channels.newInputStream(FileSystems.open((ResourceId)manifestResourceId));
        }
        catch (IOException e) {
            LOG.warn("GetManifest for {} failed. Make sure the artifact staging directory (configurable via --artifacts-dir argument to the job server) is accessible to workers.", (Object)retrievalToken, (Object)e);
            throw e;
        }
    }

    @VisibleForTesting
    static ArtifactApi.ProxyManifest loadManifest(String retrievalToken) throws IOException {
        LOG.info("Loading manifest for retrieval token {}", (Object)retrievalToken);
        ResourceId manifestResourceId = BeamFileSystemLegacyArtifactRetrievalService.getManifestLocationFromToken(retrievalToken);
        return BeamFileSystemLegacyArtifactRetrievalService.loadManifest(manifestResourceId);
    }

    static ArtifactApi.ProxyManifest loadManifest(ResourceId manifestResourceId) throws IOException {
        return BeamFileSystemLegacyArtifactRetrievalService.loadManifest(Channels.newInputStream(FileSystems.open((ResourceId)manifestResourceId)), manifestResourceId.toString());
    }

    private static ResourceId getManifestLocationFromToken(String retrievalToken) {
        return FileSystems.matchNewResource((String)retrievalToken, (boolean)false);
    }
}

