/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GreedyPCollectionFusers {
    private static final Logger LOG = LoggerFactory.getLogger(GreedyPCollectionFusers.class);
    private static final Map<String, FusibilityChecker> URN_FUSIBILITY_CHECKERS = ImmutableMap.builder().put((Object)"beam:transform:pardo:v1", GreedyPCollectionFusers::canFuseParDo).put((Object)"beam:transform:sdf_pair_with_restriction:v1", GreedyPCollectionFusers::canFuseParDo).put((Object)"beam:transform:sdf_split_restriction:v1", GreedyPCollectionFusers::canFuseParDo).put((Object)"beam:transform:sdf_process_keyed_elements:v1", GreedyPCollectionFusers::cannotFuse).put((Object)"beam:transform:sdf_process_elements:v1", GreedyPCollectionFusers::cannotFuse).put((Object)"beam:transform:sdf_split_and_size_restrictions:v1", GreedyPCollectionFusers::canFuseParDo).put((Object)"beam:transform:sdf_process_sized_element_and_restrictions:v1", GreedyPCollectionFusers::cannotFuse).put((Object)"beam:transform:combine_per_key_precombine:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put((Object)"beam:transform:combine_per_key_merge_accumulators:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put((Object)"beam:transform:combine_per_key_extract_outputs:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put((Object)"beam:transform:window_into:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put((Object)"beam:transform:flatten:v1", GreedyPCollectionFusers::canAlwaysFuse).put((Object)"beam:transform:group_by_key:v1", GreedyPCollectionFusers::cannotFuse).put((Object)"beam:transform:create_view:v1", GreedyPCollectionFusers::cannotFuse).build();
    private static final FusibilityChecker DEFAULT_FUSIBILITY_CHECKER = GreedyPCollectionFusers::unknownTransformFusion;
    private static final Map<String, CompatibilityChecker> URN_COMPATIBILITY_CHECKERS = ImmutableMap.builder().put((Object)"beam:transform:pardo:v1", GreedyPCollectionFusers::parDoCompatibility).put((Object)"beam:transform:sdf_pair_with_restriction:v1", GreedyPCollectionFusers::parDoCompatibility).put((Object)"beam:transform:sdf_split_and_size_restrictions:v1", GreedyPCollectionFusers::parDoCompatibility).put((Object)"beam:transform:sdf_process_sized_element_and_restrictions:v1", GreedyPCollectionFusers::parDoCompatibility).put((Object)"beam:transform:combine_per_key_precombine:v1", GreedyPCollectionFusers::compatibleEnvironments).put((Object)"beam:transform:combine_per_key_merge_accumulators:v1", GreedyPCollectionFusers::compatibleEnvironments).put((Object)"beam:transform:combine_per_key_extract_outputs:v1", GreedyPCollectionFusers::compatibleEnvironments).put((Object)"beam:transform:window_into:v1", GreedyPCollectionFusers::compatibleEnvironments).put((Object)"beam:transform:flatten:v1", GreedyPCollectionFusers::noCompatibility).put((Object)"beam:transform:group_by_key:v1", GreedyPCollectionFusers::noCompatibility).put((Object)"beam:transform:create_view:v1", GreedyPCollectionFusers::noCompatibility).build();
    private static final CompatibilityChecker DEFAULT_COMPATIBILITY_CHECKER = GreedyPCollectionFusers::unknownTransformCompatibility;

    GreedyPCollectionFusers() {
    }

    public static boolean canFuse(PipelineNode.PTransformNode transformNode, RunnerApi.Environment environment, PipelineNode.PCollectionNode candidate, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        return URN_FUSIBILITY_CHECKERS.getOrDefault(transformNode.getTransform().getSpec().getUrn(), DEFAULT_FUSIBILITY_CHECKER).canFuse(transformNode, environment, candidate, stagePCollections, pipeline);
    }

    public static boolean isCompatible(PipelineNode.PTransformNode left, PipelineNode.PTransformNode right, QueryablePipeline pipeline) {
        CompatibilityChecker leftChecker = URN_COMPATIBILITY_CHECKERS.getOrDefault(left.getTransform().getSpec().getUrn(), DEFAULT_COMPATIBILITY_CHECKER);
        CompatibilityChecker rightChecker = URN_COMPATIBILITY_CHECKERS.getOrDefault(right.getTransform().getSpec().getUrn(), DEFAULT_COMPATIBILITY_CHECKER);
        return leftChecker.isCompatible(left, right, pipeline) && rightChecker.isCompatible(right, left, pipeline);
    }

    private static boolean canFuseParDo(PipelineNode.PTransformNode parDo, RunnerApi.Environment environment, PipelineNode.PCollectionNode candidate, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        Optional<RunnerApi.Environment> env = pipeline.getEnvironment(parDo);
        Preconditions.checkArgument((boolean)env.isPresent(), (String)"A %s must have an %s associated with it", (Object)RunnerApi.ParDoPayload.class.getSimpleName(), (Object)RunnerApi.Environment.class.getSimpleName());
        if (!env.get().equals((Object)environment)) {
            return false;
        }
        try {
            RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)parDo.getTransform().getSpec().getPayload());
            if (Maps.filterKeys((Map)parDo.getTransform().getInputsMap(), s -> payload.getTimerFamilySpecsMap().containsKey(s)).values().contains(candidate.getId())) {
                return true;
            }
            if (payload.getStateSpecsCount() > 0 || payload.getTimerFamilySpecsCount() > 0) {
                return false;
            }
            if (!pipeline.getSideInputs(parDo).isEmpty()) {
                return false;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
        return true;
    }

    private static boolean parDoCompatibility(PipelineNode.PTransformNode parDo, PipelineNode.PTransformNode other, QueryablePipeline pipeline) {
        return parDo.equals(other) || pipeline.getSideInputs(parDo).isEmpty() && pipeline.getUserStates(parDo).isEmpty() && pipeline.getTimers(parDo).isEmpty() && GreedyPCollectionFusers.compatibleEnvironments(parDo, other, pipeline);
    }

    private static boolean canFuseCompatibleEnvironment(PipelineNode.PTransformNode operation, RunnerApi.Environment environment, PipelineNode.PCollectionNode candidate, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        Optional<RunnerApi.Environment> operationEnvironment = pipeline.getEnvironment(operation);
        return environment.equals(operationEnvironment.orElse(null));
    }

    private static boolean compatibleEnvironments(PipelineNode.PTransformNode left, PipelineNode.PTransformNode right, QueryablePipeline pipeline) {
        return pipeline.getEnvironment(left).equals(pipeline.getEnvironment(right));
    }

    private static boolean canAlwaysFuse(PipelineNode.PTransformNode flatten, RunnerApi.Environment environment, PipelineNode.PCollectionNode candidate, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        return true;
    }

    private static boolean cannotFuse(PipelineNode.PTransformNode cannotFuse, RunnerApi.Environment environment, PipelineNode.PCollectionNode candidate, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        return false;
    }

    private static boolean noCompatibility(PipelineNode.PTransformNode self, PipelineNode.PTransformNode other, QueryablePipeline pipeline) {
        return false;
    }

    private static boolean unknownTransformFusion(PipelineNode.PTransformNode transform, RunnerApi.Environment environment, PipelineNode.PCollectionNode candidate, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        LOG.debug("Unknown {} {} will not fuse into an existing {}", new Object[]{RunnerApi.PTransform.class.getSimpleName(), transform.getTransform(), ExecutableStage.class.getSimpleName(), RunnerApi.PTransform.class.getSimpleName()});
        return false;
    }

    private static boolean unknownTransformCompatibility(PipelineNode.PTransformNode transform, PipelineNode.PTransformNode other, QueryablePipeline pipeline) {
        LOG.debug("Unknown {} {} will not root a {} with other {}", new Object[]{RunnerApi.PTransform.class.getSimpleName(), transform.getTransform(), ExecutableStage.class.getSimpleName(), RunnerApi.PTransform.class.getSimpleName()});
        return false;
    }

    private static interface CompatibilityChecker {
        public boolean isCompatible(PipelineNode.PTransformNode var1, PipelineNode.PTransformNode var2, QueryablePipeline var3);
    }

    private static interface FusibilityChecker {
        public boolean canFuse(PipelineNode.PTransformNode var1, RunnerApi.Environment var2, PipelineNode.PCollectionNode var3, Collection<PipelineNode.PCollectionNode> var4, QueryablePipeline var5);
    }
}

