/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.metrics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Function;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Predicate;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.FluentIterable;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.DistributionData;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.GaugeData;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricFiltering;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricKey;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricUpdates;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;

public class MetricsContainerStepMap
implements Serializable {
    private Map<String, MetricsContainerImpl> metricsContainers = new ConcurrentHashMap<String, MetricsContainerImpl>();

    public MetricsContainerImpl getContainer(String stepName) {
        if (!this.metricsContainers.containsKey(stepName)) {
            this.metricsContainers.put(stepName, new MetricsContainerImpl(stepName));
        }
        return this.metricsContainers.get(stepName);
    }

    public void updateAll(MetricsContainerStepMap other) {
        for (Map.Entry<String, MetricsContainerImpl> container : other.metricsContainers.entrySet()) {
            this.getContainer(container.getKey()).update(container.getValue());
        }
    }

    public void update(String step, MetricsContainerImpl container) {
        this.getContainer(step).update(container);
    }

    public static MetricResults asMetricResults(MetricsContainerStepMap attemptedMetricsContainers, MetricsContainerStepMap committedMetricsContainers) {
        return new MetricsContainerStepMapMetricResults(attemptedMetricsContainers, committedMetricsContainers);
    }

    public static MetricResults asAttemptedOnlyMetricResults(MetricsContainerStepMap attemptedMetricsContainers) {
        return new MetricsContainerStepMapMetricResults(attemptedMetricsContainers);
    }

    private Map<String, MetricsContainerImpl> getMetricsContainers() {
        return this.metricsContainers;
    }

    private static class MetricsContainerStepMapMetricResults
    extends MetricResults {
        private final Map<MetricKey, AttemptedAndCommitted<Long>> counters = new HashMap<MetricKey, AttemptedAndCommitted<Long>>();
        private final Map<MetricKey, AttemptedAndCommitted<DistributionData>> distributions = new HashMap<MetricKey, AttemptedAndCommitted<DistributionData>>();
        private final Map<MetricKey, AttemptedAndCommitted<GaugeData>> gauges = new HashMap<MetricKey, AttemptedAndCommitted<GaugeData>>();
        private final boolean isCommittedSupported;

        private MetricsContainerStepMapMetricResults(MetricsContainerStepMap attemptedMetricsContainers) {
            this(attemptedMetricsContainers, new MetricsContainerStepMap(), false);
        }

        private MetricsContainerStepMapMetricResults(MetricsContainerStepMap attemptedMetricsContainers, MetricsContainerStepMap committedMetricsContainers) {
            this(attemptedMetricsContainers, committedMetricsContainers, true);
        }

        private MetricsContainerStepMapMetricResults(MetricsContainerStepMap attemptedMetricsContainers, MetricsContainerStepMap committedMetricsContainers, boolean isCommittedSupported) {
            MetricUpdates cumulative;
            for (MetricsContainerImpl container : attemptedMetricsContainers.getMetricsContainers().values()) {
                cumulative = container.getCumulative();
                this.mergeCounters(this.counters, cumulative.counterUpdates(), this.attemptedCounterUpdateFn());
                this.mergeDistributions(this.distributions, cumulative.distributionUpdates(), this.attemptedDistributionUpdateFn());
                this.mergeGauges(this.gauges, cumulative.gaugeUpdates(), this.attemptedGaugeUpdateFn());
            }
            for (MetricsContainerImpl container : committedMetricsContainers.getMetricsContainers().values()) {
                cumulative = container.getCumulative();
                this.mergeCounters(this.counters, cumulative.counterUpdates(), this.committedCounterUpdateFn());
                this.mergeDistributions(this.distributions, cumulative.distributionUpdates(), this.committedDistributionUpdateFn());
                this.mergeGauges(this.gauges, cumulative.gaugeUpdates(), this.committedGaugeUpdateFn());
            }
            this.isCommittedSupported = isCommittedSupported;
        }

        private Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>> attemptedDistributionUpdateFn() {
            return new Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>>(){

                @Override
                public AttemptedAndCommitted<DistributionData> apply(MetricUpdates.MetricUpdate<DistributionData> input) {
                    MetricKey key = input.getKey();
                    return new AttemptedAndCommitted<DistributionData>(key, input, MetricUpdates.MetricUpdate.create(key, DistributionData.EMPTY));
                }
            };
        }

        private Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>> committedDistributionUpdateFn() {
            return new Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>>(){

                @Override
                public AttemptedAndCommitted<DistributionData> apply(MetricUpdates.MetricUpdate<DistributionData> input) {
                    MetricKey key = input.getKey();
                    return new AttemptedAndCommitted<DistributionData>(key, MetricUpdates.MetricUpdate.create(key, DistributionData.EMPTY), input);
                }
            };
        }

        private Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>> attemptedGaugeUpdateFn() {
            return new Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>>(){

                @Override
                public AttemptedAndCommitted<GaugeData> apply(MetricUpdates.MetricUpdate<GaugeData> input) {
                    MetricKey key = input.getKey();
                    return new AttemptedAndCommitted<GaugeData>(key, input, MetricUpdates.MetricUpdate.create(key, GaugeData.empty()));
                }
            };
        }

        private Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>> committedGaugeUpdateFn() {
            return new Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>>(){

                @Override
                public AttemptedAndCommitted<GaugeData> apply(MetricUpdates.MetricUpdate<GaugeData> input) {
                    MetricKey key = input.getKey();
                    return new AttemptedAndCommitted<GaugeData>(key, MetricUpdates.MetricUpdate.create(key, GaugeData.empty()), input);
                }
            };
        }

        private Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>> attemptedCounterUpdateFn() {
            return new Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>>(){

                @Override
                public AttemptedAndCommitted<Long> apply(MetricUpdates.MetricUpdate<Long> input) {
                    MetricKey key = input.getKey();
                    return new AttemptedAndCommitted<Long>(key, input, MetricUpdates.MetricUpdate.create(key, 0L));
                }
            };
        }

        private Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>> committedCounterUpdateFn() {
            return new Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>>(){

                @Override
                public AttemptedAndCommitted<Long> apply(MetricUpdates.MetricUpdate<Long> input) {
                    MetricKey key = input.getKey();
                    return new AttemptedAndCommitted<Long>(key, MetricUpdates.MetricUpdate.create(key, 0L), input);
                }
            };
        }

        public MetricQueryResults queryMetrics(MetricsFilter filter) {
            return new QueryResults(filter);
        }

        private Function<AttemptedAndCommitted<Long>, MetricResult<Long>> counterUpdateToResult() {
            return new Function<AttemptedAndCommitted<Long>, MetricResult<Long>>(){

                @Override
                public MetricResult<Long> apply(AttemptedAndCommitted<Long> metricResult) {
                    MetricKey key = ((AttemptedAndCommitted)metricResult).getKey();
                    return new AccumulatedMetricResult<Long>(key.metricName(), key.stepName(), ((AttemptedAndCommitted)metricResult).getAttempted().getUpdate(), MetricsContainerStepMapMetricResults.this.isCommittedSupported ? (Long)((AttemptedAndCommitted)metricResult).getCommitted().getUpdate() : null, MetricsContainerStepMapMetricResults.this.isCommittedSupported);
                }
            };
        }

        private Function<AttemptedAndCommitted<DistributionData>, MetricResult<DistributionResult>> distributionUpdateToResult() {
            return new Function<AttemptedAndCommitted<DistributionData>, MetricResult<DistributionResult>>(){

                @Override
                public MetricResult<DistributionResult> apply(AttemptedAndCommitted<DistributionData> metricResult) {
                    MetricKey key = ((AttemptedAndCommitted)metricResult).getKey();
                    return new AccumulatedMetricResult<DistributionResult>(key.metricName(), key.stepName(), ((DistributionData)((AttemptedAndCommitted)metricResult).getAttempted().getUpdate()).extractResult(), MetricsContainerStepMapMetricResults.this.isCommittedSupported ? ((DistributionData)((AttemptedAndCommitted)metricResult).getCommitted().getUpdate()).extractResult() : null, MetricsContainerStepMapMetricResults.this.isCommittedSupported);
                }
            };
        }

        private Function<AttemptedAndCommitted<GaugeData>, MetricResult<GaugeResult>> gaugeUpdateToResult() {
            return new Function<AttemptedAndCommitted<GaugeData>, MetricResult<GaugeResult>>(){

                @Override
                public MetricResult<GaugeResult> apply(AttemptedAndCommitted<GaugeData> metricResult) {
                    MetricKey key = ((AttemptedAndCommitted)metricResult).getKey();
                    return new AccumulatedMetricResult<GaugeResult>(key.metricName(), key.stepName(), ((GaugeData)((AttemptedAndCommitted)metricResult).getAttempted().getUpdate()).extractResult(), MetricsContainerStepMapMetricResults.this.isCommittedSupported ? ((GaugeData)((AttemptedAndCommitted)metricResult).getCommitted().getUpdate()).extractResult() : null, MetricsContainerStepMapMetricResults.this.isCommittedSupported);
                }
            };
        }

        private void mergeCounters(Map<MetricKey, AttemptedAndCommitted<Long>> counters, Iterable<MetricUpdates.MetricUpdate<Long>> updates, Function<MetricUpdates.MetricUpdate<Long>, AttemptedAndCommitted<Long>> updateToAttemptedAndCommittedFn) {
            for (MetricUpdates.MetricUpdate<Long> metricUpdate : updates) {
                MetricKey key = metricUpdate.getKey();
                AttemptedAndCommitted<Long> update = updateToAttemptedAndCommittedFn.apply(metricUpdate);
                if (counters.containsKey(key)) {
                    AttemptedAndCommitted<Long> current = counters.get(key);
                    update = new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, (Long)((AttemptedAndCommitted)update).getAttempted().getUpdate() + (Long)((AttemptedAndCommitted)current).getAttempted().getUpdate()), MetricUpdates.MetricUpdate.create(key, (Long)((AttemptedAndCommitted)update).getCommitted().getUpdate() + (Long)((AttemptedAndCommitted)current).getCommitted().getUpdate()));
                }
                counters.put(key, update);
            }
        }

        private void mergeDistributions(Map<MetricKey, AttemptedAndCommitted<DistributionData>> distributions, Iterable<MetricUpdates.MetricUpdate<DistributionData>> updates, Function<MetricUpdates.MetricUpdate<DistributionData>, AttemptedAndCommitted<DistributionData>> updateToAttemptedAndCommittedFn) {
            for (MetricUpdates.MetricUpdate<DistributionData> metricUpdate : updates) {
                MetricKey key = metricUpdate.getKey();
                AttemptedAndCommitted<DistributionData> update = updateToAttemptedAndCommittedFn.apply(metricUpdate);
                if (distributions.containsKey(key)) {
                    AttemptedAndCommitted<DistributionData> current = distributions.get(key);
                    update = new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, ((DistributionData)((AttemptedAndCommitted)update).getAttempted().getUpdate()).combine((DistributionData)((AttemptedAndCommitted)current).getAttempted().getUpdate())), MetricUpdates.MetricUpdate.create(key, ((DistributionData)((AttemptedAndCommitted)update).getCommitted().getUpdate()).combine((DistributionData)((AttemptedAndCommitted)current).getCommitted().getUpdate())));
                }
                distributions.put(key, update);
            }
        }

        private void mergeGauges(Map<MetricKey, AttemptedAndCommitted<GaugeData>> gauges, Iterable<MetricUpdates.MetricUpdate<GaugeData>> updates, Function<MetricUpdates.MetricUpdate<GaugeData>, AttemptedAndCommitted<GaugeData>> updateToAttemptedAndCommittedFn) {
            for (MetricUpdates.MetricUpdate<GaugeData> metricUpdate : updates) {
                MetricKey key = metricUpdate.getKey();
                AttemptedAndCommitted<GaugeData> update = updateToAttemptedAndCommittedFn.apply(metricUpdate);
                if (gauges.containsKey(key)) {
                    AttemptedAndCommitted<GaugeData> current = gauges.get(key);
                    update = new AttemptedAndCommitted(key, MetricUpdates.MetricUpdate.create(key, ((GaugeData)((AttemptedAndCommitted)update).getAttempted().getUpdate()).combine((GaugeData)((AttemptedAndCommitted)current).getAttempted().getUpdate())), MetricUpdates.MetricUpdate.create(key, ((GaugeData)((AttemptedAndCommitted)update).getCommitted().getUpdate()).combine((GaugeData)((AttemptedAndCommitted)current).getCommitted().getUpdate())));
                }
                gauges.put(key, update);
            }
        }

        private static class AttemptedAndCommitted<T> {
            private final MetricKey key;
            private final MetricUpdates.MetricUpdate<T> attempted;
            private final MetricUpdates.MetricUpdate<T> committed;

            private AttemptedAndCommitted(MetricKey key, MetricUpdates.MetricUpdate<T> attempted, MetricUpdates.MetricUpdate<T> committed) {
                this.key = key;
                this.attempted = attempted;
                this.committed = committed;
            }

            private MetricKey getKey() {
                return this.key;
            }

            private MetricUpdates.MetricUpdate<T> getAttempted() {
                return this.attempted;
            }

            private MetricUpdates.MetricUpdate<T> getCommitted() {
                return this.committed;
            }
        }

        private static class AccumulatedMetricResult<T>
        implements MetricResult<T> {
            private final MetricName name;
            private final String step;
            private final T attempted;
            private final T committed;
            private final boolean isCommittedSupported;

            private AccumulatedMetricResult(MetricName name, String step, T attempted, T committed, boolean isCommittedSupported) {
                this.name = name;
                this.step = step;
                this.attempted = attempted;
                this.committed = committed;
                this.isCommittedSupported = isCommittedSupported;
            }

            public MetricName name() {
                return this.name;
            }

            public String step() {
                return this.step;
            }

            public T committed() {
                if (!this.isCommittedSupported) {
                    throw new UnsupportedOperationException("This runner does not currently support committed metrics results. Please use 'attempted' instead.");
                }
                return this.committed;
            }

            public T attempted() {
                return this.attempted;
            }
        }

        private class QueryResults
        implements MetricQueryResults {
            private final MetricsFilter filter;

            private QueryResults(MetricsFilter filter) {
                this.filter = filter;
            }

            public Iterable<MetricResult<Long>> counters() {
                return FluentIterable.from(MetricsContainerStepMapMetricResults.this.counters.values()).filter(this.matchesFilter(this.filter)).transform(MetricsContainerStepMapMetricResults.this.counterUpdateToResult()).toList();
            }

            public Iterable<MetricResult<DistributionResult>> distributions() {
                return FluentIterable.from(MetricsContainerStepMapMetricResults.this.distributions.values()).filter(this.matchesFilter(this.filter)).transform(MetricsContainerStepMapMetricResults.this.distributionUpdateToResult()).toList();
            }

            public Iterable<MetricResult<GaugeResult>> gauges() {
                return FluentIterable.from(MetricsContainerStepMapMetricResults.this.gauges.values()).filter(this.matchesFilter(this.filter)).transform(MetricsContainerStepMapMetricResults.this.gaugeUpdateToResult()).toList();
            }

            private Predicate<AttemptedAndCommitted<?>> matchesFilter(final MetricsFilter filter) {
                return new Predicate<AttemptedAndCommitted<?>>(){

                    @Override
                    public boolean apply(AttemptedAndCommitted<?> attemptedAndCommitted) {
                        return MetricFiltering.matches(filter, ((AttemptedAndCommitted)attemptedAndCommitted).getKey());
                    }
                };
            }
        }
    }
}

